 select distinct cg.idkey as idcadastro
   from tribdebito deb
   join tribcadastrogeral cg on deb.tipocadastro = cg.tipocadastro
    and deb.cadastrogeral    = cg.cadastrogeral
   join tribdebitoparcela par on deb.entidade = par.entidade
    and deb.exercicio        = par.exercicio
    and deb.tipocadastro     = par.tipocadastro
    and deb.cadastrogeral    = par.cadastrogeral
    and deb.guiarecolhimento = par.guiarecolhimento
    and deb.subdivida        = par.subdivida
   join tribsituacaoparcela sit on sit.situacaoparcela = par.situacaodebito
   join tribguiarecolhimento guia on deb.entidade = guia.entidade
    and deb.exercicio        = guia.exercicio
    and deb.guiarecolhimento = guia.guiarecolhimento
   join tribguiarecolhimentoformapag fpag on deb.entidade = fpag.entidade
    and deb.exercicio        = fpag.exercicio
    and deb.guiarecolhimento = fpag.guiarecolhimento
   join tribformapagamento fp on fp.formapagamento = fpag.formapagamento
  where deb.entidade           = :entidade
    and deb.exercicio          = :exercicio
    and deb.constituido        = 'S'
    and fpag.disponivelweb     = 'S'
    and fpag.vencimento       >= :dataVencimento
    and sit.tiposituacaoparcela = 1
    and cg.exclusaologica      = 'N'
    and ( (fp.tipoformapagamento <> 'U' AND EXISTS(
                 select 1
                   from tribdebitoparcela parsub
                   join tribsituacaoparcela sitsub on sitsub.situacaoparcela     = parsub.situacaodebito
                   join tribtiposituacaoparcela tipsub on sitsub.tiposituacaoparcela = tipsub.tiposituacaoparcela
                  where parsub.entidade            = deb.entidade
                    and parsub.exercicio           = deb.exercicio
                    and parsub.tipocadastro        = deb.tipocadastro
                    and parsub.cadastrogeral       = deb.cadastrogeral
                    and parsub.guiarecolhimento    = deb.guiarecolhimento
                    and parsub.subdivida           = deb.subdivida
                    and parsub.datavencimento     >= :dataVencimento
                    and tipsub.tipo = 'A'))
 or
   (fp.tipoformapagamento = 'U'
    and not exists (select 1
                     from tribdebitoparcela parsub
                     join tribsituacaoparcela sitsub on sitsub.situacaoparcela     = parsub.situacaodebito
                     join tribtiposituacaoparcela tipsub on sitsub.tiposituacaoparcela = tipsub.tiposituacaoparcela
                    where parsub.entidade            = deb.entidade
                      and parsub.exercicio           = deb.exercicio
                      and parsub.tipocadastro        = deb.tipocadastro
                      and parsub.cadastrogeral       = deb.cadastrogeral
                      and parsub.guiarecolhimento    = deb.guiarecolhimento
                      and parsub.subdivida           = deb.subdivida
                      and tipsub.tipo <> 'A')
 ))