select distinct
       trdad.idremdebitoautomaticodet as id,
       p.nome,
       trdad.entidade,
       trdad.exercicio,
       trdad.tipocadastro,
       trdad.cadastrogeral,
       trdad.guiarecolhimento as divida,
       trdad.subdivida,
       trdad.parcela,
       tdeb.iddebito,
       trdad.exerciciobloqueto,
       trdad.bloqueto,
       tb.idkey as idbloqueto
from tribremdebitoautomaticodetalhe trdad
left join tribdebitoparcela tdp
 on trdad.entidade = tdp.entidade
and trdad.exercicio = tdp.exercicio
and trdad.tipocadastro = tdp.tipocadastro
and trdad.cadastrogeral = tdp.cadastrogeral
and trdad.guiarecolhimento = tdp.guiarecolhimento
and trdad.subdivida = tdp.subdivida
and (trdad.parcela is null or (trdad.parcela is not null and trdad.parcela = tdp.parcela))
left join tribdebito tdeb
 on tdp.Entidade = tdeb.Entidade
and tdp.Exercicio = tdeb.Exercicio
and tdp.TipoCadastro = tdeb.TipoCadastro
and tdp.CadastroGeral = tdeb.CadastroGeral
and tdp.GuiaRecolhimento = tdeb.GuiaRecolhimento
and tdp.SubDivida = tdeb.SubDivida
left join tribcadastrogeral cg
 on tdeb.tipocadastro = cg.tipocadastro
and tdeb.cadastrogeral = cg.cadastrogeral
left join pessoa p
 on cg.pessoa = p.pessoa
left join tribbloqueto tb
 on trdad.entidade = tb.entidade
and trdad.exerciciobloqueto = tb.exerciciobloqueto
and trdad.bloqueto = tb.bloqueto
where trdad.idremdebitoautomatico = :idRemessa
order by trdad.exercicio,trdad.tipocadastro,trdad.cadastrogeral,trdad.guiarecolhimento,trdad.subdivida
