select TRIBCADASTROGERAL.TIPOCADASTRO                                                                     	   AS TIPOCADASTRO,
       TRIBCADASTROGERAL.CADASTROGERAL                                                                    	   AS CADASTROGERAL,
       TRIBCADASTROGERAL.PESSOA                                                                           	   AS PESSOA,
       TRIBDEBITO.ENTIDADE																				  	   AS ENTIDADE,
       TRIBDEBITO.EXERCICIO                                                                               	   AS EXERCICIO,
       TRIBDEBITO.GUIARECOLHIMENTO 																		  	   AS DIVIDA,
       TRIBDEBITO.SUBDIVIDA 																			  	   AS SUBDIVIDA,
       TRIBDEBITOPARCELARECEITA.RECEITA 																  	   AS TRIBUTO,
       TRIBDEBITO.DATALANCAMENTO                                                                               AS DATALANCAMENTO,
       TRIBDEBITOPARCELA.DATAVENCIMENTO 																  	   AS DATAVENCIMENTO,
       TRIBDEBITO.DATAPRIMEIRAPARCELA 																	  	   AS DATAPRIMEIRAPARCELA,
       TRIBDEBITO.DATACORRECAOIGPM   																	  	   AS DATACORRECAOIGPM,
       TRIBDEBITOPARCELA.SITUACAOLEGAL 																	  	   AS SITUACAOLEGAL,
       TRIBDEBITOPARCELARECEITA.VALOR 																	  	   AS VALORPRINCIPAL,
       TRIBDEBITO.FORMACORRECAO 																		  	   AS FORMACORRECAO,
       CASE WHEN TRIBDEBITO.CONSTITUIDO  = 'S' THEN 1 ELSE 0 END 										  	   AS CONSTITUIDO,
       CASE WHEN TRIBDEBITO.PARCELADO = 'S' THEN 1 ELSE 0 END 											  	   AS PARCELADO,
       CASE WHEN TRIBDEBITO.REPARCELADO = 'S' THEN 1 ELSE 0 END 										  	   AS REPARCELADO,
       TRIBDEBITOPARCELARECEITA.IDDEBITOPARCELARECEITA  									 			  	   AS IDDEBITOPARCELARECEITA,
       TRIBDEBITO.IDDEBITO 																				  	   AS IDDEBITO,
       TRIBDEBITOPARCELARECEITA.PARCELA 																  	   AS PARCELA,
       CASE WHEN TRIBGUIARECOLHIMENTO.EMITEBLOQUETO = 'S' THEN 1 ELSE 0 END 							  	   AS EMITEBOLETO,
       TRIBGUIARECOLHIMENTO.DESCRICAO 																	  	   AS DESCRICAODIVIDA,
       TRIBTIPOSITUACAOPARCELA.TIPOSITUACAOPARCELA 														  	   AS TIPOSITUACAOPARCELA,
       TRIBDEBITOPARCELA.IDPROTESTO 																	  	   AS IDPROTESTO,
       TRIBSITUACAOPARCELA.DESCRICAO 																	  	   AS SITUACAODEBITODESCRICAO,
       TRIBSITUACAOPARCELA.SIGLA 																		  	   AS SITUACAODEBITOSIGLA,
       COALESCE(TRIBDEBITO.NOPROCESSOCOMUMUNICA, CAST(TRIBDEBITOPARCELA.PROCESSOJUDICIAL AS VARCHAR(30))) 	   AS NOPROCESSOCOMUMUNICA,
       TRIBPARCELAMENTO.IDPARCELAMENTO 																	  	   AS IDPARCELAMENTO,
       TRIBDEBITO.DESCONTOLEI2004                                                                              AS DESCONTOPARCELAMENTO,
       TRIBDEBITO.DESCONTOMULTAPAGTOEMDIA                                                                      AS DESCONTOMULTAPARCELAMENTO,
       TRIBDEBITO.DESCONTOJUROSPAGTOEMDIA                                                                      AS DESCONTOJUROSPARCELAMENTO,
       TRIBDEBITO.DESCONTOJUROSFINANPAGTOEMDIA                                                                 AS DESCONTOJUROSFINANPARCELAMENTO,
       COALESCE(TRIBPARCELAMENTO.PORCONTRIBUINTE,'N') 														   AS PORCONTRIBUINTE,
       TRIBPARCELAMENTO.NUMEROCONTRATO 																	  	   AS NUMEROPARCELAMENTO,
       TRIBPARCELAMENTO.ANOCONTRATO  																		   AS EXERCICIOPARCELAMENTO,
       TRIBGUIARECOLHIMENTO.PASSIVELREFIS                                                                      AS PASSIVELREFIS,
       TR.CLASSIFICACAO                                                                                        AS CLASSIFICACAOTRIBUTO,
       TRT.CLASSIFICACAORECEITATIPO                                                                            as CLASSIFICACAOTIPOTRIBUTO,
       (SELECT CASE ESTORNADO WHEN 'N' THEN 1 ELSE 0 END
       	FROM TRIBESTORNOPARCELAMENTO ESTORNOPARC
       	WHERE ESTORNOPARC.IDESTORNOPARCELAMENTO = ( SELECT MAX(IDESTORNOPARCELAMENTO)
       											  FROM TRIBESTORNOPARCELAMENTODEBITO ESTORNOPARCDEB
       											  WHERE ESTORNOPARCDEB.IDDEBITODESTINO = TRIBDEBITO.IDDEBITO)) AS  ORIUNDOESTORNOCONTRATO,
        TRIBPROTESTOREMESSAITEM.CARTORIO                                                                       AS CARTORIO,
        min(tdida.idcertidao)        						  	  											   AS IDCERTIDAO,
        min(tdida.documento)  																			   	   AS NUMEROCERTIDAO,
        min(tdida.exercicio)  									   									   		   AS EXERCICIOCERTIDAO,
        TRIBGUIARECOLHIMENTO.SUPERSIMPLES 																	   AS SUPERSIMPLES,
        TRIBGUIARECOLHIMENTO.DATALIMITEVENCIMENTOBOLETO                                                        AS DATALIMITEVENCIMENTOBOLETO
    FROM TRIBDEBITO TRIBDEBITO
    INNER JOIN TRIBDEBITOPARCELA TRIBDEBITOPARCELA ON TRIBDEBITO.ENTIDADE         = TRIBDEBITOPARCELA.ENTIDADE
												  AND TRIBDEBITO.EXERCICIO        = TRIBDEBITOPARCELA.EXERCICIO
												  AND TRIBDEBITO.TIPOCADASTRO     = TRIBDEBITOPARCELA.TIPOCADASTRO
												  AND TRIBDEBITO.CADASTROGERAL    = TRIBDEBITOPARCELA.CADASTROGERAL
												  AND TRIBDEBITO.GUIARECOLHIMENTO = TRIBDEBITOPARCELA.GUIARECOLHIMENTO
												  AND TRIBDEBITO.SUBDIVIDA        = TRIBDEBITOPARCELA.SUBDIVIDA
	INNER JOIN TRIBDEBITOPARCELARECEITA TRIBDEBITOPARCELARECEITA ON TRIBDEBITOPARCELARECEITA.ENTIDADE         = TRIBDEBITOPARCELA.ENTIDADE
															    AND TRIBDEBITOPARCELARECEITA.EXERCICIO        = TRIBDEBITOPARCELA.EXERCICIO
															    AND TRIBDEBITOPARCELARECEITA.TIPOCADASTRO     = TRIBDEBITOPARCELA.TIPOCADASTRO
															    AND TRIBDEBITOPARCELARECEITA.CADASTROGERAL    = TRIBDEBITOPARCELA.CADASTROGERAL
															    AND TRIBDEBITOPARCELARECEITA.GUIARECOLHIMENTO = TRIBDEBITOPARCELA.GUIARECOLHIMENTO
															    AND TRIBDEBITOPARCELARECEITA.SUBDIVIDA        = TRIBDEBITOPARCELA.SUBDIVIDA
															    AND TRIBDEBITOPARCELARECEITA.PARCELA          = TRIBDEBITOPARCELA.PARCELA
	INNER JOIN TRIBCADASTROGERAL TRIBCADASTROGERAL ON TRIBDEBITO.TIPOCADASTRO  = TRIBCADASTROGERAL.TIPOCADASTRO
    											  AND TRIBDEBITO.CADASTROGERAL = TRIBCADASTROGERAL.CADASTROGERAL
	INNER JOIN TRIBSITUACAOPARCELA TRIBSITUACAOPARCELA ON TRIBDEBITOPARCELA.SITUACAODEBITO = TRIBSITUACAOPARCELA.SITUACAOPARCELA
	INNER JOIN TRIBTIPOSITUACAOPARCELA TRIBTIPOSITUACAOPARCELA ON TRIBSITUACAOPARCELA.TIPOSITUACAOPARCELA = TRIBTIPOSITUACAOPARCELA.TIPOSITUACAOPARCELA
	LEFT JOIN TRIBGUIARECOLHIMENTO TRIBGUIARECOLHIMENTO ON TRIBGUIARECOLHIMENTO.ENTIDADE         = TRIBDEBITO.ENTIDADE
													   AND TRIBGUIARECOLHIMENTO.EXERCICIO        = TRIBDEBITO.EXERCICIO
													   AND TRIBGUIARECOLHIMENTO.GUIARECOLHIMENTO = TRIBDEBITO.GUIARECOLHIMENTO
	LEFT JOIN TRIBPROTESTO TRIBPROTESTO ON TRIBDEBITOPARCELA.IDPROTESTO = TRIBPROTESTO.IDPROTESTO
	LEFT JOIN TRIBPARCELAMENTODEBITO TRIBPARCELAMENTODEBITO ON TRIBPARCELAMENTODEBITO.IDDEBITO = TRIBDEBITO.IDDEBITO
	LEFT JOIN TRIBPARCELAMENTO TRIBPARCELAMENTO ON TRIBPARCELAMENTO.IDPARCELAMENTO = TRIBPARCELAMENTODEBITO.IDPARCELAMENTO
    LEFT JOIN TRIBRECEITA TR ON TRIBDEBITOPARCELARECEITA.ENTIDADE = TR.ENTIDADE AND TRIBDEBITOPARCELARECEITA.EXERCICIO = TR.EXERCICIO AND TRIBDEBITOPARCELARECEITA.RECEITA = TR.RECEITA
    LEFT JOIN TRIBRECEITATIPO TRT ON TRT.TIPORECEITA = TR.TIPORECEITA
    left outer join (
	select
		tdidaJoin.ENTIDADE,
		tdidaJoin.EXERCICIO,
		tdidaJoin.TIPODOCUMENTO,
		tdidaJoin.DOCUMENTO,
		tdidaJoin.SEQUENCIAITEM,
		tdidaJoin.EXERCICIODEBITO,
		tdidaJoin.TIPOCADASTRO,
		tdidaJoin.CADASTROGERAL,
		tdidaJoin.GUIARECOLHIMENTO,
		tdidaJoin.SUBDIVIDA,
		tdidaJoin.PARCELA,
		tdidaJoin.RECEITA,
		doc.idkey as idCertidao
	from
		TribDocumentoItemDividaAtiva tdidaJoin
	inner join tribdocumento doc on
		(tdidaJoin.Entidade = doc.entidade
			and tdidaJoin.Exercicio = doc.exercicio
			and tdidaJoin.Tipodocumento = doc.tipodocumento
			and tdidaJoin.Documento = doc.documento)
	where
		tdidaJoin.tipodocumento = 26
		and (tdidaJoin.exercicio,
		tdidaJoin.DOCUMENTO) in (
		select
			MAX(tdidaMax.exercicio),
			MAX(tdidaMax.DOCUMENTO) as UltimoDocumento
		from
			TribDocumentoItemDividaAtiva tdidaMax
		join tribdocumento docMax on
			(docMax.entidade = tdidaMax.Entidade
				and docMax.Exercicio = tdidaMax.Exercicio
				and docMax.Tipodocumento = tdidaMax.Tipodocumento
				and docMax.Documento = tdidaMax.Documento
				and docMax.Cancelado = 'N')
		where
			tdidaMax.ENTIDADE = tdidaJoin.ENTIDADE
			and tdidaMax.EXERCICIODEBITO = tdidaJoin.EXERCICIODEBITO
			and tdidaMax.TIPOCADASTRO = tdidaJoin.TIPOCADASTRO
			and tdidaMax.CADASTROGERAL = tdidaJoin.CADASTROGERAL
			and tdidaMax.GUIARECOLHIMENTO = tdidaJoin.GUIARECOLHIMENTO
			and tdidaMax.SUBDIVIDA = tdidaJoin.SUBDIVIDA
			and tdidaMax.PARCELA = tdidaJoin.PARCELA
			and tdidaMax.RECEITA = tdidaJoin.RECEITA
			and tdidaMax.Tipodocumento = tdidaJoin.Tipodocumento
			and tdidamax.exercicio = (
			select
				max(tdidaExercicio.exercicio)
			from
				tribdocumentoitemdividaativa tdidaExercicio
			join tribdocumento docExercicio on
				(docExercicio.entidade = tdidaExercicio.Entidade
					and docExercicio.Exercicio = tdidaExercicio.Exercicio
					and docExercicio.Tipodocumento = tdidaExercicio.Tipodocumento
					and docExercicio.Documento = tdidaExercicio.Documento
					and docExercicio.Cancelado = 'N')
			where
				tdidaExercicio.ENTIDADE = tdidaJoin.ENTIDADE
				and tdidaExercicio.EXERCICIODEBITO = tdidaJoin.EXERCICIODEBITO
				and tdidaExercicio.TIPOCADASTRO = tdidaJoin.TIPOCADASTRO
				and tdidaExercicio.CADASTROGERAL = tdidaJoin.CADASTROGERAL
				and tdidaExercicio.GUIARECOLHIMENTO = tdidaJoin.GUIARECOLHIMENTO
				and tdidaExercicio.SUBDIVIDA = tdidaJoin.SUBDIVIDA
				and tdidaExercicio.PARCELA = tdidaJoin.PARCELA
				and tdidaExercicio.RECEITA = tdidaJoin.RECEITA
				and tdidaExercicio.Tipodocumento = tdidaJoin.Tipodocumento ))
		and doc.cancelado = 'N' ) tdida on
		(TRIBDEBITOPARCELARECEITA.entidade = tdida.entidade
		and TRIBDEBITOPARCELARECEITA.exercicio = tdida.exerciciodebito
		and TRIBDEBITOPARCELARECEITA.tipocadastro = tdida.tipocadastro
		and TRIBDEBITOPARCELARECEITA.cadastrogeral = tdida.cadastrogeral
		and TRIBDEBITOPARCELARECEITA.guiarecolhimento = tdida.guiarecolhimento
		and TRIBDEBITOPARCELARECEITA.subdivida = tdida.subdivida
		and TRIBDEBITOPARCELARECEITA.receita = tdida.receita
		and TRIBDEBITOPARCELARECEITA.parcela = tdida.parcela)
	LEFT OUTER JOIN TRIBPROTESTOREMESSAITEM TRIBPROTESTOREMESSAITEM ON TRIBPROTESTOREMESSAITEM.idprotesto = TRIBDEBITOPARCELA.idprotesto
																   AND TRIBPROTESTOREMESSAITEM.entidade = TRIBPROTESTO.entidade
																   AND TRIBPROTESTOREMESSAITEM.exercicio = TRIBPROTESTO.exercicio
																   AND TRIBPROTESTOREMESSAITEM.remessa = (SELECT MAX(tprimax.remessa)
																									      FROM tribprotestoremessaitem tprimax
																									      WHERE tprimax.idprotesto = TRIBDEBITOPARCELA.idprotesto)
																   AND TRIBPROTESTOREMESSAITEM.sequencia = (SELECT MAX(tprimax.sequencia)
																									    	FROM tribprotestoremessaitem tprimax
																									    	WHERE tprimax.idprotesto = TRIBDEBITOPARCELA.idprotesto
																									    	AND tprimax.remessa = TRIBPROTESTOREMESSAITEM.remessa)
WHERE TRIBDEBITO.ENTIDADE = 1
  AND TRIBTIPOSITUACAOPARCELA.TIPO = 'A'
  AND TRIBDEBITOPARCELARECEITA.VALOR > 0
  AND TRIBCADASTROGERAL.EXCLUSAOLOGICA = 'N'
  [FILTER]
group by TRIBCADASTROGERAL.TIPOCADASTRO,
         TRIBCADASTROGERAL.CADASTROGERAL,
         TRIBCADASTROGERAL.PESSOA,
         TRIBDEBITO.ENTIDADE,
         TRIBDEBITO.EXERCICIO,
         TRIBDEBITO.GUIARECOLHIMENTO,
         TRIBDEBITO.SUBDIVIDA,
         TRIBDEBITOPARCELARECEITA.RECEITA,
         TRIBDEBITO.DATALANCAMENTO,
         TRIBDEBITOPARCELA.DATAVENCIMENTO,
         TRIBDEBITO.DATAPRIMEIRAPARCELA,
         TRIBDEBITO.DATACORRECAOIGPM,
         TRIBDEBITOPARCELA.SITUACAOLEGAL,
         TRIBDEBITOPARCELARECEITA.VALOR,
         TRIBDEBITO.FORMACORRECAO,
         CASE WHEN TRIBDEBITO.CONSTITUIDO  = 'S' THEN 1 ELSE 0 END,
         CASE WHEN TRIBDEBITO.PARCELADO = 'S' THEN 1 ELSE 0 END,
         CASE WHEN TRIBDEBITO.REPARCELADO = 'S' THEN 1 ELSE 0 END,
         TRIBDEBITOPARCELARECEITA.IDDEBITOPARCELARECEITA,
         TRIBDEBITO.IDDEBITO,
         TRIBDEBITOPARCELARECEITA.PARCELA,
         CASE WHEN TRIBGUIARECOLHIMENTO.EMITEBLOQUETO = 'S' THEN 1 ELSE 0 END,
         TRIBGUIARECOLHIMENTO.DESCRICAO,
         TRIBTIPOSITUACAOPARCELA.TIPOSITUACAOPARCELA,
         TRIBDEBITOPARCELA.IDPROTESTO,
         TRIBSITUACAOPARCELA.DESCRICAO,
         TRIBSITUACAOPARCELA.SIGLA,
         COALESCE(TRIBDEBITO.NOPROCESSOCOMUMUNICA, CAST(TRIBDEBITOPARCELA.PROCESSOJUDICIAL AS VARCHAR(30))),
         TRIBPARCELAMENTO.IDPARCELAMENTO,
         TRIBDEBITO.DESCONTOLEI2004,
         TRIBDEBITO.DESCONTOMULTAPAGTOEMDIA,
         TRIBDEBITO.DESCONTOJUROSPAGTOEMDIA,
         TRIBDEBITO.DESCONTOJUROSFINANPAGTOEMDIA,
         TRIBGUIARECOLHIMENTO.PASSIVELREFIS,
         COALESCE(TRIBPARCELAMENTO.PORCONTRIBUINTE,'N'),
         TRIBPARCELAMENTO.NUMEROCONTRATO,
         TRIBPARCELAMENTO.ANOCONTRATO,
         TR.CLASSIFICACAO,
         TRT.CLASSIFICACAORECEITATIPO,
         39,
         TRIBPROTESTOREMESSAITEM.CARTORIO,
         TRIBGUIARECOLHIMENTO.SUPERSIMPLES,
         TRIBGUIARECOLHIMENTO.DATALIMITEVENCIMENTOBOLETO