WITH pagamentos AS (
    select
        tpd1.iddebitoparcelareceita,
        min(idpagamentobloqueto) as idpagamentobloqueto,
        sum(COALESCE(tpd1.valorpago,0))     as valorpago,
        SUM(COALESCE(TPD1.VALORJUROS,0))    as valorjuros,
        SUM(COALESCE(TPD1.VALORMULTA,0))    as valormulta,
        SUM(COALESCE(TPD1.VALORCORRECAO,0)) as valorcorrecao,
        SUM(COALESCE(TPD1.VALORDESCONTO,0)) as valordesconto
    from tribdocumentoitemdividaativa dida
        join tribdocumento doc on doc.entidade = dida.entidade and doc.exercicio = dida.exercicio
                              and doc.documento = dida.documento and doc.tipodocumento = dida.tipodocumento
        join tribdebitoparcelareceita tdpr on tdpr.entidade = dida.entidade and tdpr.exercicio = dida.exerciciodebito
                                          and tdpr.tipocadastro = dida.tipocadastro and tdpr.cadastrogeral = dida.cadastrogeral
                                          and tdpr.guiarecolhimento = dida.guiarecolhimento and tdpr.subdivida = dida.subdivida
                                          and tdpr.receita = dida.receita and tdpr.parcela = dida.parcela
        JOIN tribpagamentodebito tpd1 ON tpd1.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
    [WHERE_TEMPLATE]
      AND(TPD1.ESTORNO IS NULL OR TPD1.ESTORNO = 'N')
      AND (TPD1.valordevolvido IS NULL OR TPD1.valordevolvido = 0)

    group by tpd1.iddebitoparcelareceita
)
SELECT
 TD.ENTIDADE,
       TD.EXERCICIO,
       TD.TIPOCADASTRO,
       TD.CADASTROGERAL,
       TD.GUIARECOLHIMENTO                              as DIVIDA,
       TD.SUBDIVIDA                                     as SubDivida,
       TD.IDDEBITO,
       TDP.PARCELA,
       TSP.DESCRICAO                                    as SITUACAODEBITODESCRICAO,
       TDPR.RECEITA                                     as TRIBUTO,
       TR.CLASSIFICACAO                                 AS CLASSIFICACAOTRIBUTO,
       TRT.CLASSIFICACAORECEITATIPO                     as CLASSIFICACAOTIPOTRIBUTO,
       P.PESSOA,
       P.NOME                                           as NOMECONTRIBUINTE,
       P.NOMEFANTASIA,
       P.RG,
       P.INSCRICAOESTADUAL,
       P.TIPOPESSOA,
       P.CNPJ_CPF                                       AS CNPJCPFCONTRIBUINTE,
       EP.NUMERO                                        as NUMEROCONTRIBUINTE,
       EP.COMPLEMENTO                                   as COMPLEMENTOCONTRIBUINTE,
       LP.descricao                                     as LOGRADOUROCONTRIBUINTE,
       TLP.DESCRICAO                                    as TIPOLOGRADOUROCONTRIBUINTE,
       CP.DESCRICAO                                     AS CIDADECONTRIBUINTE,
       CP.UNIDADEFEDERACAO                              as UNIDADEFEDERACAOCONTRIBUINTE,
       TIPOLOG.DESCRICAO                                as TIPOLOGRADOURO,
       LOG.DESCRICAO                                    as LOGRADOURO,
       TCG.NUMERO                                       as NUMERO,
       TCG.COMPLEMENTO                                  as COMPLEMENTO,
       TCG.CEP                                          as cep,
       TSP.TipoSituacaoParcela,
       TDP.SITUACAOLEGAL,
       TD.DataCorrecaoIgpm                              as DATACORRECAOIGPM,
       TD.DataPrimeiraParcela                           as DATAPRIMEIRAPARCELA,
       TD.FormaCorrecao,
       BAI.descricao                                    as bairro,
       TCM.numeroRegistro,
       TCM.atividadePrincipal,
       TCM.cadastroGeralImobiliario,
       TCM.telefone,
       CASE WHEN TD.Constituido = 'S' THEN 1 ELSE 0 END AS CONSTITUIDO,
       CASE WHEN TD.Parcelado = 'S' THEN 1 ELSE 0 END   AS PARCELADO,
       CASE WHEN TD.Reparcelado = 'S' THEN 1 ELSE 0 END AS REPARCELADO,
       tdpr.valor                                       as ValorPrincipal,
       TDP.DATAVENCIMENTO,
       TD.DATALANCAMENTO,
       TDP.DATASITUACAO                                    DATAMOVIMENTO,
       TP.DATAPAGAMENTO,
       TDP.IDPROTESTO,
       COALESCE(CASE
                    WHEN tsp.tiposituacaoparcela IN (2,33,34,35,36)  THEN
                        pagamentos.valorpago
                    ELSE 0 END, 0)                      AS VALORPAGO,
       TGR.DESCRICAO                                    AS DESCRICAODIVIDA,
       TSP.SIGLA as siglaSituacao,
       TP.EXERCICIOPAGAMENTO,
       TD.IDPARCELAMENTO,
       TD.DESCONTOLEI2004                               AS DESCONTOPARCELAMENTO,
       TD.DESCONTOMULTAPAGTOEMDIA                       AS DESCONTOMULTAPARCELAMENTO,
       TD.DESCONTOJUROSPAGTOEMDIA                       AS DESCONTOJUROSPARCELAMENTO,
       TD.DESCONTOJUROSFINANPAGTOEMDIA                  AS DESCONTOJUROSFINANPARCELAMENTO,
       COALESCE(pagamentos.VALORJUROS,0)               as VALORJUROSPAGAMENTO,
       COALESCE(pagamentos.VALORMULTA,0)               as VALORMULTAPAGAMENTO,
       COALESCE(pagamentos.VALORCORRECAO,0)            as VALORCORRECAOPAGAMENTO,
       COALESCE(pagamentos.VALORDESCONTO,0)            as VALORDESCONTOPAGAMENTO,
       TCI.INSCRICAOCADASTRAL,
       TCI.QUADRICULA_INSCRICAOCADASTRAL                as QUADRICULA,
       TCI.DISTRITO_INSCRICAOCADASTRAL                  as DISTRITO,
       TS.SETOR,
       TSQ.QUADRA,
       TCI.LOTE_INSCRICAOCADASTRAL                      as LOTEINSCRICAOCADASTRAL,
       TCI.UNIDADE_INSCRICAOCADASTRAL                   as UNIDADE,
       TCI.COMPLEMENTOLOTE,
       TPA.NUMEROCONTRATO,
       TPA.ANOCONTRATO,
       TCI.QUADRA_DESCR                                 as quadraFiscalizacao,
       TCI.LOTE_DESCR                                   as loteFiscalizacao,
       doc.idkey                                   AS idCda,
       doc.documento                               AS numeroCda,
       doc.exercicio                            AS exercicioCda,
       OBSERVACAOPARCELA.OBSERVACAO                    AS observacaoParcela,
       doc.processojudicial as processojudicial
FROM tribdocumento doc
    JOIN tribdocumentoitemdividaativa dida ON dida.entidade = doc.entidade and dida.documento = doc.documento
                                          and dida.exercicio = doc.exercicio and dida.tipodocumento = doc.tipodocumento
    join tribdebitoparcelareceita tdpr on tdpr.entidade = dida.entidade and tdpr.exercicio = dida.exerciciodebito
                                      and tdpr.tipocadastro = dida.tipocadastro and tdpr.cadastrogeral = dida.cadastrogeral
                                      and tdpr.guiarecolhimento = dida.guiarecolhimento and tdpr.subdivida = dida.subdivida
                                      and tdpr.receita = dida.receita and tdpr.parcela = dida.parcela
    join tribdebitoparcela tdp on tdp.entidade = tdpr.entidade and tdp.exercicio = tdpr.exercicio
                              and tdp.tipocadastro = tdpr.tipocadastro and tdp.cadastrogeral = tdpr.cadastrogeral
                              and tdp.guiarecolhimento = tdpr.guiarecolhimento and tdp.subdivida = tdpr.subdivida
                              and tdp.parcela = tdpr.parcela
     join tribdebitoreceita tdr on tdr.entidade = tdp.entidade and tdr.exercicio = tdp.exercicio
                                  and tdr.tipocadastro = tdp.tipocadastro and tdr.cadastrogeral = tdp.cadastrogeral
                                  and tdr.guiarecolhimento = tdp.guiarecolhimento and tdr.subdivida = tdp.subdivida
    join tribdebito td on  td.entidade = tdp.entidade and td.exercicio = tdp.exercicio
                      and td.tipocadastro = tdp.tipocadastro and td.cadastrogeral = tdp.cadastrogeral
                      and td.guiarecolhimento = tdp.guiarecolhimento and td.subdivida = tdp.subdivida
    LEFT JOIN TRIBRECEITA TR ON TDPR.ENTIDADE = TR.ENTIDADE
                            AND TDPR.EXERCICIO = TR.EXERCICIO
                            AND TDPR.RECEITA = TR.RECEITA
    LEFT JOIN TRIBRECEITATIPO TRT ON TRT.TIPORECEITA = TR.TIPORECEITA
    left join pagamentos on pagamentos.iddebitoparcelareceita = tdpr.iddebitoparcelareceita
    LEFT JOIN TRIBPAGAMENTOBLOQUETO TPB ON TPB.IDPAGAMENTOBLOQUETO = pagamentos.IDPAGAMENTOBLOQUETO
    LEFT JOIN TRIBPAGAMENTO TP ON TPB.ENTIDADE = TP.ENTIDADE AND TPB.EXERCICIOPAGAMENTO = TP.EXERCICIOPAGAMENTO
                                AND TPB.PAGAMENTO = TP.PAGAMENTO
    LEFT JOIN TRIBPARCELAMENTO TPA ON TPA.IDPARCELAMENTO = coalesce(TD.IDPARCELAMENTO, TD.IDREPARCELAMENTO)
    join tribsituacaoparcela tsp on tsp.situacaoparcela = tdp.situacaodebito
    join tribguiarecolhimento tgr on tgr.entidade = td.entidade and tgr.exercicio = td.exercicio
                                 and tgr.guiarecolhimento = td.guiarecolhimento
    LEFT JOIN TRIBCADASTROGERAL TCG ON TCG.TIPOCADASTRO = TD.TIPOCADASTRO AND TCG.CADASTROGERAL = TD.CADASTROGERAL
    LEFT JOIN TRIBCADASTROIMOBILIARIO TCI ON TCG.IDKEY = TCI.TRIBCADASTROGERAL_IDKEY
    LEFT JOIN TRIBCADASTROMOBILIARIO TCM ON TCG.IDKEY = TCM.TRIBCADASTROGERAL_IDKEY
    LEFT JOIN TRIBSETOR TS ON TCI.TRIBSETOR_IDKEY = TS.IDKEY
    LEFT JOIN TRIBSETORQUADRA TSQ ON TCI.TRIBSETOR_IDKEY = TSQ.TRIBSETOR_IDKEY AND TCI.QUADRA_INSCRICAOCADASTRAL = TSQ.QUADRA
    LEFT JOIN LOGRADOURO LOG ON TCG.LOGRADOURO_IDKEY = LOG.IDKEY
    LEFT JOIN TIPOLOGRADOURO TIPOLOG ON LOG.TIPOLOGRADOURO = TIPOLOG.TIPOLOGRADOURO
    LEFT JOIN PESSOA P ON P.PESSOA = TCG.PESSOA
    LEFT JOIN ENDERECOPESSOA EP ON P.PESSOA = EP.PESSOA AND EP.SEQUENCIA = P.SEQUENCIAENDERECO
    LEFT JOIN LOGRADOURO LP ON EP.LOGRADOURO_IDKEY = LP.IDKEY
    LEFT JOIN TIPOLOGRADOURO TLP ON LP.TIPOLOGRADOURO = TLP.TIPOLOGRADOURO
    LEFT JOIN CIDADE CP ON EP.CIDADE = CP.CIDADE
    LEFT JOIN BAIRRO BAI ON BAI.IDKEY = TCG.BAIRRO_IDKEY
    LEFT JOIN (
                SELECT O.ENTIDADE, O.EXERCICIO, O.TIPOCADASTRO, O.CADASTROGERAL, O.GUIARECOLHIMENTO, O.SUBDIVIDA, O.PARCELA, O.OBSERVACAO
                FROM  TRIBDEBITOPARCELAOBSERVACAO O
                WHERE SEQUENCIA = (
                    SELECT MAX(OS.SEQUENCIA)
                    FROM TRIBDEBITOPARCELAOBSERVACAO OS
                    WHERE  O.ENTIDADE = OS.ENTIDADE
                            AND O.EXERCICIO = OS.EXERCICIO
                            AND O.TIPOCADASTRO = OS.TIPOCADASTRO
                            AND O.CADASTROGERAL = OS.CADASTROGERAL
                            AND O.GUIARECOLHIMENTO = OS.GUIARECOLHIMENTO
                            AND O.SUBDIVIDA = OS.SUBDIVIDA
                            AND O.PARCELA = OS.PARCELA
                )
    ) AS OBSERVACAOPARCELA ON OBSERVACAOPARCELA.ENTIDADE = TDP.ENTIDADE
                              AND OBSERVACAOPARCELA.EXERCICIO = TDP.EXERCICIO
                              AND OBSERVACAOPARCELA.TIPOCADASTRO = TDP.TIPOCADASTRO
                              AND OBSERVACAOPARCELA.CADASTROGERAL = TDP.CADASTROGERAL
                              AND OBSERVACAOPARCELA.GUIARECOLHIMENTO = TDP.GUIARECOLHIMENTO
                              AND OBSERVACAOPARCELA.SUBDIVIDA = TDP.SUBDIVIDA
                              AND OBSERVACAOPARCELA.PARCELA = TDP.PARCELA
[WHERE_TEMPLATE]