SELECT
	DEBITO.IDDEBITO AS ID,
	PARCELARECEITA.ENTIDADE,
	PARCELARECEITA.EXERCICIO,
	PARCELARECEITA.TIPOCADASTRO,
	PARCELARECEITA.CADASTROGERAL,
	PESSOA.PESSOA AS CONTRIBUINTE,
	PARCELARECEITA.GUIARECOLHIMENTO AS DIVIDA,
	PARCELARECEITA.SUBDIVIDA,
	PARCELARECEITA.PARCELA AS PARCELA,
	DEBITOPARCELA.DATAVENCIMENTO,
	SUM(PAGAMENTODEBITO.VALORPAGO) AS VALORPAGO,
   	SUM(PARCELARECEITA.VALOR) AS VALOR,
   	SUM(PARCELARECEITA.VALORJUROS) AS VALORJUROS,
   	SUM(PARCELARECEITA.VALORMULTA) AS VALORMULTA,
   	SUM(PARCELARECEITA.VALORCORRECAO) AS VALORCORRECAO,
   	SUM(PARCELARECEITA.VALORDESCONTO) AS VALORDESCONTO,
	SITUACAOPARCELA.SITUACAOPARCELA,
	TIPOSITUACAOPARCELA.DESCRICAO AS TIPOSITUACAOPARCELAMENTO
FROM TRIBESTORNOPARCELAMENTODEBITO ESTORNOPARCELAMENTODEBITO
INNER JOIN TRIBDEBITO DEBITO ON ESTORNOPARCELAMENTODEBITO.IDDEBITOORIGEM = DEBITO.IDDEBITO
LEFT JOIN TRIBCADASTROGERAL CADASTROGERAL ON CADASTROGERAL.CADASTROGERAL = DEBITO.CADASTROGERAL
                                                   AND CADASTROGERAL.TIPOCADASTRO = DEBITO.TIPOCADASTRO
LEFT JOIN PESSOA PESSOA ON PESSOA.PESSOA = CADASTROGERAL.PESSOA
INNER JOIN TRIBDEBITOPARCELA DEBITOPARCELA ON DEBITO.ENTIDADE = DEBITOPARCELA.ENTIDADE
                                                   AND DEBITO.EXERCICIO = DEBITOPARCELA.EXERCICIO
                                                   AND DEBITO.TIPOCADASTRO = DEBITOPARCELA.TIPOCADASTRO
                                                   AND DEBITO.CADASTROGERAL = DEBITOPARCELA.CADASTROGERAL
                                                   AND DEBITO.GUIARECOLHIMENTO = DEBITOPARCELA.GUIARECOLHIMENTO
                                                   AND DEBITO.SUBDIVIDA = DEBITOPARCELA.SUBDIVIDA
LEFT JOIN TRIBDEBITOPARCELARECEITA PARCELARECEITA ON PARCELARECEITA.ENTIDADE = DEBITOPARCELA.ENTIDADE
                                                   AND PARCELARECEITA.EXERCICIO = DEBITOPARCELA.EXERCICIO
                                                   AND PARCELARECEITA.TIPOCADASTRO = DEBITOPARCELA.TIPOCADASTRO
                                                   AND PARCELARECEITA.CADASTROGERAL = DEBITOPARCELA.CADASTROGERAL
                                                   AND PARCELARECEITA.GUIARECOLHIMENTO = DEBITOPARCELA.GUIARECOLHIMENTO
                                                   AND PARCELARECEITA.SUBDIVIDA = DEBITOPARCELA.SUBDIVIDA
                                                   AND PARCELARECEITA.PARCELA = DEBITOPARCELA.PARCELA
LEFT JOIN TRIBPAGAMENTODEBITO PAGAMENTODEBITO ON PAGAMENTODEBITO.IDDEBITOPARCELARECEITA = PARCELARECEITA.IDDEBITOPARCELARECEITA
JOIN TRIBSITUACAOPARCELA SITUACAOPARCELA ON SITUACAOPARCELA.SITUACAOPARCELA = DEBITOPARCELA.SITUACAODEBITO
JOIN TRIBTIPOSITUACAOPARCELA TIPOSITUACAOPARCELA ON SITUACAOPARCELA.TIPOSITUACAOPARCELA = TIPOSITUACAOPARCELA.TIPOSITUACAOPARCELA
WHERE ESTORNOPARCELAMENTODEBITO.IDESTORNOPARCELAMENTO = :id
	AND TIPOSITUACAOPARCELA.TIPOSITUACAOPARCELA IN (2, 33, 34, 35, 36)
GROUP BY
	DEBITO.IDDEBITO,
	PARCELARECEITA.ENTIDADE,
	PARCELARECEITA.EXERCICIO,
	PARCELARECEITA.TIPOCADASTRO,
	PARCELARECEITA.CADASTROGERAL,
	PESSOA.PESSOA,
	PARCELARECEITA.GUIARECOLHIMENTO,
	PARCELARECEITA.SUBDIVIDA,
	PARCELARECEITA.PARCELA,
	DEBITOPARCELA.DATAVENCIMENTO,
	SITUACAOPARCELA.SITUACAOPARCELA,
	TIPOSITUACAOPARCELA.DESCRICAO