SELECT
	DEBITO.IDDEBITO,
    PARCELARECEITA.IDDEBITOPARCELARECEITA,
	PARCELARECEITA.ENTIDADE,
	PARCELARECEITA.EXERCICIO,
	PARCELARECEITA.TIPOCADASTRO,
	PARCELARECEITA.CADASTROGERAL,
	PESSOA.PESSOA AS CONTRIBUINTE,
	PARCELARECEITA.GUIARECOLHIMENTO AS DIVIDA,
	PARCELARECEITA.SUBDIVIDA,
	PARCELARECEITA.PARCELA AS PARCELA,
	PARCELARECEITA.RECEITA AS TRIBUTO,
	DEBITO.FORMACORRECAO,
	GUIARECOLHIMENTORECEITA.ORDEM,
	DEBITO.DATAPRIMEIRAPARCELA,
	DEBITO.DATACORRECAOIGPM,
	DEBITOPARCELA.DATAVENCIMENTO,
    DEBITOPARCELA.DATALANCAMENTO,
    (COALESCE(DEBITO.PARCELADO, 'N') = 'S') AS PARCELADO,
    (COALESCE(DEBITO.REPARCELADO, 'N') = 'S') AS REPARCELADO,
	PARCELARECEITA.VALOR AS VALOR,
	PARCELARECEITA.VALORJUROS,
    PARCELARECEITA.VALORMULTA,
    PARCELARECEITA.VALORCORRECAO,
    PARCELARECEITA.VALORDESCONTO,
    DEBITOPARCELA.SITUACAOLEGAL,
	TIPOSITUACAOPARCELA.DESCRICAO AS TIPOSITUACAOPARCELA
FROM TRIBESTORNOPARCELAMENTODEBITO ESTORNOPARCELAMENTODEBITO
INNER JOIN TRIBDEBITO DEBITO ON ESTORNOPARCELAMENTODEBITO.IDDEBITODESTINO = DEBITO.IDDEBITO
INNER JOIN TRIBDEBITOPARCELA DEBITOPARCELA ON DEBITO.ENTIDADE = DEBITOPARCELA.ENTIDADE
                                                   AND DEBITO.EXERCICIO = DEBITOPARCELA.EXERCICIO
                                                   AND DEBITO.TIPOCADASTRO = DEBITOPARCELA.TIPOCADASTRO
                                                   AND DEBITO.CADASTROGERAL = DEBITOPARCELA.CADASTROGERAL
                                                   AND DEBITO.GUIARECOLHIMENTO = DEBITOPARCELA.GUIARECOLHIMENTO
                                                   AND DEBITO.SUBDIVIDA = DEBITOPARCELA.SUBDIVIDA
LEFT OUTER JOIN TRIBDEBITOPARCELARECEITA PARCELARECEITA ON PARCELARECEITA.ENTIDADE = DEBITOPARCELA.ENTIDADE
                                                   AND PARCELARECEITA.EXERCICIO = DEBITOPARCELA.EXERCICIO
                                                   AND PARCELARECEITA.TIPOCADASTRO = DEBITOPARCELA.TIPOCADASTRO
                                                   AND PARCELARECEITA.CADASTROGERAL = DEBITOPARCELA.CADASTROGERAL
                                                   AND PARCELARECEITA.GUIARECOLHIMENTO = DEBITOPARCELA.GUIARECOLHIMENTO
                                                   AND PARCELARECEITA.SUBDIVIDA = DEBITOPARCELA.SUBDIVIDA
                                                   AND PARCELARECEITA.PARCELA = DEBITOPARCELA.PARCELA
LEFT OUTER JOIN TRIBGUIARECOLHIMENTORECEITA GUIARECOLHIMENTORECEITA ON GUIARECOLHIMENTORECEITA.ENTIDADE = PARCELARECEITA.ENTIDADE
                                                   AND GUIARECOLHIMENTORECEITA.EXERCICIO = PARCELARECEITA.EXERCICIO
                                                   AND GUIARECOLHIMENTORECEITA.RECEITA = PARCELARECEITA.RECEITA
                                                   AND GUIARECOLHIMENTORECEITA.GUIARECOLHIMENTO = PARCELARECEITA.GUIARECOLHIMENTO
JOIN TRIBSITUACAOPARCELA SITUACAOPARCELA ON SITUACAOPARCELA.SITUACAOPARCELA = DEBITOPARCELA.SITUACAODEBITO
JOIN TRIBTIPOSITUACAOPARCELA TIPOSITUACAOPARCELA ON SITUACAOPARCELA.TIPOSITUACAOPARCELA = TIPOSITUACAOPARCELA.TIPOSITUACAOPARCELA
LEFT JOIN TRIBCADASTROGERAL CADASTROGERAL ON CADASTROGERAL.CADASTROGERAL = DEBITO.CADASTROGERAL
                                                   AND CADASTROGERAL.TIPOCADASTRO = DEBITO.TIPOCADASTRO
LEFT JOIN PESSOA PESSOA ON PESSOA.PESSOA = CADASTROGERAL.PESSOA
WHERE ESTORNOPARCELAMENTODEBITO.IDESTORNOPARCELAMENTO = :id
    AND TIPOSITUACAOPARCELA.TIPO = 'A'
ORDER BY
	DEBITO.IDDEBITO,
	PARCELARECEITA.IDDEBITOPARCELARECEITA,
	PARCELARECEITA.GUIARECOLHIMENTO,
	PARCELARECEITA.SUBDIVIDA,
	PARCELARECEITA.PARCELA,
	PARCELARECEITA.RECEITA,
    DEBITOPARCELA.DATALANCAMENTO,
	GUIARECOLHIMENTORECEITA.ORDEM,
	DEBITO.FORMACORRECAO,
    DEBITOPARCELA.SITUACAOLEGAL,
    DEBITOPARCELA.SITUACAODEBITO