/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.ws;

import br.com.elotech.tributos.dto.ImpressaoDTO;
import br.com.elotech.tributos.service.ws.AisePdfService;
import br.com.elotech.tributos.ws.domain.ImprimeSituacaoCadastralEnvio;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/imprimir-situacaocadastral"})
public class ImprimeSituacaoCadastralResource {
    private final AisePdfService aisePdfService;

    public ImprimeSituacaoCadastralResource(AisePdfService aisePdfService) {
        this.aisePdfService = aisePdfService;
    }

    @GetMapping(value={"/cadastro"}, params={"tipoCadastro", "cadastroGeral"})
    public ImpressaoDTO imprimeSituacaoCadastralByCadastro(ImprimeSituacaoCadastralEnvio params) {
        return ImpressaoDTO.from((String)this.aisePdfService.fetchSituacaoCadastralByCadastro(params.getTipoCadastro(), params.getCadastroGeral()));
    }

    @GetMapping(value={"/cnpjcpf"}, params={"tipoPessoa", "cnpjCpf"})
    public ImpressaoDTO imprimeSituacaoCadastralByCnpj(ImprimeSituacaoCadastralEnvio params) {
        return ImpressaoDTO.from((String)this.aisePdfService.fetchSituacaoCadastralByCnpj(params.getTipoPessoa(), params.getCnpjCpf()));
    }
}

