/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.validator;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.TipoRequerimento;
import br.com.elotech.tributos.domain.TipoRequerimentoItem;
import br.com.elotech.tributos.dto.requerimento.RequerimentoItemDTO;
import java.math.BigDecimal;
import org.springframework.stereotype.Component;

@Component
public class RequerimentoItemValidator {
    public void validarPertenceAoTipoRequerimento(TipoRequerimentoItem tipoRequerimentoItem, TipoRequerimento tipoRequerimento) {
        if (!tipoRequerimento.equals((Object)tipoRequerimentoItem.getTipoRequerimento())) {
            throw new EloValidationException("Item n\u00e3o pertence ao Tipo do Requerimento informado.");
        }
    }

    public void validarQuantidadeFixa(RequerimentoItemDTO itemDto, TipoRequerimentoItem tipoRequerimentoItem) {
        if (Boolean.TRUE.equals(tipoRequerimentoItem.getQuantidadeFixa()) && tipoRequerimentoItem.getQuantidade().stripTrailingZeros().compareTo(itemDto.getQuantidade().stripTrailingZeros()) != 0) {
            throw new EloValidationException(String.format("O item '%s' possui quantidade fixa de %.2f e n\u00e3o pode ser alterado no lan\u00e7amento.", tipoRequerimentoItem.getDescricao(), tipoRequerimentoItem.getQuantidade()));
        }
    }

    public boolean possuiValorMaiorQueZero(RequerimentoItemDTO itemDto) {
        return itemDto.getQuantidade().multiply(itemDto.getValorUnitario()).compareTo(BigDecimal.ZERO) > 0;
    }
}

