/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.validator;

import br.com.elotech.tributos.annotation.ValidFile;
import java.util.Objects;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.springframework.web.multipart.MultipartFile;

public class FileValidator
implements ConstraintValidator<ValidFile, MultipartFile> {
    private String mimeType;
    private boolean checkExtension;
    private String expectedExtension;

    public void initialize(ValidFile constraintAnnotation) {
        this.mimeType = constraintAnnotation.mimeType();
        this.checkExtension = constraintAnnotation.checkExtension();
        this.expectedExtension = constraintAnnotation.expectedExtension();
    }

    public boolean isValid(MultipartFile multipartFile, ConstraintValidatorContext context) {
        boolean result = true;
        if (Objects.nonNull(multipartFile)) {
            String contentType = multipartFile.getContentType();
            String extension = "";
            if (this.checkExtension) {
                extension = this.extractExtension(multipartFile);
            }
            if (Objects.isNull(contentType) || !this.isSupportedContentType(contentType, this.mimeType) || this.checkExtension && !this.isExpectedExtension(extension, this.expectedExtension)) {
                result = false;
            }
        }
        return result;
    }

    private boolean isSupportedContentType(String contentType, String fileContentType) {
        return contentType.equals(fileContentType);
    }

    private String extractExtension(MultipartFile file) {
        String fileName = Objects.requireNonNull(file.getOriginalFilename());
        int index = fileName.lastIndexOf(".");
        if (index >= 0) {
            return fileName.substring(index + 1);
        }
        return "";
    }

    private boolean isExpectedExtension(String extensionValue, String extensionExpected) {
        return extensionValue.equals(extensionExpected);
    }
}

