/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.util.webiss;

import br.com.elotech.tributos.dto.webiss.Registro312DTO;
import br.com.elotech.tributos.dto.webiss.Registro334DTO;
import br.com.elotech.tributos.dto.webiss.RegistroWebIss;
import br.com.elotech.tributos.enums.webiss.TipoRegistroWebIss;
import br.com.elotech.tributos.util.SplitUtils;
import br.com.elotech.tributos.util.webiss.WebIssUtils;
import java.time.LocalDate;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.Generated;

public final class WebIssUtils {
    private static final String SEPARADOR = "\\|";

    public static RegistroWebIss getRegistroDtoFromLinha(String linha) {
        String identificadorRegistro = linha.split(SEPARADOR)[1];
        TipoRegistroWebIss tipoRegistroWebIss = TipoRegistroWebIss.fromValue((String)identificadorRegistro);
        Registro334DTO registroWebIss = null;
        switch (1.$SwitchMap$br$com$elotech$tributos$enums$webiss$TipoRegistroWebIss[tipoRegistroWebIss.ordinal()]) {
            case 1: {
                registroWebIss = new Registro334DTO();
                return (RegistroWebIss)SplitUtils.getDtoFromStringWithDelimiter((String)linha, (String)SEPARADOR, (Class)registroWebIss.getClass());
            }
            case 2: {
                registroWebIss = new Registro312DTO();
                return (RegistroWebIss)SplitUtils.getDtoFromStringWithDelimiter((String)linha, (String)SEPARADOR, (Class)registroWebIss.getClass());
            }
        }
        return registroWebIss;
    }

    public static Map<LocalDate, List<Registro334DTO>> getRegistrosAgrupados(List<Registro334DTO> registro334DTOList) {
        return registro334DTOList.stream().filter(dto -> dto.getDataCredito() != null).collect(Collectors.groupingBy(Registro334DTO::getDataCredito, TreeMap::new, Collectors.collectingAndThen(Collectors.toList(), WebIssUtils::ordenarPorNumLinha)));
    }

    private static List<Registro334DTO> ordenarPorNumLinha(List<Registro334DTO> lista) {
        return lista.stream().sorted(Comparator.comparing(Registro334DTO::getNumLinha)).toList();
    }

    @Generated
    public WebIssUtils() {
    }
}

