/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.util.sisobra;

import br.com.elotech.tributos.domain.sisobra.SisObraHabitese;
import br.com.elotech.tributos.domain.sisobra.SisObraHabiteseArea;
import br.com.elotech.tributos.dto.sisobra.SisObraHabiteseDadosAlvaraDTO;
import br.com.elotech.tributos.dto.sisobra.xml.AreaComplementarItemXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.AreaItemXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.AreaPrincipalItemXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.HabiteseXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.InfHabiteseXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.NiNovoProprietarioXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.SisObraPrefHabiteseXmlDTO;
import br.com.elotech.tributos.enums.sisobra.AlvaraAreaCategoria;
import br.com.elotech.tributos.enums.sisobra.AlvaraAreaComplementarTipo;
import br.com.elotech.tributos.enums.sisobra.AlvaraAreaDestinacao;
import br.com.elotech.tributos.enums.sisobra.AlvaraAreaTipoObra;
import br.com.elotech.tributos.enums.sisobra.TipoHabitese;
import br.com.elotech.tributos.enums.sisobra.UnidadeMedida;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SisObraHabiteseXmlBuilder {
    private static final String AREA_PRINCIPAL = "P";
    private static final String AREA_COMPLEMENTAR = "C";

    public static String buildXmlHabitese(SisObraHabitese habitese, List<SisObraHabiteseArea> habiteseAreas, String cnpjCpfDocumento, SisObraHabiteseDadosAlvaraDTO sisObraHabiteseDadosAlvara) {
        return SisObraHabiteseXmlBuilder.buildXml((SisObraHabitese)habitese, habiteseAreas, (String)cnpjCpfDocumento, (SisObraHabiteseDadosAlvaraDTO)sisObraHabiteseDadosAlvara);
    }

    private static String buildXml(SisObraHabitese habitese, List<SisObraHabiteseArea> habiteseAreas, String cnpjCpfDocumento, SisObraHabiteseDadosAlvaraDTO sisObraHabiteseDadosAlvara) {
        SisObraPrefHabiteseXmlDTO sisObraPrefHabiteseXmlDTO = new SisObraPrefHabiteseXmlDTO();
        HabiteseXmlDTO habiteseXmlDTO = new HabiteseXmlDTO();
        InfHabiteseXmlDTO infHabiteseXmlDTO = new InfHabiteseXmlDTO();
        sisObraPrefHabiteseXmlDTO.setVersao("1.03");
        infHabiteseXmlDTO.setId("id0000001");
        infHabiteseXmlDTO.setNumeroHabitese(habitese.getIdSisobraHabitese());
        if (habitese.getDataFinalObra() != null) {
            String dataHabitese = String.valueOf(habitese.getDataHabitese());
            String dataFinalObra = String.valueOf(habitese.getDataFinalObra());
            if (habitese.getDataFinalObra().equals(habitese.getDataAlvara())) {
                dataHabitese = dataFinalObra = String.valueOf(habitese.getDataFinalObra().plusDays(1L));
            }
            infHabiteseXmlDTO.setDataHabitese(dataHabitese);
            infHabiteseXmlDTO.setDataFinalObra(dataFinalObra);
        }
        infHabiteseXmlDTO.setTipoHabitese(TipoHabitese.fromValue((Long)habitese.getTipoHabitese()).getDescricao());
        infHabiteseXmlDTO.setUnidadeMedida(UnidadeMedida.fromValue((Long)habitese.getUnidadeMedida()).getDescricao());
        infHabiteseXmlDTO.setArea(SisObraHabiteseXmlBuilder.getListArea(habiteseAreas));
        infHabiteseXmlDTO.setNumeroAlvara(SisObraHabiteseXmlBuilder.getNumeroAlvara((SisObraHabitese)habitese, (SisObraHabiteseDadosAlvaraDTO)sisObraHabiteseDadosAlvara));
        infHabiteseXmlDTO.setDataAlvara(String.valueOf(SisObraHabiteseXmlBuilder.getDataAlvara((SisObraHabitese)habitese, (SisObraHabiteseDadosAlvaraDTO)sisObraHabiteseDadosAlvara)));
        infHabiteseXmlDTO.setNiNovoProprietario(SisObraHabiteseXmlBuilder.getProprietarioObra((String)cnpjCpfDocumento, (SisObraHabiteseDadosAlvaraDTO)sisObraHabiteseDadosAlvara));
        habiteseXmlDTO.setInfHabitese(infHabiteseXmlDTO);
        sisObraPrefHabiteseXmlDTO.setHabitese(habiteseXmlDTO);
        XmlMapper xmlMapper = new XmlMapper();
        try {
            return xmlMapper.writeValueAsString((Object)sisObraPrefHabiteseXmlDTO);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static LocalDate getDataAlvara(SisObraHabitese habitese, SisObraHabiteseDadosAlvaraDTO sisObraHabiteseDadosAlvara) {
        if (sisObraHabiteseDadosAlvara.getIdSisObraAlvara() != null && !sisObraHabiteseDadosAlvara.getIdSisObraAlvara().isEmpty()) {
            return LocalDate.parse(sisObraHabiteseDadosAlvara.getDataAlvara());
        }
        return habitese.getDataAlvara();
    }

    private static String getNumeroAlvara(SisObraHabitese habitese, SisObraHabiteseDadosAlvaraDTO sisObraHabiteseDadosAlvara) {
        if (sisObraHabiteseDadosAlvara.getIdSisObraAlvara() != null && !sisObraHabiteseDadosAlvara.getIdSisObraAlvara().isEmpty()) {
            return sisObraHabiteseDadosAlvara.getIdSisObraAlvara();
        }
        if (habitese.getNumeroAlvaraDoc() != null && !habitese.getNumeroAlvaraDoc().isEmpty()) {
            return habitese.getNumeroAlvaraDoc();
        }
        return "0";
    }

    private static NiNovoProprietarioXmlDTO getProprietarioObra(String cnpjCpfDocumento, SisObraHabiteseDadosAlvaraDTO sisObraHabiteseDadosAlvara) {
        NiNovoProprietarioXmlDTO niNovoProprietario = new NiNovoProprietarioXmlDTO();
        if (cnpjCpfDocumento != null) {
            if (cnpjCpfDocumento.length() == 11 && !cnpjCpfDocumento.equals(sisObraHabiteseDadosAlvara.getCpfProprietarioObra())) {
                niNovoProprietario.setCpf(cnpjCpfDocumento);
            }
            if (cnpjCpfDocumento.length() == 14 && !cnpjCpfDocumento.equals(sisObraHabiteseDadosAlvara.getCnpjProprietarioObra())) {
                niNovoProprietario.setCnpj(cnpjCpfDocumento);
            }
        }
        if (niNovoProprietario.getCpf() != null || niNovoProprietario.getCnpj() != null) {
            return niNovoProprietario;
        }
        return null;
    }

    private static AreaPrincipalItemXmlDTO buildAreaPrincipal(List<SisObraHabiteseArea> grupo, SisObraHabiteseArea item) {
        BigDecimal totalUnidades = grupo.stream().map(SisObraHabiteseArea::getQtdTotalUnidade).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalArea = grupo.stream().map(SisObraHabiteseArea::getArea).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        AreaPrincipalItemXmlDTO dto = new AreaPrincipalItemXmlDTO();
        dto.setCategoria(AlvaraAreaCategoria.fromValue((Long)item.getCategoria()).getDescricao());
        dto.setDestinacao(AlvaraAreaDestinacao.fromValue((Long)item.getDestinacao()).getDescricao());
        dto.setTipoObra(AlvaraAreaTipoObra.fromValue((Long)item.getTipoObra()).getDescricao());
        if (AlvaraAreaDestinacao.CONJUNTO_HABITACIONAL_POPULAR.equals((Object)dto.getDestinacao())) {
            dto.setQtdTotalUnidadesBloco(String.valueOf(totalUnidades));
        }
        dto.setArea(String.format("%.2f", totalArea).replace(",", "."));
        return dto;
    }

    private static AreaComplementarItemXmlDTO buildAreaComplementar(List<SisObraHabiteseArea> grupo, SisObraHabiteseArea item) {
        BigDecimal totalUnidades = grupo.stream().map(SisObraHabiteseArea::getQtdTotalUnidade).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalAreaCoberta = grupo.stream().map(SisObraHabiteseArea::getAreaCoberta).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalAreaDescoberta = grupo.stream().map(SisObraHabiteseArea::getAreaDescoberta).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        AreaComplementarItemXmlDTO dto = new AreaComplementarItemXmlDTO();
        dto.setCategoria(AlvaraAreaCategoria.fromValue((Long)item.getCategoria()).getDescricao());
        dto.setDestinacao(AlvaraAreaDestinacao.fromValue((Long)item.getDestinacao()).getDescricao());
        dto.setTipoObra(AlvaraAreaTipoObra.fromValue((Long)item.getTipoObra()).getDescricao());
        dto.setTipoAreaComplementar(AlvaraAreaComplementarTipo.fromValue((Long)item.getTipoArea()).getDescricao());
        if (AlvaraAreaDestinacao.CONJUNTO_HABITACIONAL_POPULAR.equals((Object)dto.getDestinacao())) {
            dto.setQtdTotalUnidadesBloco(String.valueOf(totalUnidades));
        }
        dto.setAreaCoberta(String.format("%.2f", totalAreaCoberta).replace(",", "."));
        dto.setAreaDescoberta(String.format("%.2f", totalAreaDescoberta).replace(",", "."));
        return dto;
    }

    private static AreaItemXmlDTO getListArea(List<SisObraHabiteseArea> habiteseAreas) {
        Map<List, List<SisObraHabiteseArea>> areasAgrupadas = habiteseAreas.stream().collect(Collectors.groupingBy(area -> Arrays.asList(area.getTipo(), area.getCategoria(), area.getDestinacao(), area.getTipoObra())));
        AreaItemXmlDTO areaItemXmlDTO = new AreaItemXmlDTO();
        ArrayList<AreaPrincipalItemXmlDTO> areaPrincipalList = new ArrayList<AreaPrincipalItemXmlDTO>();
        ArrayList<AreaComplementarItemXmlDTO> areaComplementarList = new ArrayList<AreaComplementarItemXmlDTO>();
        for (Map.Entry<List, List<SisObraHabiteseArea>> entry : areasAgrupadas.entrySet()) {
            List<SisObraHabiteseArea> grupo = entry.getValue();
            SisObraHabiteseArea item = grupo.getFirst();
            if ("P".equals(item.getTipo())) {
                AreaPrincipalItemXmlDTO areaPrincipalItemXmlDTO = SisObraHabiteseXmlBuilder.buildAreaPrincipal(grupo, (SisObraHabiteseArea)item);
                areaPrincipalList.add(areaPrincipalItemXmlDTO);
            }
            if (!"C".equals(item.getTipo())) continue;
            AreaComplementarItemXmlDTO areaComplementarItemXmlDTO = SisObraHabiteseXmlBuilder.buildAreaComplementar(grupo, (SisObraHabiteseArea)item);
            areaComplementarList.add(areaComplementarItemXmlDTO);
        }
        if (!areaPrincipalList.isEmpty()) {
            areaItemXmlDTO.setAreaPrincipal(areaPrincipalList);
        }
        if (!areaComplementarList.isEmpty()) {
            areaItemXmlDTO.setAreaComplementar(areaComplementarList);
        }
        return areaItemXmlDTO;
    }
}

