/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.util.sisobra;

import br.com.elotech.tributos.domain.sisobra.SisObraAlvara;
import br.com.elotech.tributos.domain.sisobra.SisObraAlvaraArea;
import br.com.elotech.tributos.dto.sisobra.xml.AlvaraIndXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.AlvaraXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.AreaComplementarItemXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.AreaItemXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.AreaPrincipalItemXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.ArquitetoXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.CamposArquitetoXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.CamposEngenheiroXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.CamposTecnicoIndustrialXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.DonoObraXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.ElementoCnpjAndCpfXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.EmpresaConstrutoraXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.EnderecoObraXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.EngenheiroXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.IncorporadorConstrucaoCivilXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.InfAlvaraXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.InformacoesAdicionaisXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.ProprietarioImovelXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.ProprietarioObraXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.ResponsavelAlvaraXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.ResponsavelExecObraXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.SisObraPrefXmlDTO;
import br.com.elotech.tributos.dto.sisobra.xml.TecnologoXmlDTO;
import br.com.elotech.tributos.enums.sisobra.AlvaraAreaCategoria;
import br.com.elotech.tributos.enums.sisobra.AlvaraAreaComplementarTipo;
import br.com.elotech.tributos.enums.sisobra.AlvaraAreaDestinacao;
import br.com.elotech.tributos.enums.sisobra.AlvaraAreaTipoObra;
import br.com.elotech.tributos.enums.sisobra.TipoAlvara;
import br.com.elotech.tributos.enums.sisobra.UnidadeMedida;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SisObraAlvaraXmlBuilder {
    private static final String ENGENHEIRO = "ENGENHEIRO";
    private static final String TECNOLOGO = "TECNOLOGO";
    private static final String TECNICOIND = "TECNICOIND";
    private static final String ARQUITETO = "ARQUITETO";
    private static final String AREA_PRINCIPAL = "P";
    private static final String AREA_COMPLEMENTAR = "C";
    private static final Long VINCULO_PROPRIETARIO_IMOVEL = 51L;
    private static final Long VINCULO_DONO_OBRA = 52L;
    private static final Long VINCULO_EMPRESA_CONSTRUTORA = 53L;
    private static final Long VINCULO_INCORPORADORA_CIVIL = 54L;
    private static final String TRAVESSA = "TRAVESSA";
    private static final String RUELA = "RUELA";
    private static final String ANEL_VIARIO = "ANEL VIARIO";
    private static final String ROTATORIA = "ROTAT\u00d3RIA";
    private static final String ALAMEDA = "ALAMEDA";
    private static final String AVENIDA = "AVENIDA";
    private static final String RUA = "RUA";

    public static String buildXmlAlvara(SisObraAlvara alvara, List<SisObraAlvaraArea> alvaraArea) {
        return SisObraAlvaraXmlBuilder.buildXml((SisObraAlvara)alvara, alvaraArea);
    }

    private static String buildXml(SisObraAlvara alvara, List<SisObraAlvaraArea> alvaraAreas) {
        SisObraPrefXmlDTO sisObraPrefXmlDTO = new SisObraPrefXmlDTO();
        AlvaraXmlDTO alvaraXmlDTO = new AlvaraXmlDTO();
        InfAlvaraXmlDTO infAlvaraXmlDTO = new InfAlvaraXmlDTO();
        sisObraPrefXmlDTO.setVersao("1.03");
        infAlvaraXmlDTO.setId("id0000001");
        infAlvaraXmlDTO.setNumeroAlvara(alvara.getIdSisobraAlvara());
        infAlvaraXmlDTO.setNomeObra(alvara.getNomeObra());
        infAlvaraXmlDTO.setDataAlvara(String.valueOf(alvara.getDataAlvara()));
        infAlvaraXmlDTO.setDataInicioObra(String.valueOf(alvara.getDataInicioObra()));
        if (alvara.getDataFinalObra() != null) {
            infAlvaraXmlDTO.setDataFinalObra(String.valueOf(alvara.getDataFinalObra()));
        }
        infAlvaraXmlDTO.setTipoAlvara(TipoAlvara.INICIAL.getDescricao());
        infAlvaraXmlDTO.setResponsavelExecObra(SisObraAlvaraXmlBuilder.getFactoryResponsavelExecObra((SisObraAlvara)alvara));
        infAlvaraXmlDTO.setEnderecoObra(SisObraAlvaraXmlBuilder.getEnderecoObra((SisObraAlvara)alvara));
        infAlvaraXmlDTO.setUnidadeMedida(UnidadeMedida.fromValue((Long)alvara.getUnidadeMedida()).getDescricao());
        infAlvaraXmlDTO.setArea(SisObraAlvaraXmlBuilder.getListArea(alvaraAreas));
        infAlvaraXmlDTO.setProprietarioObra(SisObraAlvaraXmlBuilder.getProprietarioObra((SisObraAlvara)alvara));
        infAlvaraXmlDTO.setInfoAdicionais(SisObraAlvaraXmlBuilder.getInformacoesAdicionais((SisObraAlvara)alvara));
        alvaraXmlDTO.setInfAlvara(infAlvaraXmlDTO);
        sisObraPrefXmlDTO.setAlvara(alvaraXmlDTO);
        XmlMapper xmlMapper = new XmlMapper();
        try {
            return xmlMapper.writeValueAsString((Object)sisObraPrefXmlDTO);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static ResponsavelAlvaraXmlDTO getFactoryResponsavelProjeto(SisObraAlvara alvara) {
        EngenheiroXmlDTO responsavelAlvaraXmlDTO = null;
        if (alvara.getTipoRespProjeto().equals("ENGENHEIRO")) {
            EngenheiroXmlDTO engenheiroXmlDTO = new EngenheiroXmlDTO();
            CamposEngenheiroXmlDTO camposEngenheiroXmlDTO = new CamposEngenheiroXmlDTO();
            camposEngenheiroXmlDTO.setNome(alvara.getRespProjNomeEngenheiro());
            camposEngenheiroXmlDTO.setCrea(alvara.getNroCarteiraRespProjeto());
            camposEngenheiroXmlDTO.setArt(alvara.getRespProjNumeroArt());
            engenheiroXmlDTO.setCampos(camposEngenheiroXmlDTO);
            responsavelAlvaraXmlDTO = engenheiroXmlDTO;
        }
        if (alvara.getTipoRespProjeto().equals("TECNICOIND")) {
            AlvaraIndXmlDTO tecnicoIndXmlDTO = new AlvaraIndXmlDTO();
            CamposTecnicoIndustrialXmlDTO camposTecnicoIndustrialXmlDTO = new CamposTecnicoIndustrialXmlDTO();
            camposTecnicoIndustrialXmlDTO.setNome(alvara.getRespProjNomeEngenheiro());
            camposTecnicoIndustrialXmlDTO.setCftCrt(alvara.getNroCarteiraRespProjeto());
            camposTecnicoIndustrialXmlDTO.setTrt(alvara.getRespTecnicoNumeroTrt());
            tecnicoIndXmlDTO.setCampos(camposTecnicoIndustrialXmlDTO);
            responsavelAlvaraXmlDTO = tecnicoIndXmlDTO;
        }
        if (alvara.getTipoRespProjeto().equals("ARQUITETO")) {
            ArquitetoXmlDTO arquitetoXmlDTO = new ArquitetoXmlDTO();
            CamposArquitetoXmlDTO camposArquitetoXmlDTO = new CamposArquitetoXmlDTO();
            camposArquitetoXmlDTO.setNome(alvara.getRespProjNomeArquiteto());
            camposArquitetoXmlDTO.setCau(alvara.getNroCarteiraRespProjeto());
            camposArquitetoXmlDTO.setRrt(alvara.getRespProjNumeroRrt());
            arquitetoXmlDTO.setCampos(camposArquitetoXmlDTO);
            responsavelAlvaraXmlDTO = arquitetoXmlDTO;
        }
        return responsavelAlvaraXmlDTO;
    }

    private static ResponsavelAlvaraXmlDTO getFactoryResponsavelTecnico(SisObraAlvara alvara) {
        CamposEngenheiroXmlDTO camposEngenheiroXmlDTO;
        EngenheiroXmlDTO responsavelAlvaraXmlDTO = null;
        if (alvara.getTipoRespExec().equals("ENGENHEIRO")) {
            EngenheiroXmlDTO engenheiroXmlDTO = new EngenheiroXmlDTO();
            camposEngenheiroXmlDTO = new CamposEngenheiroXmlDTO();
            camposEngenheiroXmlDTO.setNome(alvara.getRespTecnicoNomeEngenheiro());
            camposEngenheiroXmlDTO.setCrea(alvara.getNroCarteiraRespTecnico());
            camposEngenheiroXmlDTO.setArt(alvara.getRespTecnicoNumeroArt());
            engenheiroXmlDTO.setCampos(camposEngenheiroXmlDTO);
            responsavelAlvaraXmlDTO = engenheiroXmlDTO;
        }
        if (alvara.getTipoRespExec().equals("TECNOLOGO")) {
            TecnologoXmlDTO tecnologoXmlDTO = new TecnologoXmlDTO();
            camposEngenheiroXmlDTO = new CamposEngenheiroXmlDTO();
            camposEngenheiroXmlDTO.setNome(alvara.getRespTecnicoNomeEngenheiro());
            camposEngenheiroXmlDTO.setCrea(alvara.getNroCarteiraRespTecnico());
            camposEngenheiroXmlDTO.setArt(alvara.getRespTecnicoNumeroArt());
            tecnologoXmlDTO.setCampos(camposEngenheiroXmlDTO);
            responsavelAlvaraXmlDTO = tecnologoXmlDTO;
        }
        if (alvara.getTipoRespExec().equals("TECNICOIND")) {
            AlvaraIndXmlDTO tecnicoIndXmlDTO = new AlvaraIndXmlDTO();
            CamposTecnicoIndustrialXmlDTO camposTecnicoIndustrialXmlDTO = new CamposTecnicoIndustrialXmlDTO();
            camposTecnicoIndustrialXmlDTO.setNome(alvara.getRespTecnicoNomeEngenheiro());
            camposTecnicoIndustrialXmlDTO.setCftCrt(alvara.getNroCarteiraRespTecnico());
            camposTecnicoIndustrialXmlDTO.setTrt(alvara.getRespTecnicoNumeroTrt());
            tecnicoIndXmlDTO.setCampos(camposTecnicoIndustrialXmlDTO);
            responsavelAlvaraXmlDTO = tecnicoIndXmlDTO;
        }
        if (alvara.getTipoRespExec().equals("ARQUITETO")) {
            ArquitetoXmlDTO arquitetoXmlDTO = new ArquitetoXmlDTO();
            CamposArquitetoXmlDTO camposArquitetoXmlDTO = new CamposArquitetoXmlDTO();
            camposArquitetoXmlDTO.setNome(alvara.getRespProjNomeArquiteto());
            camposArquitetoXmlDTO.setCau(alvara.getNroCarteiraRespTecnico());
            camposArquitetoXmlDTO.setRrt(alvara.getRespTecnicoNumeroRrt());
            arquitetoXmlDTO.setCampos(camposArquitetoXmlDTO);
            responsavelAlvaraXmlDTO = arquitetoXmlDTO;
        }
        return responsavelAlvaraXmlDTO;
    }

    private static InformacoesAdicionaisXmlDTO getInformacoesAdicionais(SisObraAlvara alvara) {
        InformacoesAdicionaisXmlDTO informacoesAdicionaisXmlDTO = new InformacoesAdicionaisXmlDTO();
        informacoesAdicionaisXmlDTO.setSituacao(alvara.getSituacao());
        informacoesAdicionaisXmlDTO.setClasse(alvara.getClasse());
        if (!alvara.getNumeroProcesso().isEmpty()) {
            informacoesAdicionaisXmlDTO.setNumeroProcesso(alvara.getNumeroProcesso());
        }
        if (alvara.getTipoRespExec() != null) {
            informacoesAdicionaisXmlDTO.setResponsavelTecnico(SisObraAlvaraXmlBuilder.getFactoryResponsavelTecnico((SisObraAlvara)alvara));
        }
        if (alvara.getTipoRespProjeto() != null) {
            informacoesAdicionaisXmlDTO.setResponsavelProjeto(SisObraAlvaraXmlBuilder.getFactoryResponsavelProjeto((SisObraAlvara)alvara));
        }
        if (StringUtils.isNotBlank((String)alvara.getEspecificacao())) {
            informacoesAdicionaisXmlDTO.setEspecificacao(alvara.getEspecificacao());
        }
        if (StringUtils.isNotBlank((String)alvara.getObservacao())) {
            informacoesAdicionaisXmlDTO.setObservacao(alvara.getObservacao());
        }
        if (informacoesAdicionaisXmlDTO.getClasse() != null || informacoesAdicionaisXmlDTO.getSituacao() != null || informacoesAdicionaisXmlDTO.getNumeroProcesso() != null || informacoesAdicionaisXmlDTO.getResponsavelProjeto() != null || informacoesAdicionaisXmlDTO.getResponsavelTecnico() != null || informacoesAdicionaisXmlDTO.getEspecificacao() != null || informacoesAdicionaisXmlDTO.getObservacao() != null) {
            return informacoesAdicionaisXmlDTO;
        }
        return null;
    }

    private static ProprietarioObraXmlDTO getProprietarioObra(SisObraAlvara alvara) {
        ProprietarioObraXmlDTO proprietarioObraXmlDTO = new ProprietarioObraXmlDTO();
        if (alvara.getCpfProprietarioObra() != null && !alvara.getCpfProprietarioObra().isEmpty()) {
            proprietarioObraXmlDTO.setCpf(alvara.getCpfProprietarioObra());
        }
        if (alvara.getCnpjProprietarioObra() != null && !alvara.getCnpjProprietarioObra().isEmpty()) {
            proprietarioObraXmlDTO.setCnpj(alvara.getCnpjProprietarioObra());
        }
        return proprietarioObraXmlDTO;
    }

    private static AreaPrincipalItemXmlDTO buildAreaPrincipal(List<SisObraAlvaraArea> grupo, SisObraAlvaraArea item) {
        BigDecimal totalUnidades = grupo.stream().map(SisObraAlvaraArea::getQtdTotalUnidade).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalArea = grupo.stream().map(SisObraAlvaraArea::getArea).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        AreaPrincipalItemXmlDTO dto = new AreaPrincipalItemXmlDTO();
        dto.setCategoria(AlvaraAreaCategoria.fromValue((Long)item.getCategoria()).getDescricao());
        dto.setDestinacao(AlvaraAreaDestinacao.fromValue((Long)item.getDestinacao()).getDescricao());
        dto.setTipoObra(AlvaraAreaTipoObra.fromValue((Long)item.getTipoObra()).getDescricao());
        if (AlvaraAreaDestinacao.CONJUNTO_HABITACIONAL_POPULAR.equals((Object)dto.getDestinacao())) {
            dto.setQtdTotalUnidadesBloco(String.valueOf(totalUnidades));
        }
        dto.setArea(String.format("%.2f", totalArea).replace(",", "."));
        return dto;
    }

    private static AreaComplementarItemXmlDTO buildAreaComplementar(List<SisObraAlvaraArea> grupo, SisObraAlvaraArea item) {
        BigDecimal totalUnidades = grupo.stream().map(SisObraAlvaraArea::getQtdTotalUnidade).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalAreaCoberta = grupo.stream().map(SisObraAlvaraArea::getAreaCoberta).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalAreaDescoberta = grupo.stream().map(SisObraAlvaraArea::getAreaDescoberta).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        AreaComplementarItemXmlDTO dto = new AreaComplementarItemXmlDTO();
        dto.setCategoria(AlvaraAreaCategoria.fromValue((Long)item.getCategoria()).getDescricao());
        dto.setDestinacao(AlvaraAreaDestinacao.fromValue((Long)item.getDestinacao()).getDescricao());
        dto.setTipoObra(AlvaraAreaTipoObra.fromValue((Long)item.getTipoObra()).getDescricao());
        dto.setTipoAreaComplementar(AlvaraAreaComplementarTipo.fromValue((Long)item.getTipoArea()).getDescricao());
        if (AlvaraAreaDestinacao.CONJUNTO_HABITACIONAL_POPULAR.equals((Object)dto.getDestinacao())) {
            dto.setQtdTotalUnidadesBloco(String.valueOf(totalUnidades));
        }
        dto.setAreaCoberta(String.format("%.2f", totalAreaCoberta).replace(",", "."));
        dto.setAreaDescoberta(String.format("%.2f", totalAreaDescoberta).replace(",", "."));
        return dto;
    }

    private static AreaItemXmlDTO getListArea(List<SisObraAlvaraArea> alvaraAreas) {
        Map<List, List<SisObraAlvaraArea>> areasAgrupadas = alvaraAreas.stream().collect(Collectors.groupingBy(area -> Arrays.asList(area.getTipo(), area.getCategoria(), area.getDestinacao(), area.getTipoObra())));
        AreaItemXmlDTO areaItemXmlDTO = new AreaItemXmlDTO();
        ArrayList<AreaPrincipalItemXmlDTO> areaPrincipalList = new ArrayList<AreaPrincipalItemXmlDTO>();
        ArrayList<AreaPrincipalItemXmlDTO> areaComplementarList = new ArrayList<AreaPrincipalItemXmlDTO>();
        for (Map.Entry<List, List<SisObraAlvaraArea>> entry : areasAgrupadas.entrySet()) {
            AreaPrincipalItemXmlDTO dto;
            List<SisObraAlvaraArea> grupo = entry.getValue();
            SisObraAlvaraArea item = grupo.getFirst();
            if ("P".equals(item.getTipo())) {
                dto = SisObraAlvaraXmlBuilder.buildAreaPrincipal(grupo, (SisObraAlvaraArea)item);
                areaPrincipalList.add(dto);
            }
            if (!"C".equals(item.getTipo())) continue;
            dto = SisObraAlvaraXmlBuilder.buildAreaComplementar(grupo, (SisObraAlvaraArea)item);
            areaComplementarList.add(dto);
        }
        if (!areaPrincipalList.isEmpty()) {
            areaItemXmlDTO.setAreaPrincipal(areaPrincipalList);
        }
        if (!areaComplementarList.isEmpty()) {
            areaItemXmlDTO.setAreaComplementar(areaComplementarList);
        }
        return areaItemXmlDTO;
    }

    private static String getTipoLogradouro(String tipoLogradouro) {
        if (Objects.isNull(tipoLogradouro) || tipoLogradouro.trim().isEmpty()) {
            return tipoLogradouro;
        }
        return switch (tipoLogradouro.toUpperCase()) {
            case "TRAVESSA" -> "ALAMEDA";
            case "RUELA" -> "ALAMEDA";
            case "ANEL VIARIO" -> "AVENIDA";
            case "ROTAT\u00d3RIA" -> "RUA";
            default -> tipoLogradouro;
        };
    }

    private static EnderecoObraXmlDTO getEnderecoObra(SisObraAlvara alvara) {
        EnderecoObraXmlDTO enderecoObraXmlDTO = new EnderecoObraXmlDTO();
        enderecoObraXmlDTO.setCep(alvara.getObraCep());
        enderecoObraXmlDTO.setTipoLogradouro(SisObraAlvaraXmlBuilder.getTipoLogradouro((String)alvara.getObraTipoLogradouro()));
        enderecoObraXmlDTO.setLogradouro(alvara.getObraLogradouro());
        if (alvara.getObraNumero() != null) {
            enderecoObraXmlDTO.setNumero(alvara.getObraNumero());
        } else {
            enderecoObraXmlDTO.setNumero(String.valueOf(0L));
        }
        if (alvara.getObraComplemento() != null && !alvara.getObraComplemento().isEmpty()) {
            enderecoObraXmlDTO.setComplemento(alvara.getObraComplemento());
        }
        enderecoObraXmlDTO.setBairro(alvara.getObraBairro());
        return enderecoObraXmlDTO;
    }

    private static ResponsavelExecObraXmlDTO getFactoryResponsavelExecObra(SisObraAlvara alvara) {
        ElementoCnpjAndCpfXmlDTO cnpjAndCpf;
        ProprietarioImovelXmlDTO responsavelExecObraXmlDTO = null;
        if (alvara.getTipoVinculo().equals(VINCULO_PROPRIETARIO_IMOVEL)) {
            responsavelExecObraXmlDTO = new ProprietarioImovelXmlDTO();
        }
        if (alvara.getTipoVinculo().equals(VINCULO_DONO_OBRA)) {
            DonoObraXmlDTO donoObraXmlDTO = new DonoObraXmlDTO();
            cnpjAndCpf = new ElementoCnpjAndCpfXmlDTO();
            if (alvara.getCnpjDonoObra() != null && !alvara.getCnpjDonoObra().isEmpty()) {
                cnpjAndCpf.setCnpj(alvara.getCnpjDonoObra());
            }
            if (alvara.getCpfDonoObra() != null && !alvara.getCpfDonoObra().isEmpty()) {
                cnpjAndCpf.setCpf(alvara.getCpfDonoObra());
            }
            donoObraXmlDTO.setCnpjAndCpf(cnpjAndCpf);
            responsavelExecObraXmlDTO = donoObraXmlDTO;
        }
        if (alvara.getTipoVinculo().equals(VINCULO_EMPRESA_CONSTRUTORA)) {
            EmpresaConstrutoraXmlDTO empresaConstrutoraXmlDTO = new EmpresaConstrutoraXmlDTO();
            cnpjAndCpf = new ElementoCnpjAndCpfXmlDTO();
            cnpjAndCpf.setCnpj(alvara.getCnpjEmpresaConstrutora());
            empresaConstrutoraXmlDTO.setCnpjAndCpf(cnpjAndCpf);
            responsavelExecObraXmlDTO = empresaConstrutoraXmlDTO;
        }
        if (alvara.getTipoVinculo().equals(VINCULO_INCORPORADORA_CIVIL)) {
            IncorporadorConstrucaoCivilXmlDTO incorporadorConstrucaoCivilXmlDTO = new IncorporadorConstrucaoCivilXmlDTO();
            cnpjAndCpf = new ElementoCnpjAndCpfXmlDTO();
            if (alvara.getCpfIncorporadorConcivil() != null && !alvara.getCpfIncorporadorConcivil().isEmpty()) {
                cnpjAndCpf.setCpf(alvara.getCpfIncorporadorConcivil());
            }
            if (alvara.getCnpjIncorporadorConcivil() != null && !alvara.getCnpjIncorporadorConcivil().isEmpty()) {
                cnpjAndCpf.setCnpj(alvara.getCnpjIncorporadorConcivil());
            }
            incorporadorConstrucaoCivilXmlDTO.setCnpjAndCpf(cnpjAndCpf);
            responsavelExecObraXmlDTO = incorporadorConstrucaoCivilXmlDTO;
        }
        return responsavelExecObraXmlDTO;
    }
}

