/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.util.cenprot;

import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.protesto.Protesto;
import br.com.elotech.tributos.dto.ListasNecessariasCalculaAcrescimoDTO;
import br.com.elotech.tributos.integration.cenprotms.generated.DividaEnviar;
import br.com.elotech.tributos.integration.cenprotms.generated.EnviarTituloRequestData;
import br.com.elotech.tributos.util.cenprot.CenprotMSDevedorMapper;
import br.com.elotech.tributos.util.cenprot.CenprotMSDividaMapper;
import java.time.LocalDate;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CenprotMSTituloMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CenprotMSTituloMapper.class);
    private final CenprotMSDividaMapper dividaMapper;

    public EnviarTituloRequestData toEnviarTituloRequest(Protesto protesto) {
        return this.toEnviarTituloRequest(protesto, null);
    }

    public EnviarTituloRequestData toEnviarTituloRequest(Protesto protesto, ListasNecessariasCalculaAcrescimoDTO listas) {
        Documento documento = protesto.getDocumento();
        DividaEnviar divida = this.dividaMapper.toDividaEnviar(protesto, LocalDate.now(), listas);
        EnviarTituloRequestData request = new EnviarTituloRequestData();
        request.setAlteracao("N");
        request.getDevedor().addAll(CenprotMSDevedorMapper.toDevedorEnviarList((Documento)documento));
        request.setDivida(divida);
        return request;
    }

    @Generated
    public CenprotMSTituloMapper(CenprotMSDividaMapper dividaMapper) {
        this.dividaMapper = dividaMapper;
    }
}

