/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.util.cenprot;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.protesto.Protesto;
import br.com.elotech.tributos.dto.ListasNecessariasCalculaAcrescimoDTO;
import br.com.elotech.tributos.integration.cenprotms.generated.DividaEnviar;
import br.com.elotech.tributos.integration.cenprotms.generated.DocumentoEnviar;
import br.com.elotech.tributos.service.documento.DocumentoProtestoService;
import br.com.elotech.tributos.util.DateUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class CenprotMSDividaMapper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CenprotMSDividaMapper.class);
    private static final DateTimeFormatter DATE_FORMATTER = DateUtils.DATE_TIME_FORMATTER_FORMATO_BRASILEIRO_BARRAS;
    private static final int CASAS_DECIMAIS = 2;
    private static final int TAM_ESPECIE = 30;
    private static final int TAM_NUMERO = 11;
    private static final int TAM_NOSSO_NUMERO = 15;
    private static final int TAM_TIPO_ENDOSSO = 3;
    private static final int TAM_ACEITE = 1;
    private static final int TAM_FINS_FALIMENTARES = 1;
    private static final int TAM_DECLARACAO_PORTADOR = 1;
    private static final int TAM_EXTENSAO = 4;
    private static final long TAM_MAX_DOCUMENTO_BYTES = 0x3200000L;
    private final ApplicationContext applicationContext;
    private DocumentoProtestoService documentoProtestoService;

    public DividaEnviar toDividaEnviar(Protesto protesto, LocalDate dataReferencia, ListasNecessariasCalculaAcrescimoDTO listas) {
        Documento documento = protesto.getDocumento();
        DividaEnviar divida = new DividaEnviar();
        divida.setEspecie(this.truncar("CDA", 30));
        divida.setNumero(this.gerarNumeroTitulo(documento));
        divida.setNossoNumero(this.gerarNossoNumero(protesto));
        divida.setValor(this.formatarValorMonetario(documento.getValorTotalDividaAtivas()));
        divida.setSaldo(this.formatarValorMonetario(documento.getValorTotalDividaAtivas()));
        divida.setTipoEndosso(this.truncar("B", 3));
        divida.setAceite(this.truncar("N", 1));
        divida.setFinsFalimentares(this.truncar("A", 1));
        divida.setDeclaracaoPortador(this.truncar("A", 1));
        divida.setEmissao(this.formatarData(documento.getDataEmissao()));
        divida.setVencimento(this.formatarData(documento.getDataEmissao()));
        divida.getDocumento().addAll(this.gerarDocumentosCDA(documento, dataReferencia, listas));
        return divida;
    }

    private List<DocumentoEnviar> gerarDocumentosCDA(Documento documento, LocalDate dataReferencia, ListasNecessariasCalculaAcrescimoDTO listas) {
        try {
            byte[] cdaPdf = this.getDocumentoProtestoService().gerarCdaPdf(documento, dataReferencia, listas);
            this.validarTamanhoDocumento(cdaPdf, documento);
            String cdaBase64 = Base64.getEncoder().encodeToString(cdaPdf);
            DocumentoEnviar documentoEnviar = new DocumentoEnviar();
            documentoEnviar.setExtensao(this.truncar("pdf", 4));
            documentoEnviar.setDocumentoBase64(cdaBase64);
            return List.of(documentoEnviar);
        }
        catch (EloValidationException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Erro ao gerar CDA em base64 para documento {}/{}: {}", new Object[]{documento.getDocumento(), documento.getExercicio(), e.getMessage(), e});
            throw new EloValidationException(String.format("Erro ao gerar CDA para documento %d/%d", documento.getDocumento(), documento.getExercicio()));
        }
    }

    private void validarTamanhoDocumento(byte[] cdaPdf, Documento documento) {
        if ((long)cdaPdf.length > 0x3200000L) {
            String tamanhoMB = String.format("%.2f", (double)cdaPdf.length / 1048576.0);
            log.error("Documento {}/{} excede tamanho m\u00e1ximo permitido: {} MB", new Object[]{documento.getDocumento(), documento.getExercicio(), tamanhoMB});
            throw new EloValidationException(String.format("CDA do documento %d/%d excede o tamanho m\u00e1ximo de 50MB (tamanho: %s MB)", documento.getDocumento(), documento.getExercicio(), tamanhoMB));
        }
    }

    private DocumentoProtestoService getDocumentoProtestoService() {
        if (this.documentoProtestoService == null) {
            this.documentoProtestoService = (DocumentoProtestoService)this.applicationContext.getBean(DocumentoProtestoService.class);
        }
        return this.documentoProtestoService;
    }

    private String gerarNumeroTitulo(Documento documento) {
        String numero = String.format("%d/%d", documento.getDocumento(), documento.getExercicio());
        if (numero.length() > 11) {
            log.warn("N\u00famero do t\u00edtulo '{}' excede tamanho m\u00e1ximo de {} caracteres. Ser\u00e1 truncado.", (Object)numero, (Object)11);
        }
        return this.truncar(numero, 11);
    }

    private String gerarNossoNumero(Protesto protesto) {
        String nossoNumero = String.format("%d%d%d", protesto.getExercicio(), protesto.getDocumento().getTipoDocumento(), protesto.getDocumento().getDocumento());
        if (nossoNumero.length() > 15) {
            log.warn("Nosso n\u00famero '{}' excede tamanho m\u00e1ximo de {} caracteres. Ser\u00e1 truncado.", (Object)nossoNumero, (Object)15);
        }
        return this.truncar(nossoNumero, 15);
    }

    private String formatarValorMonetario(BigDecimal valor) {
        if (valor == null) {
            return "0.00";
        }
        return valor.setScale(2, RoundingMode.HALF_UP).toString();
    }

    private String formatarData(LocalDate data) {
        if (data == null) {
            throw new IllegalArgumentException("Data n\u00e3o pode ser nula");
        }
        return data.format(DATE_FORMATTER);
    }

    private String truncar(String valor, int tamanhoMaximo) {
        if (valor == null) {
            return null;
        }
        return valor.length() > tamanhoMaximo ? valor.substring(0, tamanhoMaximo) : valor;
    }

    @Generated
    public CenprotMSDividaMapper(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

