/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.util.cenprot;

import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.DocumentoPessoa;
import br.com.elotech.tributos.domain.EnderecoPessoa;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.UnidadeFederacao;
import br.com.elotech.tributos.integration.cenprotms.generated.DevedorEnviar;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

/*
 * Exception performing whole class analysis ignored.
 */
public class CenprotMSDevedorMapper {
    private static final String SEM_NUMERO = "S/N";
    private static final String SIM = "S";
    private static final String NAO = "N";
    private static final String TIPO_CPF_CODIGO = "1";
    private static final String TIPO_CNPJ_CODIGO = "2";
    private static final int TAMANHO_CNPJ = 14;
    private static final String REGEX_NAO_DIGITOS = "\\D";
    private static final int TAM_NOME = 100;
    private static final int TAM_DOCUMENTO = 14;
    private static final int TAM_ENDERECO = 100;
    private static final int TAM_NUMERO = 10;
    private static final int TAM_COMPLEMENTO = 50;
    private static final int TAM_CEP = 8;
    private static final int TAM_BAIRRO = 20;
    private static final int TAM_MUNICIPIO = 50;
    private static final int TAM_UF = 2;
    private static final int TAM_FONE = 40;
    private static final int TAM_EMAIL = 100;

    private CenprotMSDevedorMapper() {
    }

    public static List<DevedorEnviar> toDevedorEnviarList(Documento documento) {
        return documento.getDocumentoPessoas().stream().sorted(Comparator.comparing(dp -> dp.getPrincipal() == null || dp.getPrincipal() == false ? 1 : 0)).map(CenprotMSDevedorMapper::toDevedorEnviar).toList();
    }

    private static DevedorEnviar toDevedorEnviar(DocumentoPessoa documentoPessoa) {
        Pessoa pessoa = documentoPessoa.getPessoa();
        if (pessoa == null) {
            throw new IllegalArgumentException("N\u00e3o \u00e9 poss\u00edvel mapear DevedorEnviar: Pessoa \u00e9 nula");
        }
        EnderecoPessoa endereco = pessoa.getEnderecoPrincipal();
        CenprotMSDevedorMapper.validarCamposObrigatorios((Pessoa)pessoa, (EnderecoPessoa)endereco);
        DevedorEnviar devedor = CenprotMSDevedorMapper.criarDevedorComDadosObrigatorios((Pessoa)pessoa, (EnderecoPessoa)endereco);
        CenprotMSDevedorMapper.preencherDadosOpcionais((DevedorEnviar)devedor, (DocumentoPessoa)documentoPessoa, (Pessoa)pessoa, (EnderecoPessoa)endereco);
        return devedor;
    }

    private static DevedorEnviar criarDevedorComDadosObrigatorios(Pessoa pessoa, EnderecoPessoa endereco) {
        DevedorEnviar devedor = new DevedorEnviar();
        devedor.setNome(CenprotMSDevedorMapper.truncar((String)pessoa.getNome(), (int)100));
        devedor.setDocumentoTipo(CenprotMSDevedorMapper.determinarTipoDocumento((String)pessoa.getCnpjCpf()));
        devedor.setDocumento(CenprotMSDevedorMapper.truncar((String)CenprotMSDevedorMapper.limparDocumento((String)pessoa.getCnpjCpf()), (int)14));
        devedor.setEndereco(CenprotMSDevedorMapper.truncar((String)endereco.getLogradouro().getDescricao(), (int)100));
        devedor.setNumero(CenprotMSDevedorMapper.truncar((String)CenprotMSDevedorMapper.obterNumeroOuPadrao((EnderecoPessoa)endereco), (int)10));
        devedor.setCep(CenprotMSDevedorMapper.truncar((String)CenprotMSDevedorMapper.limparCep((String)endereco.getCep().toString()), (int)8));
        devedor.setBairro(CenprotMSDevedorMapper.truncar((String)endereco.getBairro().getDescricao(), (int)20));
        devedor.setMunicipio(CenprotMSDevedorMapper.truncar((String)endereco.getCidade().getDescricao(), (int)50));
        devedor.setUf(CenprotMSDevedorMapper.truncar((String)endereco.getUnidadeFederacao().getUnidadeFederacao(), (int)2));
        return devedor;
    }

    private static void preencherDadosOpcionais(DevedorEnviar devedor, DocumentoPessoa documentoPessoa, Pessoa pessoa, EnderecoPessoa endereco) {
        CenprotMSDevedorMapper.preencherComplemento((DevedorEnviar)devedor, (EnderecoPessoa)endereco);
        CenprotMSDevedorMapper.preencherPrincipal((DevedorEnviar)devedor, (DocumentoPessoa)documentoPessoa);
        CenprotMSDevedorMapper.preencherContato((DevedorEnviar)devedor, (Pessoa)pessoa);
    }

    private static void preencherComplemento(DevedorEnviar devedor, EnderecoPessoa endereco) {
        if (CenprotMSDevedorMapper.isStringValida((String)endereco.getComplemento())) {
            devedor.setComplemento(CenprotMSDevedorMapper.truncar((String)endereco.getComplemento(), (int)50));
        }
    }

    private static void preencherPrincipal(DevedorEnviar devedor, DocumentoPessoa documentoPessoa) {
        Optional.ofNullable(documentoPessoa.getPrincipal()).ifPresent(principal -> devedor.setPrincipal(principal != false ? "S" : "N"));
    }

    private static void preencherContato(DevedorEnviar devedor, Pessoa pessoa) {
        Optional.ofNullable(pessoa.getContatoPrincipal()).ifPresent(contato -> {
            Optional.ofNullable(contato.getTelefoneCelular()).filter(CenprotMSDevedorMapper::isStringValida).ifPresent(fone -> devedor.setFone(CenprotMSDevedorMapper.truncar((String)fone, (int)40)));
            Optional.ofNullable(contato.getEmail()).filter(CenprotMSDevedorMapper::isStringValida).ifPresent(email -> devedor.setEmail(CenprotMSDevedorMapper.truncar((String)email, (int)100)));
        });
    }

    private static String obterNumeroOuPadrao(EnderecoPessoa endereco) {
        return CenprotMSDevedorMapper.isStringValida((String)endereco.getNumero()) ? endereco.getNumero() : "S/N";
    }

    private static void validarCamposObrigatorios(Pessoa pessoa, EnderecoPessoa endereco) {
        CenprotMSDevedorMapper.validarPessoa((Pessoa)pessoa);
        CenprotMSDevedorMapper.validarEndereco((EnderecoPessoa)endereco, (String)pessoa.getNome());
    }

    private static void validarPessoa(Pessoa pessoa) {
        CenprotMSDevedorMapper.validarCampoTextoObrigatorio((String)pessoa.getNome(), (String)"Nome do devedor \u00e9 obrigat\u00f3rio");
        CenprotMSDevedorMapper.validarCampoTextoObrigatorio((String)pessoa.getCnpjCpf(), (String)String.format("%s n\u00e3o possui CPF/CNPJ cadastrado", pessoa.getNome()));
    }

    private static void validarEndereco(EnderecoPessoa endereco, String nomeDevedor) {
        CenprotMSDevedorMapper.validarCampoObrigatorio((Object)endereco, (String)String.format("%s n\u00e3o possui endere\u00e7o principal cadastrado", nomeDevedor));
        CenprotMSDevedorMapper.validarLogradouro((EnderecoPessoa)endereco, (String)nomeDevedor);
        CenprotMSDevedorMapper.validarCep((EnderecoPessoa)endereco, (String)nomeDevedor);
        CenprotMSDevedorMapper.validarBairro((EnderecoPessoa)endereco, (String)nomeDevedor);
        CenprotMSDevedorMapper.validarCidade((EnderecoPessoa)endereco, (String)nomeDevedor);
        CenprotMSDevedorMapper.validarUf((EnderecoPessoa)endereco, (String)nomeDevedor);
    }

    private static void validarLogradouro(EnderecoPessoa endereco, String nomeDevedor) {
        CenprotMSDevedorMapper.validarObjetoComDescricao((Object)endereco.getLogradouro(), Logradouro::getDescricao, (String)String.format("%s n\u00e3o possui endere\u00e7o cadastrado em seu endere\u00e7o principal", nomeDevedor));
    }

    private static void validarCep(EnderecoPessoa endereco, String nomeDevedor) {
        CenprotMSDevedorMapper.validarCampoObrigatorio((Object)endereco.getCep(), (String)String.format("%s n\u00e3o possui CEP cadastrado em seu endere\u00e7o principal", nomeDevedor));
    }

    private static void validarBairro(EnderecoPessoa endereco, String nomeDevedor) {
        CenprotMSDevedorMapper.validarObjetoComDescricao((Object)endereco.getBairro(), Bairro::getDescricao, (String)String.format("%s n\u00e3o possui bairro cadastrado em seu endere\u00e7o principal", nomeDevedor));
    }

    private static void validarCidade(EnderecoPessoa endereco, String nomeDevedor) {
        CenprotMSDevedorMapper.validarObjetoComDescricao((Object)endereco.getCidade(), Cidade::getDescricao, (String)String.format("%s n\u00e3o possui cidade cadastrada em seu endere\u00e7o principal", nomeDevedor));
    }

    private static void validarUf(EnderecoPessoa endereco, String nomeDevedor) {
        CenprotMSDevedorMapper.validarObjetoComDescricao((Object)endereco.getUnidadeFederacao(), UnidadeFederacao::getUnidadeFederacao, (String)String.format("%s n\u00e3o possui UF cadastrada em seu endere\u00e7o principal", nomeDevedor));
    }

    private static void validarCampoObrigatorio(Object campo, String mensagemErro) {
        if (campo == null) {
            throw new IllegalArgumentException(mensagemErro);
        }
    }

    private static void validarCampoTextoObrigatorio(String campo, String mensagemErro) {
        if (!CenprotMSDevedorMapper.isStringValida((String)campo)) {
            throw new IllegalArgumentException(mensagemErro);
        }
    }

    private static <T> void validarObjetoComDescricao(T objeto, Function<T, String> extrator, String mensagemErro) {
        if (objeto == null || !CenprotMSDevedorMapper.isStringValida((String)extrator.apply(objeto))) {
            throw new IllegalArgumentException(mensagemErro);
        }
    }

    private static boolean isStringValida(String valor) {
        return valor != null && !valor.trim().isEmpty();
    }

    private static String determinarTipoDocumento(String cpfCnpj) {
        if (cpfCnpj == null) {
            return "1";
        }
        String documentoLimpo = cpfCnpj.replaceAll("\\D", "");
        return documentoLimpo.length() == 14 ? "2" : "1";
    }

    private static String limparDocumento(String documento) {
        return documento != null ? documento.replaceAll("\\D", "") : "";
    }

    private static String limparCep(String cep) {
        return cep != null ? cep.replaceAll("\\D", "") : "";
    }

    private static String truncar(String valor, int tamanhoMaximo) {
        if (valor == null) {
            return null;
        }
        return valor.length() > tamanhoMaximo ? valor.substring(0, tamanhoMaximo) : valor;
    }
}

