/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.util;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.exception.PaginationException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.springframework.batch.support.DatabaseType;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.MetaDataAccessException;

/*
 * Exception performing whole class analysis ignored.
 */
public final class SqlUtils {
    private SqlUtils() {
    }

    public static String withPagination(String query, Pageable pageable, DataSource dataSource) {
        try {
            return SqlUtils.withPagination((String)query, (Pageable)pageable, (DatabaseType)DatabaseType.fromMetaData((DataSource)dataSource));
        }
        catch (MetaDataAccessException e) {
            throw new PaginationException("Erro ao extrair os metadados do banco", (Throwable)e);
        }
    }

    public static String withPagination(String query, Pageable pageable, DatabaseType dbType) {
        StringBuilder queryBuilder = new StringBuilder();
        if (DatabaseType.POSTGRES.equals((Object)dbType) || DatabaseType.H2.equals((Object)dbType)) {
            queryBuilder.append(query).append(" LIMIT ").append(pageable.getPageSize()).append(" OFFSET ").append(pageable.getOffset());
        } else if (DatabaseType.ORACLE.equals((Object)dbType)) {
            long fim = pageable.getOffset() + (long)pageable.getPageSize();
            queryBuilder.append("SELECT * FROM (SELECT R.*, ROWNUM AS RN FROM (").append(query).append(String.format(") R WHERE ROWNUM <= %d) v WHERE V.RN > %d", fim, pageable.getOffset()));
        } else {
            return query;
        }
        return queryBuilder.toString();
    }

    public static String convertSortToString(Sort sort) {
        return sort.stream().map(property -> String.format("%s %s", property.getProperty(), property.getDirection().name())).collect(Collectors.joining(", "));
    }

    public static DatabaseType getDatabaseType(DataSource dataSource) {
        DatabaseType databaseType;
        try {
            databaseType = DatabaseType.fromMetaData((DataSource)Objects.requireNonNull(dataSource));
        }
        catch (MetaDataAccessException e) {
            throw new PaginationException("Erro ao extrair os metadados do banco", (Throwable)e);
        }
        if (!Arrays.asList(DatabaseType.ORACLE, DatabaseType.POSTGRES, DatabaseType.H2).contains(databaseType)) {
            throw new EloValidationException("Tipo de banco de dados n\u00e3o suportado.");
        }
        return databaseType;
    }

    public static String getFinalSort(Pageable pageable) {
        String pageableSort = pageable.getSort().toString().replace(":", "").replaceAll("(?i)unsorted", "");
        String finalSort = "";
        if (!pageableSort.isEmpty()) {
            finalSort = finalSort.concat(" ORDER BY " + pageableSort);
        }
        return finalSort;
    }

    public static <T> Comparator<T> toComparator(Sort sort) {
        return sort.stream().map(order -> {
            Comparator comparator = (item1, item2) -> {
                try {
                    Field field = item1.getClass().getDeclaredField(order.getProperty());
                    field.setAccessible(true);
                    Comparable value1 = (Comparable)field.get(item1);
                    Comparable value2 = (Comparable)field.get(item2);
                    return value1.compareTo(value2);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Error accessing field: " + order.getProperty(), e);
                }
            };
            return order.isDescending() ? comparator.reversed() : comparator;
        }).reduce(Comparator::thenComparing).orElse((item1, item2) -> 0);
    }

    public static Long getCountTotal(String sql, MapSqlParameterSource params, NamedParameterJdbcTemplate jdbcTemplate) {
        String sqlCount = String.format("select count(*) as total from (%s) count_query", sql);
        return (Long)jdbcTemplate.queryForObject(sqlCount, (SqlParameterSource)params, (rs, rowNum) -> rs.getLong("total"));
    }

    public static String getSqlComPaginacao(String sql, Pageable pageable, NamedParameterJdbcTemplate jdbcTemplate) {
        String finalSort = SqlUtils.getFinalSort((Pageable)pageable);
        return SqlUtils.withPagination((String)sql.concat(finalSort), (Pageable)pageable, (DataSource)jdbcTemplate.getJdbcTemplate().getDataSource());
    }
}

