/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.util;

import br.com.elotech.tributos.annotation.SplitField;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;

public class SplitUtils {
    public static <T> T getDtoFromStringWithDelimiter(String linha, String delimiter, Class<T> clazz) {
        try {
            String[] partes = linha.split(delimiter);
            T instancia = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            for (Field campo : clazz.getDeclaredFields()) {
                int index;
                SplitField anotacao = campo.getAnnotation(SplitField.class);
                if (anotacao == null || (index = anotacao.index()) >= partes.length) continue;
                campo.setAccessible(true);
                String valor = partes[index];
                Class<?> tipo = campo.getType();
                if (valor.isEmpty()) {
                    campo.set(instancia, null);
                    continue;
                }
                if (tipo == Long.class) {
                    campo.set(instancia, Long.valueOf(valor));
                    continue;
                }
                if (tipo == String.class) {
                    campo.set(instancia, valor);
                    continue;
                }
                if (tipo == LocalDate.class) {
                    String formato = anotacao.dateFormat();
                    if (formato.isEmpty()) {
                        throw new IllegalArgumentException("Campo " + campo.getName() + " requer 'dateFormat' na anota\u00e7\u00e3o SplitField");
                    }
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern(formato);
                    campo.set(instancia, LocalDate.parse(valor, formatter));
                    continue;
                }
                if (tipo != BigDecimal.class) continue;
                campo.set(instancia, new BigDecimal(valor.replace(",", ".")));
            }
            return instancia;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Erro ao mapear DTO. Linha %s", linha), e);
        }
    }
}

