/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.util;

import br.com.elotech.tributos.enums.OperadorFiltro;
import br.com.elotech.tributos.util.RsqlToNativeSqlParserUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

/*
 * Exception performing whole class analysis ignored.
 */
public final class RsqlToNativeSqlParserUtils {
    private static final String ASPAS_DUPLAS = "\"";
    private static final String ASPAS_SIMPLES = "'";
    private static final String UPPER = "UPPER(";
    private static final String FECHAR_PARENTESE = ")";
    private static final String ABRIR_PARENTESE = "(";
    private static final String VIRGULA = ",";
    private static final String VIRGULA_COM_ESPACO = ", ";
    private static final String ESPACO = " ";
    private static final String EQUALS = " = ";
    private static final String NOT_EQUALS = " <> ";
    private static final String LIKE = " LIKE ";
    private static final String NOT_LIKE = " NOT LIKE ";
    private static final String PONTO = ".";
    private static final String PONTO_REGEX = "\\.";
    private static final String ASTERISCO = "*";
    private static final String SQL_WILDCARD = "%";
    private static final String LOGICAL_AND = "AND";
    private static final String LOGICAL_OR = "OR";
    private static final String REGEX_NUMERICO = "-?\\d+(\\.\\d+)?";

    public static String parseRsqlToNativeSqlWhereClause(String rsqlFilter, Map<String, String> rsqlFieldToSqlNativeField) {
        rsqlFilter = rsqlFilter.trim();
        try {
            Node raiz = RsqlToNativeSqlParserUtils.parseExpressao((String)rsqlFilter);
            String sql = raiz.toSql(rsqlFieldToSqlNativeField);
            if (sql == null || sql.isBlank()) {
                return "";
            }
            return "(" + sql + ")";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private static Node parseExpressao(String expr) throws Exception {
        expr = expr.trim();
        while (expr.startsWith("(") && expr.endsWith(")")) {
            expr = expr.substring(1, expr.length() - 1).trim();
        }
        List andParts = RsqlToNativeSqlParserUtils.splitLogical((String)expr, (String)"AND".toLowerCase());
        if (andParts.size() > 1) {
            LogicalNode andNode = new LogicalNode("AND");
            for (String part : andParts) {
                andNode.filhos.add(RsqlToNativeSqlParserUtils.parseExpressao((String)part));
            }
            return andNode;
        }
        List orParts = RsqlToNativeSqlParserUtils.splitLogical((String)expr, (String)"OR".toLowerCase());
        if (orParts.size() > 1) {
            LogicalNode orNode = new LogicalNode("OR");
            for (String part : orParts) {
                orNode.filhos.add(RsqlToNativeSqlParserUtils.parseExpressao((String)part));
            }
            return orNode;
        }
        return new ClauseNode(expr);
    }

    private static List<String> splitLogical(String expr, String operador) {
        ArrayList<String> partes = new ArrayList<String>();
        int nivelParenteses = 0;
        int ultimoIndice = 0;
        String opLower = operador.toLowerCase();
        String exprLower = expr.toLowerCase();
        for (int i = 0; i < expr.length(); ++i) {
            char c = expr.charAt(i);
            if (c == "(".charAt(0)) {
                ++nivelParenteses;
            } else if (c == ")".charAt(0)) {
                --nivelParenteses;
            }
            if (nivelParenteses != 0 || !exprLower.startsWith(opLower, i)) continue;
            String antes = expr.substring(ultimoIndice, i).trim();
            partes.add(antes);
            ultimoIndice = (i += opLower.length() - 1) + 1;
        }
        String ultimo = expr.substring(ultimoIndice).trim();
        if (!ultimo.isEmpty()) {
            partes.add(ultimo);
        }
        return partes;
    }

    private static String parseClausula(String clausula, Map<String, String> campoParaTabelaColuna) {
        for (OperadorFiltro operador : OperadorFiltro.getOrdenadosPorTamanhoDecrescente()) {
            boolean isLikeWildcard;
            String simbolo = operador.getSimboloFiltro();
            if (!clausula.contains(simbolo)) continue;
            String[] partes = clausula.split(Pattern.quote(simbolo), 2);
            if (partes.length != 2) {
                return null;
            }
            String campoLogico = partes[0].trim();
            String valorBruto = partes[1].trim();
            String tabelaColuna = campoParaTabelaColuna.get(campoLogico);
            if (tabelaColuna == null || !tabelaColuna.contains(".")) {
                return null;
            }
            String[] partesTC = tabelaColuna.split("\\.");
            String tabela = partesTC[0];
            String coluna = partesTC[1];
            String colunaSql = tabela + "." + coluna;
            if (valorBruto.startsWith("\"") && valorBruto.endsWith("\"") && valorBruto.length() > 1) {
                valorBruto = valorBruto.substring(1, valorBruto.length() - 1);
            }
            if (isLikeWildcard = valorBruto.contains("*")) {
                valorBruto = valorBruto.replace("*", "%");
            }
            return RsqlToNativeSqlParserUtils.gerarClausulaSql((OperadorFiltro)operador, (String)colunaSql, (String)valorBruto, (boolean)isLikeWildcard);
        }
        return null;
    }

    private static String gerarClausulaSql(OperadorFiltro operador, String colunaSql, String valorBruto, boolean isLikeWildcard) {
        switch (1.$SwitchMap$br$com$elotech$tributos$enums$OperadorFiltro[operador.ordinal()]) {
            case 1: {
                return RsqlToNativeSqlParserUtils.gerarClausulaIgual((String)colunaSql, (String)valorBruto, (boolean)isLikeWildcard);
            }
            case 2: {
                return RsqlToNativeSqlParserUtils.gerarClausulaDiferente((String)colunaSql, (String)valorBruto, (boolean)isLikeWildcard);
            }
            case 3: {
                return RsqlToNativeSqlParserUtils.gerarClausulaLike((String)colunaSql, (String)valorBruto);
            }
            case 4: 
            case 5: {
                return RsqlToNativeSqlParserUtils.gerarClausulaInOut((String)colunaSql, (String)valorBruto, (OperadorFiltro)operador);
            }
        }
        return RsqlToNativeSqlParserUtils.gerarClausulaDefault((String)colunaSql, (String)valorBruto, (OperadorFiltro)operador);
    }

    private static String gerarClausulaIgual(String colunaSql, String valor, boolean isLike) {
        if (isLike) {
            return "UPPER(" + colunaSql + ") LIKE UPPER(" + RsqlToNativeSqlParserUtils.quoteSql((String)valor) + ")";
        }
        return colunaSql + " = " + RsqlToNativeSqlParserUtils.quoteSql((String)valor);
    }

    private static String gerarClausulaDiferente(String colunaSql, String valor, boolean isLike) {
        if (isLike) {
            return "UPPER(" + colunaSql + ") NOT LIKE UPPER(" + RsqlToNativeSqlParserUtils.quoteSql((String)valor) + ")";
        }
        return colunaSql + " <> " + RsqlToNativeSqlParserUtils.quoteSql((String)valor);
    }

    private static String gerarClausulaLike(String colunaSql, String valor) {
        return "UPPER(" + colunaSql + ") LIKE UPPER(" + RsqlToNativeSqlParserUtils.quoteSql((String)valor) + ")";
    }

    private static String gerarClausulaInOut(String colunaSql, String valorBruto, OperadorFiltro operador) {
        if (valorBruto.startsWith("(") && valorBruto.endsWith(")")) {
            valorBruto = valorBruto.substring(1, valorBruto.length() - 1);
        }
        String[] valores = valorBruto.split(",");
        ArrayList<String> valoresSql = new ArrayList<String>();
        for (String val : valores) {
            valoresSql.add(RsqlToNativeSqlParserUtils.normalizarValorParaSql((String)val));
        }
        return colunaSql + " " + operador.getOperadorSql() + " (" + String.join((CharSequence)", ", valoresSql) + ")";
    }

    private static String gerarClausulaDefault(String colunaSql, String valor, OperadorFiltro operador) {
        return colunaSql + " " + operador.getOperadorSql() + " " + RsqlToNativeSqlParserUtils.quoteSql((String)valor);
    }

    private static String quoteSql(String valor) {
        return "'" + valor.replace("'", "''") + "'";
    }

    private static String normalizarValorParaSql(String valor) {
        if ((valor = valor.trim()).startsWith("\"") && valor.endsWith("\"") && valor.length() > 1) {
            valor = valor.substring(1, valor.length() - 1);
        }
        return RsqlToNativeSqlParserUtils.isNumeric((String)valor) ? valor : RsqlToNativeSqlParserUtils.quoteSql((String)valor);
    }

    private static boolean isNumeric(String str) {
        return str.matches("-?\\d+(\\.\\d+)?");
    }
}

