/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Optional;
import org.springframework.web.multipart.MultipartFile;

public class MultipartFileUtil
implements MultipartFile {
    private final File file;
    private final String contentType;

    public MultipartFileUtil(File file, String contentType) {
        this.file = file;
        this.contentType = contentType;
    }

    public String getName() {
        return this.file.getName();
    }

    public String getOriginalFilename() {
        return this.file.getName();
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isEmpty() {
        return this.file.length() == 0L;
    }

    public long getSize() {
        return this.file.length();
    }

    public byte[] getBytes() throws IOException {
        return Files.readAllBytes(this.file.toPath());
    }

    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public void transferTo(File dest) throws IOException {
        Files.copy(this.file.toPath(), dest.toPath(), new CopyOption[0]);
    }

    public static MultipartFile createMultipartFileByPath(Path path) throws IOException {
        return new MultipartFileUtil(path.toFile(), Optional.ofNullable(Files.probeContentType(path)).orElse("text/plain"));
    }
}

