/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.util;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class ListUtils {
    public static <T> List<T> merge(List<T> currentElements, List<T> newElements, Function<T, Object> getIdentifier, BiConsumer<T, T> merge) {
        return newElements.stream().map(newElement -> {
            Optional<Object> elementToEdit = currentElements.stream().filter(currentElement -> getIdentifier.apply(currentElement).equals(getIdentifier.apply(newElement))).findFirst();
            if (elementToEdit.isPresent()) {
                merge.accept(elementToEdit.get(), newElement);
                return elementToEdit.get();
            }
            return newElement;
        }).collect(Collectors.toList());
    }

    public static <T> List<T> findDuplicateItems(List<T> list) {
        HashSet items = new HashSet();
        return list.stream().filter(n -> !items.add(n)).collect(Collectors.toList());
    }

    public static <T> void forEachWithCounter(Iterable<T> source, BiConsumer<Long, T> consumer) {
        Long i = 0L;
        for (T item : source) {
            consumer.accept(i, (Long)item);
            Long l = i;
            i = i + 1L;
        }
    }
}

