/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.util;

import br.com.elotech.fluent.ReportDatasource;
import br.com.elotech.report.EloReportBuilder;
import br.com.elotech.report.EloReportFactory;
import br.com.elotech.report.file.ReportFileResolverFactory;
import br.com.elotech.tributos.domain.ArquivoJasper;
import br.com.elotech.tributos.enums.TipoArquivoRelatorioEnum;
import br.com.elotech.tributos.util.FileUtils;
import br.com.elotech.tributos.utils.TenantUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Objects;

/*
 * Exception performing whole class analysis ignored.
 */
public class JasperUtils {
    public static String geraCaminhoArquivoJasper(ArquivoJasper arquivoJasper, String defaultPath) throws IOException {
        String baseDir;
        File foundFile;
        if (Objects.nonNull(arquivoJasper)) {
            String fileName = TenantUtils.getIdentificadorTenant().concat("-").concat(arquivoJasper.getNomeArquivo());
            File tempFile = FileUtils.createTempFile((String)fileName, (String)".jrxml", (byte[])arquivoJasper.getArquivo());
            return tempFile.getPath();
        }
        if (defaultPath != null && !defaultPath.isEmpty() && (foundFile = JasperUtils.findFile((File)new File(baseDir = System.getProperty("user.dir")), (String)defaultPath)) != null) {
            return foundFile.getAbsolutePath();
        }
        return defaultPath;
    }

    public static String getDefaultOrCustomJasperFileName(ArquivoJasper arquivoJasper, String defaultPath) throws IOException {
        String path = JasperUtils.geraCaminhoArquivoJasper((ArquivoJasper)arquivoJasper, (String)defaultPath);
        return Objects.nonNull(path) ? path.substring(path.lastIndexOf("/") + 1) : defaultPath;
    }

    public static byte[] builderExportacaoReport(ArquivoJasper arquivoJasper, String fileName, ReportDatasource datasource, TipoArquivoRelatorioEnum tipoArquivoRelatorio, ObjectMapper objectMapper, ReportFileResolverFactory reportFileResolverFactory) throws IOException {
        EloReportBuilder reportFactory = EloReportFactory.jasper().setReportDatasource(datasource).setObjectMapper(objectMapper);
        if (Objects.nonNull(arquivoJasper)) {
            reportFactory.reportFile(new ReportFileResolverFactory("").fromFile(fileName));
        } else {
            reportFactory.reportFile(reportFileResolverFactory.fromFile(fileName));
        }
        byte[] file = TipoArquivoRelatorioEnum.CSV.getValue().equalsIgnoreCase(tipoArquivoRelatorio.getValue()) ? reportFactory.build().exportToCsv() : reportFactory.build().exportToPdf();
        if (Objects.nonNull(arquivoJasper)) {
            Files.deleteIfExists(Paths.get(fileName, new String[0]));
        }
        return file;
    }

    private static File findFile(File directory, String targetFileName) {
        if (!directory.isDirectory()) {
            return null;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return null;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                File found = JasperUtils.findFile((File)file, (String)targetFileName);
                if (found == null) continue;
                return found;
            }
            if (!file.getName().equals(targetFileName)) continue;
            return file;
        }
        return null;
    }
}

