/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.util;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.dto.ProcessamentoArquivoDassendaResutadoDTO;
import br.com.elotech.tributos.enums.CodigoSistemaOrigem;
import br.com.elotech.tributos.enums.IdentificacaoLinhaArquivoDassenda;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileUtilsDassenda {
    private static void validarCodigoTom(String codigoTom) {
        if (StringUtils.isEmpty((String)codigoTom)) {
            throw new EloValidationException("O par\u00e2metro CODIGOTOM deve ser preenchido antes da importa\u00e7\u00e3o");
        }
    }

    public static void createFileDassendaFiltrado(String pathArquivo, String pathArquivoFiltrado, String codigoTom) throws IOException {
        FileUtilsDassenda.validarCodigoTom((String)codigoTom);
        File inputFile = new File(pathArquivo);
        File tempFile = new File(pathArquivoFiltrado + ".tmp");
        ProcessamentoArquivoDassendaResutadoDTO resultado = FileUtilsDassenda.processarArquivoOriginal((File)inputFile, (File)tempFile, (String)codigoTom);
        FileUtilsDassenda.validarTotalRegistros((ProcessamentoArquivoDassendaResutadoDTO)resultado, (File)tempFile, (File)inputFile);
        FileUtilsDassenda.escreverArquivoFinal((String)resultado.getCabecalhoOriginal(), (String)resultado.getRodapeOriginal(), (String)pathArquivoFiltrado, (File)tempFile);
        FileUtilsDassenda.limparArquivosTemporarios((File)tempFile, (File)inputFile);
    }

    private static void validarTotalRegistros(ProcessamentoArquivoDassendaResutadoDTO resultado, File tempFile, File inputFile) {
        if (resultado.getTotalRegistrosFiltrados() == 0) {
            FileUtilsDassenda.limparArquivosTemporarios((File)tempFile, (File)inputFile);
            throw new EloValidationException("Ocorreu um problema com o arquivo, nenhum registro/bloco v\u00e1lido foi encontrado");
        }
    }

    private static ProcessamentoArquivoDassendaResutadoDTO processarArquivoOriginal(File inputFile, File tempFile, String codigoTom) throws IOException {
        ArrayList<String> blocoAtual;
        BufferedWriter tempWriter;
        int totalRegistrosFiltrados = 0;
        String cabecalhoOriginal = null;
        String rodapeOriginal = null;
        try (BufferedReader reader = new BufferedReader(new FileReader(inputFile), 65536);){
            tempWriter = new BufferedWriter(new FileWriter(tempFile), 65536);
            try {
                String linha;
                blocoAtual = new ArrayList<String>(128);
                while ((linha = reader.readLine()) != null) {
                    String trimmed = linha.trim();
                    if (trimmed.isEmpty()) continue;
                    if (FileUtilsDassenda.isCabecalho((String)trimmed)) {
                        cabecalhoOriginal = trimmed;
                        continue;
                    }
                    if (FileUtilsDassenda.isRodapeArquivo((String)trimmed)) {
                        rodapeOriginal = trimmed;
                        continue;
                    }
                    if (FileUtilsDassenda.isInicioBloco((String)trimmed)) {
                        totalRegistrosFiltrados += FileUtilsDassenda.processarBloco(blocoAtual, (String)codigoTom, (BufferedWriter)tempWriter);
                        blocoAtual.clear();
                    }
                    if (!FileUtilsDassenda.isLinhaBloco((String)trimmed)) continue;
                    blocoAtual.add(trimmed);
                }
            }
            finally {
                tempWriter.close();
            }
        }
        return new ProcessamentoArquivoDassendaResutadoDTO(cabecalhoOriginal, rodapeOriginal, totalRegistrosFiltrados += FileUtilsDassenda.processarBloco(blocoAtual, (String)codigoTom, (BufferedWriter)tempWriter));
    }

    private static void escreverArquivoFinal(String cabecalhoOriginal, String rodapeOriginal, String pathArquivoFiltrado, File tempFile) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(pathArquivoFiltrado), 65536);
             BufferedReader tempReader = new BufferedReader(new FileReader(tempFile), 65536);){
            String linhaTemp;
            if (StringUtils.isNotBlank((String)cabecalhoOriginal)) {
                writer.write(cabecalhoOriginal);
                writer.newLine();
            }
            while ((linhaTemp = tempReader.readLine()) != null) {
                writer.write(linhaTemp);
                writer.newLine();
            }
            if (StringUtils.isNotBlank((String)rodapeOriginal)) {
                writer.write(rodapeOriginal);
                writer.newLine();
            }
        }
        catch (FileNotFoundException e) {
            throw new EloValidationException("Arquivo n\u00e3o encontrado. " + e.getMessage());
        }
        catch (IOException e) {
            throw new EloValidationException("Ocorreu um erro ao escrever o novo arquivo. " + e.getMessage());
        }
    }

    private static int processarBloco(List<String> bloco, String codigoTom, BufferedWriter writer) throws IOException {
        if (bloco.isEmpty() || !FileUtilsDassenda.validarBloco(bloco, (String)codigoTom)) {
            return 0;
        }
        for (String linha : bloco) {
            writer.write(linha);
            writer.newLine();
        }
        writer.write(IdentificacaoLinhaArquivoDassenda.ENCERRAMENTO_CALCULO.toValue() + "|" + bloco.size());
        writer.newLine();
        return bloco.size() + 1;
    }

    private static boolean validarBloco(List<String> bloco, String codigoTom) {
        if (bloco.isEmpty()) {
            return false;
        }
        if (!FileUtilsDassenda.linhaCalculoValida((String)bloco.get(0))) {
            return false;
        }
        return FileUtilsDassenda.blocoContemCodigoTom(bloco, (String)codigoTom);
    }

    private static boolean linhaCalculoValida(String linhaCalculo) {
        String[] camposCalculo = linhaCalculo.split("\\|", -1);
        return camposCalculo.length >= 4 && CodigoSistemaOrigem.isValido((String)camposCalculo[3].trim());
    }

    private static boolean blocoContemCodigoTom(List<String> bloco, String codigoTom) {
        for (int i = 1; i < bloco.size(); ++i) {
            String linhaItem = bloco.get(i);
            if (!linhaItem.startsWith(IdentificacaoLinhaArquivoDassenda.ITEM_CALCULO.toValue() + "|") || !FileUtilsDassenda.linhaItemContemCodigoTom((String)linhaItem, (String)codigoTom)) continue;
            return true;
        }
        return false;
    }

    private static boolean linhaItemContemCodigoTom(String linhaItem, String codigoTom) {
        String[] camposItem = linhaItem.split("\\|", -1);
        for (int j = camposItem.length - 1; j >= 0; --j) {
            String campo = camposItem[j].trim();
            if (campo.isEmpty()) continue;
            return codigoTom.equals(campo);
        }
        return false;
    }

    private static boolean isCabecalho(String linha) {
        return linha.startsWith(IdentificacaoLinhaArquivoDassenda.CABECALHO_ARQUIVO.toValue() + "|");
    }

    private static boolean isRodapeArquivo(String linha) {
        return linha.startsWith(IdentificacaoLinhaArquivoDassenda.ENCERRAMENTO_ARQUIVO.toValue() + "|");
    }

    private static boolean isInicioBloco(String linha) {
        return linha.startsWith(IdentificacaoLinhaArquivoDassenda.CALCULO.toValue() + "|");
    }

    private static boolean isLinhaBloco(String linha) {
        return linha.startsWith(IdentificacaoLinhaArquivoDassenda.CALCULO.toValue() + "|") || linha.startsWith(IdentificacaoLinhaArquivoDassenda.ITEM_CALCULO.toValue() + "|");
    }

    private static void limparArquivosTemporarios(File tempFile, File inputFile) {
        tempFile.delete();
        inputFile.delete();
    }
}

