/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ws.rest;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.tributos.config.TributosProperties;
import br.com.elotech.tributos.domain.ParametroGeral;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.util.AmbienteUtils;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Service;

@Service
public class AiseUrlParcelamentoResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(AiseUrlParcelamentoResolver.class);
    private final ParametroGeralService parametroGeralService;
    private final TributosProperties tributosProperties;
    private final ConfigurableEnvironment environment;

    public String buildUrlAiseAndSetHostHeader(HttpHeaders headers) {
        ParametroGeral parametroUrlAiseWsParcelamento = this.parametroGeralService.findByParametroAndModulo(ParametroGeralEnum.URL_AISE_WS_PARCELAMENTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        if (Objects.isNull(parametroUrlAiseWsParcelamento) || StringUtils.isEmpty((CharSequence)parametroUrlAiseWsParcelamento.getValor()) || AmbienteUtils.isLocalEnvironment((ConfigurableEnvironment)this.environment)) {
            LOGGER.debug("Utilizando url padr\u00e3o para o WS aise: {}", (Object)this.tributosProperties.getAise().getWsBaseUrl());
            return this.tributosProperties.getAise().getWsBaseUrl();
        }
        String host = AmbienteUtils.getHost((ConfigurableEnvironment)this.environment);
        headers.set("Host", host);
        LOGGER.debug("Utilizando url customizada para o WS aise: {} (host: {})", (Object)parametroUrlAiseWsParcelamento.getValor(), (Object)host);
        return parametroUrlAiseWsParcelamento.getValor();
    }

    @Generated
    public AiseUrlParcelamentoResolver(ParametroGeralService parametroGeralService, TributosProperties tributosProperties, ConfigurableEnvironment environment) {
        this.parametroGeralService = parametroGeralService;
        this.tributosProperties = tributosProperties;
        this.environment = environment;
    }
}

