/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ws.rest;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.config.HttpEntityFactory;
import br.com.elotech.tributos.config.TributosProperties;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.domain.ParametroGeral;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.parcelamento.FormaCobrancaJurosParcelamento;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamento;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamentoEntrada;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamentoEntradaId;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamentoValorMinimo;
import br.com.elotech.tributos.domain.parcelamento.ParamTabelaPercentualEntrada;
import br.com.elotech.tributos.domain.parcelamento.Parcelamento;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaExecucao;
import br.com.elotech.tributos.dto.BloquetoDTO;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.dto.parcelamento.AiseDebitoParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.AiseParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.BuscarNumeroParcelasImpressaoBoletoDTO;
import br.com.elotech.tributos.dto.parcelamento.ImpressaoBoletoParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.NumeroParcelasImpressaoBoletoDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelaParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoDebitoParcelasDTO;
import br.com.elotech.tributos.dto.parcelamento.ParcelamentoPassivelQuitacaoDTO;
import br.com.elotech.tributos.dto.parcelamento.RequestParcelamentoPassivelQuitacaoDTO;
import br.com.elotech.tributos.dto.parcelamento.RequestSimularQuitarContratoDTO;
import br.com.elotech.tributos.dto.parcelamento.ResumoParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.SimulacaoParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.SimulacaoParcelamentoRequestDTO;
import br.com.elotech.tributos.dto.parcelamento.SimularQuitarContratoDTO;
import br.com.elotech.tributos.dto.parcelamento.ValorEntradaDTO;
import br.com.elotech.tributos.enums.TipoAcaoAtendimento;
import br.com.elotech.tributos.exception.GeracaoParcelamentoException;
import br.com.elotech.tributos.exception.ImpressaoBoletoParcelamentoException;
import br.com.elotech.tributos.exception.SimulacaoParcelamentoException;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.DiaUtilService;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.GeraLivroDividaAtivaService;
import br.com.elotech.tributos.service.HistoricoAtendimentoService;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.service.ParamParcelamentoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.ParcelamentoService;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.ws.AiseParcelamentoService;
import br.com.elotech.tributos.service.ws.rest.AiseLoginServiceRest;
import br.com.elotech.tributos.service.ws.rest.AiseUrlParcelamentoResolver;
import br.com.elotech.tributos.util.CalculoValoresConstants;
import br.com.elotech.tributos.util.DateUtils;
import br.com.elotech.tributos.ws.rest.dto.ParamDebitosPassiveisParcelamentoDTO;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jsonwebtoken.lang.Assert;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.transaction.Transactional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class AiseParcelamentoServiceRest
implements AiseParcelamentoService {
    private static final Integer NUMERO_PADRAO_PARCELAS_IMPRESSAO = 6;
    private static final Integer LIMITE_PARCELAS_IMPRESSAO_BOLETO = 12;
    private static final Logger LOGGER = LoggerFactory.getLogger(AiseParcelamentoServiceRest.class);
    private static final Integer PARCELAMENTO_ATUAL = 1;
    private static final Long PRIMEIRA_PARCELA = 1L;
    private static final Integer QUANTIDADE_PARCELA_PERMITIDA = 1;
    private final RestTemplate restTemplate;
    private final AiseLoginServiceRest aiseLoginServiceRest;
    private final TributosProperties tributosProperties;
    private final ParamParcelamentoService paramParcelamentoService;
    private final ParcelamentoService parcelamentoService;
    private final ParametroGeralService parametroGeralService;
    private final FormaPagamentoService formaPagamentoService;
    private final ContextService contextService;
    private final ConfigurableEnvironment environment;
    private final TarefaAssincronaService tarefaAssincronaService;
    private final NotificacaoService notificacaoService;
    private final ObjectMapper objectMapper;
    private final HistoricoAtendimentoService historicoAtendimentoService;
    private final GeraLivroDividaAtivaService geraLivroDividaAtivaService;
    private final AiseUrlParcelamentoResolver aiseUrlParcelamentoResolver;
    private final DebitoService debitoService;
    private final DiaUtilService diaUtilService;

    public List<AiseDebitoParcelamentoDTO> findDebitosPassiveisParcelamento(ParamDebitosPassiveisParcelamentoDTO param) {
        try {
            HttpHeaders headers = this.aiseLoginServiceRest.getHttpAuthorizationHeaders();
            String url = this.tributosProperties.getAise().getWsBaseUrl().concat("/datasnap/rest/tparcelamentos/DebitosPassiveisParcelamento");
            this.createLogRequestIntegracaoAise(url, (Object)param);
            List debitos = (List)this.restTemplate.exchange(url, HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)param, (HttpHeaders)headers), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]).getBody();
            this.createLogResponseIntegracaoAise(url, (Object)debitos);
            debitos.sort(Comparator.comparing(AiseDebitoParcelamentoDTO::getExercicio).thenComparing(AiseDebitoParcelamentoDTO::getGuiaRecolhimento).thenComparing(AiseDebitoParcelamentoDTO::getSubDivida));
            ParamParcelamento paramParcelamento = (ParamParcelamento)this.paramParcelamentoService.findOne((Serializable)Long.valueOf(param.getIdParametroParcelamento().intValue()));
            Boolean concedeDescontoNoPagamento = paramParcelamento.getDescontosPorParcela().stream().anyMatch(desconto -> Boolean.TRUE.equals(desconto.getConcedeDescontoNoPagamento()));
            List idDebitos = debitos.stream().map(AiseDebitoParcelamentoDTO::getIdDebito).distinct().collect(Collectors.toList());
            Long quantidadeMaximaParcelamento = Optional.ofNullable(paramParcelamento.getQuantidadeMaximaParcelamento()).orElse(0L);
            Map<Long, Boolean> estornoAtivoMap = idDebitos.stream().collect(Collectors.toMap(idDebito -> idDebito, idDebito -> this.parcelamentoService.findByEstornoAtivoByDebitoDestinoId(idDebito).isPresent()));
            debitos.forEach(debito -> {
                debito.agruparValores();
                debito.setConcedeDescontoNoPagamento(concedeDescontoNoPagamento);
                debito.setOriundoEstornoContrato(estornoAtivoMap.getOrDefault(debito.getIdDebito(), false));
                Long quantidadeParcelamento = this.findQuantidadeParcelamentoByIdDebito(debito, quantidadeMaximaParcelamento);
                debito.setUltrapassaQuantidadeParcelamento(this.getDebitoUltrapassaQuantidadeParcelamento(quantidadeParcelamento, quantidadeMaximaParcelamento));
                debito.setQuantidadeParcelamento(quantidadeParcelamento);
            });
            return debitos;
        }
        catch (RestClientException e) {
            throw new EloValidationException(e.getMessage());
        }
    }

    private Long findQuantidadeParcelamentoByIdDebito(AiseDebitoParcelamentoDTO debito, Long quantidadeMaximaParcelamento) {
        return this.debitoService.findQuantidadeParcelamentoByIdDebito(debito.getIdDebito(), quantidadeMaximaParcelamento);
    }

    private Boolean getDebitoUltrapassaQuantidadeParcelamento(Long quantidadeParcelamento, Long quantidadeMaximaParcelamento) {
        if (quantidadeMaximaParcelamento <= 0L) {
            return Boolean.FALSE;
        }
        return quantidadeParcelamento >= quantidadeMaximaParcelamento;
    }

    public SimulacaoParcelamentoDTO simularParcelamento(SimulacaoParcelamentoDTO simulacaoParcelamentoDTO) {
        this.validaParcelamento(simulacaoParcelamentoDTO);
        return this.internalSimularParcelamento(simulacaoParcelamentoDTO);
    }

    private void atualizarReferenciaDebitoParcela(AiseParcelamentoDTO parcelamentoDTO) {
        parcelamentoDTO.getDebitos().forEach(debito -> debito.getParcelaReceita().forEach(parcela -> parcela.setIdDebito(debito.getIdDebito())));
    }

    private SimulacaoParcelamentoDTO internalSimularParcelamento(SimulacaoParcelamentoDTO simulacaoParcelamentoDTO) {
        try {
            HttpHeaders headers = this.aiseLoginServiceRest.getHttpAuthorizationHeaders();
            String urlWsAise = this.aiseUrlParcelamentoResolver.buildUrlAiseAndSetHostHeader(headers);
            String url = urlWsAise.concat("/datasnap/rest/tparcelamentos/simularparcelamento");
            LOGGER.debug("URL WS aise simula\u00e7\u00e3o parcelamento: {}", (Object)url);
            this.createLogRequestIntegracaoAise(url, (Object)simulacaoParcelamentoDTO);
            AiseParcelamentoDTO parcelamentoDTO = (AiseParcelamentoDTO)this.restTemplate.exchange(url, HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)simulacaoParcelamentoDTO, (HttpHeaders)headers), AiseParcelamentoDTO.class, new Object[0]).getBody();
            this.createLogResponseIntegracaoAise(url, (Object)parcelamentoDTO);
            this.atualizarReferenciaDebitoParcela(parcelamentoDTO);
            Boolean concedeDescontoNoPagamento = ((ParamParcelamento)this.paramParcelamentoService.findOne((Serializable)simulacaoParcelamentoDTO.getIdParametroParcelamento())).getDescontosPorParcela().stream().anyMatch(desconto -> Boolean.TRUE.equals(desconto.getConcedeDescontoNoPagamento()));
            parcelamentoDTO.getDebitos().forEach(debito -> {
                debito.agruparValores();
                debito.setConcedeDescontoNoPagamento(concedeDescontoNoPagamento);
            });
            return SimulacaoParcelamentoDTO.from((AiseParcelamentoDTO)parcelamentoDTO, (SimulacaoParcelamentoDTO)simulacaoParcelamentoDTO);
        }
        catch (RestClientException e) {
            throw new EloValidationException(e.getMessage());
        }
    }

    public ResumoParcelamentoDTO gerarParcelamento(SimulacaoParcelamentoDTO simulacaoParcelamentoDTO, UserSecurityDTO userSecurityDTO) throws JsonProcessingException {
        ParamParcelamento paramParcelamento;
        if (!simulacaoParcelamentoDTO.verificaIntegridadeSimulacao()) {
            throw new GeracaoParcelamentoException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel gravar o parcelamento, fa\u00e7a novamente a simula\u00e7\u00e3o!");
        }
        this.validaValorMinimoParametrizadoParaParcelamento(simulacaoParcelamentoDTO);
        if (this.environment.acceptsProfiles(new String[]{"onpremise"})) {
            simulacaoParcelamentoDTO.setExecutaMovimentacao(true);
        }
        if (Objects.nonNull((paramParcelamento = (ParamParcelamento)this.paramParcelamentoService.findOne((Serializable)simulacaoParcelamentoDTO.getIdParametroParcelamento())).getInscreveDebitosDa()) && paramParcelamento.getInscreveDebitosDa().equals(Boolean.TRUE) && simulacaoParcelamentoDTO.getPossuiDebitosEmExercicioEDa().equals(Boolean.TRUE)) {
            this.geraLivroDividaAtivaService.inscreveDebitosDeParcelamentoEmDa(simulacaoParcelamentoDTO);
        }
        try {
            HttpHeaders headers = this.aiseLoginServiceRest.getHttpAuthorizationHeaders();
            headers.set("usuario-aise", userSecurityDTO.getPreferredUsername());
            String urlWsAise = this.aiseUrlParcelamentoResolver.buildUrlAiseAndSetHostHeader(headers);
            String url = String.format("%s/datasnap/rest/tparcelamentos/gerarparcelamento", urlWsAise);
            LOGGER.debug("URL WS aise parcelamento: {}", (Object)url);
            this.createLogRequestIntegracaoAise(url, (Object)simulacaoParcelamentoDTO);
            AiseParcelamentoDTO parcelamentoDTO = (AiseParcelamentoDTO)this.restTemplate.exchange(url, HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)simulacaoParcelamentoDTO, (HttpHeaders)headers), AiseParcelamentoDTO.class, new Object[0]).getBody();
            this.createLogResponseIntegracaoAise(url, (Object)parcelamentoDTO);
            this.saveArquivoContratoParcelamento(simulacaoParcelamentoDTO, parcelamentoDTO);
            this.saveProcesso(simulacaoParcelamentoDTO, parcelamentoDTO);
            this.atualizarReferenciaDebitoParcela(parcelamentoDTO);
            this.historicoAtendimentoService.createHistoricoAtendimento(String.format("Gerado parcelamento %s/%s", parcelamentoDTO.getNumeroContrato(), parcelamentoDTO.getAnoContrato()), TipoAcaoAtendimento.GERACAO_PARCELAMENTO, simulacaoParcelamentoDTO.getHeaderAtendimento());
            return ResumoParcelamentoDTO.from((AiseParcelamentoDTO)parcelamentoDTO);
        }
        catch (RestClientException e) {
            throw new EloValidationException(e.getMessage());
        }
    }

    @Async
    @Transactional
    public void createGeracaoParcelamentoAssincrono(SimulacaoParcelamentoDTO param, UserSecurityDTO userSecurityDTO) {
        LOGGER.debug("Cria\u00e7\u00e3o da tarefa GERACAO_PARCELAMENTO_ASSINCROCNO para o parcelamento tipo cadastro:{}, cadastro geral:{}, data Contrato: {}]", new Object[]{param.getTipoCadastro(), param.getCadastroGeral(), param.getDataParcelamento()});
        TarefaAssincronaExecucao execucao = this.tarefaAssincronaService.createTarefaAssincronaGeracaoParcelamento(SimulacaoParcelamentoDTO.getChaveParcelamentoAssincrono((SimulacaoParcelamentoDTO)param));
        Long tarefa = execucao.getTarefaAssincrona().getId();
        Optional notificacaoId = this.notificacaoService.send("Gera\u00e7\u00e3o Parcelamento Ass\u00edncrono", String.format("Iniciando a gera\u00e7\u00e3o do parcelamento %s", tarefa), execucao.getTarefaAssincrona(), Optional.empty(), userSecurityDTO, NotificationStatus.STARTED);
        this.generateParcelamentoAssincrono(param, userSecurityDTO, execucao, tarefa, notificacaoId);
    }

    private void generateParcelamentoAssincrono(SimulacaoParcelamentoDTO param, UserSecurityDTO userSecurityDTO, TarefaAssincronaExecucao execucao, Long tarefa, Optional<UUID> notificacaoId) {
        try {
            LOGGER.debug("Iniciando Gera\u00e7\u00e3o do parcelamento [tipo cadastro:{}, cadastro geral:{}, data Contrato: {}]", new Object[]{param.getTipoCadastro(), param.getCadastroGeral(), param.getDataParcelamento()});
            ResumoParcelamentoDTO resumoParcelamentoDTO = this.gerarParcelamento(param, userSecurityDTO);
            LOGGER.debug("Finalizada com sucesso a Gera\u00e7\u00e3o do parcelamento da tarefa {}", (Object)tarefa);
            this.tarefaAssincronaService.finalizarExecucao(execucao);
            this.notificacaoService.send("Gera\u00e7\u00e3o Parcelamento Ass\u00edncrono", String.format("Finalizada com sucesso a Gera\u00e7\u00e3o do parcelamento da tarefa %s.", tarefa), execucao.getTarefaAssincrona(), notificacaoId, userSecurityDTO, NotificationStatus.COMPLETED);
            this.generateImpressaoCarne(resumoParcelamentoDTO);
        }
        catch (Exception exception) {
            LOGGER.error("Ocorreu um erro na Gera\u00e7\u00e3o do parcelamento da tarefa {}", (Object)tarefa);
            this.tarefaAssincronaService.marcarExecucaoComErro(execucao, exception.getMessage());
            this.notificacaoService.send("Gera\u00e7\u00e3o Parcelamento Ass\u00edncrono", String.format("Ocorreu um erro na Gera\u00e7\u00e3o do parcelamento da tarefa %s", tarefa), execucao.getTarefaAssincrona(), notificacaoId, userSecurityDTO, NotificationStatus.FAILED);
        }
    }

    private void generateImpressaoCarne(ResumoParcelamentoDTO resumoParcelamentoDTO) {
        if (Objects.nonNull(resumoParcelamentoDTO.getIdParcelamento()) && Boolean.TRUE.equals(this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.GERACAO_CARNEPARCELAMENTO_OXY)) && Boolean.TRUE.equals(this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.GERA_CARNE_PARCELAMENTO_AUTO)) && resumoParcelamentoDTO.getNumeroParcela() > 15) {
            LOGGER.debug("Iniciado gera\u00e7\u00e3o do carne de parcelamento com idparcelamento {}", (Object)resumoParcelamentoDTO.getIdParcelamento());
            this.parcelamentoService.gerarOuImprimirBoleto(resumoParcelamentoDTO.getIdParcelamento(), true);
        }
    }

    private void saveArquivoContratoParcelamento(SimulacaoParcelamentoDTO simulacaoParcelamentoDTO, AiseParcelamentoDTO parcelamentoDTO) {
        if (Objects.nonNull(simulacaoParcelamentoDTO.getTenant()) && Objects.nonNull(parcelamentoDTO)) {
            Parcelamento parcelamento = (Parcelamento)this.parcelamentoService.findOne((Serializable)parcelamentoDTO.getIdParcelamento());
            this.parcelamentoService.uploadContratoParcelamento(simulacaoParcelamentoDTO.getTenant(), parcelamento);
        }
    }

    private void saveProcesso(SimulacaoParcelamentoDTO simulacao, AiseParcelamentoDTO aiseParcelamento) {
        if (Objects.nonNull(aiseParcelamento) && (Objects.nonNull(simulacao.getNumeroProcesso()) || Objects.nonNull(simulacao.getAnoProcesso())) || Objects.nonNull(simulacao.getProcessoSei())) {
            Parcelamento parcelamento = (Parcelamento)this.parcelamentoService.findOne((Serializable)aiseParcelamento.getIdParcelamento());
            parcelamento.setNumeroProcesso(simulacao.getNumeroProcesso());
            parcelamento.setAnoProcesso(simulacao.getAnoProcesso());
            parcelamento.setProcessoSei(simulacao.getProcessoSei());
            this.parcelamentoService.save((EloEntity)parcelamento, null);
        }
    }

    private void validaParcelamento(SimulacaoParcelamentoDTO simulacaoParcelamentoDTO) {
        ParamParcelamento parametro = (ParamParcelamento)this.paramParcelamentoService.findOne((Serializable)simulacaoParcelamentoDTO.getIdParametroParcelamento());
        this.validaParcelamento(simulacaoParcelamentoDTO, parametro);
    }

    public void validaParcelamento(SimulacaoParcelamentoDTO simulacaoParcelamentoDTO, ParamParcelamento parametro) {
        if (simulacaoParcelamentoDTO.getDataEntrada().isBefore(simulacaoParcelamentoDTO.getDataParcelamento())) {
            throw new SimulacaoParcelamentoException(HttpStatus.BAD_REQUEST, "A data de entrada deve ser maior ou igual a data do parcelamento.");
        }
        this.validaValorMinimoParametrizadoParaParcelamento(simulacaoParcelamentoDTO, parametro);
        this.validaEntradaParcelamento(simulacaoParcelamentoDTO, parametro);
        this.validaParcelasParcelamento(simulacaoParcelamentoDTO, parametro);
    }

    private void validaEntradaParcelamento(SimulacaoParcelamentoDTO simulacaoParcelamentoDTO, ParamParcelamento parametro) {
        ValorEntradaDTO valorEntradaDTO;
        BigDecimal entradaMinimaCalculada;
        if (simulacaoParcelamentoDTO.getValorEntrada().compareTo(simulacaoParcelamentoDTO.getTotalSelecionado()) > 0) {
            throw new SimulacaoParcelamentoException(HttpStatus.BAD_REQUEST, String.format("Valor de entrada %.2f maior que o total selecionado %.2f.", simulacaoParcelamentoDTO.getValorEntrada(), simulacaoParcelamentoDTO.getTotalSelecionado()));
        }
        Optional<ParamParcelamentoEntrada> entrada = parametro.getEntradas().stream().filter(e -> simulacaoParcelamentoDTO.getEntrada().equals(e.getId().getEntrada())).findFirst();
        BigDecimal percentualEntrada = entrada.map(ParamParcelamentoEntrada::getPercentualEntrada).orElseThrow(() -> new SimulacaoParcelamentoException(HttpStatus.BAD_REQUEST, "Entrada n\u00e3o encontrada para o par\u00e2metro de parcelamento."));
        if (Boolean.TRUE.equals(entrada.get().getUtilizaTabelaPercentualEntrada()) && parametro.getQuantidadeMaximaParcelamento() > 0L) {
            Integer quantidadeParcelamentoToVerify = this.getMaxQuantidadeParcelamentoSimulacao(simulacaoParcelamentoDTO, parametro.getQuantidadeMaximaParcelamento()) + PARCELAMENTO_ATUAL;
            percentualEntrada = this.getPercentualEntrada(entrada.get().getPercentuaisEntrada(), quantidadeParcelamentoToVerify);
        }
        if ((entradaMinimaCalculada = simulacaoParcelamentoDTO.getTotalSelecionado().multiply(Optional.ofNullable(percentualEntrada).orElse(BigDecimal.ZERO)).divide(BigDecimal.valueOf(100L)).setScale((int)CalculoValoresConstants.QUANTIDADE_CASAS_DECIMAIS, 6)).compareTo(BigDecimal.ZERO) > 0 && simulacaoParcelamentoDTO.getValorEntrada().compareTo(BigDecimal.ZERO) == 0) {
            simulacaoParcelamentoDTO.setValorEntrada(entradaMinimaCalculada);
        }
        if (Objects.nonNull(valorEntradaDTO = Optional.ofNullable(this.buscarValorEntrada(simulacaoParcelamentoDTO)).orElseThrow(() -> new SimulacaoParcelamentoException(HttpStatus.INTERNAL_SERVER_ERROR, "N\u00e3o foi poss\u00edvel calcular o valor de entrada do parcelamento.")))) {
            if ((long)simulacaoParcelamentoDTO.getNumeroParcelas().intValue() > valorEntradaDTO.getNumeroParcela()) {
                throw new SimulacaoParcelamentoException(HttpStatus.BAD_REQUEST, String.format("O n\u00famero de parcelas deve ser alterado para %d afim de adequar o valor m\u00ednimo da parcela.", valorEntradaDTO.getNumeroParcela()));
            }
            Boolean digitouValorEntrada = simulacaoParcelamentoDTO.getValorEntrada().compareTo(entradaMinimaCalculada) != 0;
            simulacaoParcelamentoDTO.ajustarValorEntrada(digitouValorEntrada, parametro, valorEntradaDTO.getValorEntrada());
        }
        if (simulacaoParcelamentoDTO.getValorEntrada().compareTo(entradaMinimaCalculada) < 0) {
            throw new SimulacaoParcelamentoException(HttpStatus.BAD_REQUEST, String.format("O valor da entrada deve ser no m\u00ednimo %.2f.", entradaMinimaCalculada));
        }
    }

    public Integer getMaxQuantidadeParcelamentoSimulacao(SimulacaoParcelamentoDTO simulacao, Long quantidadeMaximaParcelamento) {
        return simulacao.getDebitos().stream().map(debito -> this.debitoService.findQuantidadeParcelamentoByIdDebito(debito, quantidadeMaximaParcelamento)).filter(Objects::nonNull).max(Long::compareTo).orElse(0L).intValue();
    }

    public BigDecimal getPercentualEntrada(List<ParamTabelaPercentualEntrada> percentuaisEntrada, Integer quantidadeParcelamento) {
        return percentuaisEntrada.stream().filter(p -> p.getQuantidadeParcelamentosAnteriores().equals(quantidadeParcelamento.longValue())).map(ParamTabelaPercentualEntrada::getPercentual).filter(Objects::nonNull).map(BigDecimal::valueOf).findFirst().orElse(BigDecimal.ZERO);
    }

    private void validaParcelasParcelamento(SimulacaoParcelamentoDTO simulacaoParcelamentoDTO, ParamParcelamento parametro) {
        Long numeroParcela = Optional.ofNullable(parametro.getNumeroParcela()).orElse(0L);
        if ((long)simulacaoParcelamentoDTO.getNumeroParcelas().intValue() > numeroParcela && !simulacaoParcelamentoDTO.hasProcessoPrazo().booleanValue()) {
            throw new SimulacaoParcelamentoException(HttpStatus.BAD_REQUEST, String.format("N\u00famero de parcelas informado %d \u00e9 superior ao m\u00e1ximo permitido %d.", simulacaoParcelamentoDTO.getNumeroParcelas(), numeroParcela));
        }
        Long numeroParcelaRequerimento = Optional.ofNullable(parametro.getNumeroParcelaRequerimento()).orElse(0L);
        if ((long)simulacaoParcelamentoDTO.getNumeroParcelas().intValue() > numeroParcelaRequerimento && simulacaoParcelamentoDTO.hasProcessoPrazo().booleanValue()) {
            throw new SimulacaoParcelamentoException(HttpStatus.BAD_REQUEST, String.format("N\u00famero de parcelas informado %d \u00e9 superior ao m\u00e1ximo permitido %d.", simulacaoParcelamentoDTO.getNumeroParcelas(), numeroParcelaRequerimento));
        }
    }

    public ValorEntradaDTO buscarValorEntrada(SimulacaoParcelamentoDTO simulacaoParcelamentoDTO) {
        try {
            HttpHeaders headers = this.aiseLoginServiceRest.getHttpAuthorizationHeaders();
            String url = this.tributosProperties.getAise().getWsBaseUrl().concat("/datasnap/rest/tparcelamentos/buscarvalorentrada");
            this.createLogRequestIntegracaoAise(url, (Object)simulacaoParcelamentoDTO);
            return (ValorEntradaDTO)this.restTemplate.exchange(url, HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)simulacaoParcelamentoDTO, (HttpHeaders)headers), ValorEntradaDTO.class, new Object[0]).getBody();
        }
        catch (RestClientException e) {
            throw new EloValidationException(e.getMessage());
        }
    }

    public List<ParcelamentoPassivelQuitacaoDTO> findParcelamentosCompativeis(Long idParcelamento) {
        Parcelamento parcelamento = (Parcelamento)this.parcelamentoService.findOne((Serializable)idParcelamento);
        RequestParcelamentoPassivelQuitacaoDTO request = new RequestParcelamentoPassivelQuitacaoDTO();
        Optional.ofNullable(parcelamento.getCadastroGeral()).ifPresent(cadastroGeral -> {
            request.setTipoCadastro(Optional.ofNullable(cadastroGeral.getTipoCadastro()).map(tipo -> Optional.ofNullable(tipo.getValue()).map(val -> val.intValue()).orElse(0)).orElse(0));
            request.setCadastroGeral(Optional.ofNullable(cadastroGeral.getCadastroGeral()).map(cadastro -> cadastro.intValue()).orElse(0));
        });
        request.setTipoParcelamento(parcelamento.getTipo().getCodigo());
        request.setDataParcelamento(parcelamento.getDataParcelamento());
        request.setIdParcelamento(Integer.valueOf(idParcelamento.intValue()));
        Optional.ofNullable(parcelamento.getPessoa()).ifPresent(pessoa -> request.setContribuinte(Optional.ofNullable(pessoa.getId()).map(pessoaId -> pessoaId.intValue()).orElse(0)));
        request.setPorContribuinte(parcelamento.getPorContribuinte());
        try {
            HttpHeaders headers = this.aiseLoginServiceRest.getHttpAuthorizationHeaders();
            String url = this.tributosProperties.getAise().getWsBaseUrl().concat("/datasnap/rest/tparcelamentos/ParcelamentosPassiveisQuitacao");
            this.createLogRequestIntegracaoAise(url, (Object)request);
            return (List)this.restTemplate.exchange(url, HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)request, (HttpHeaders)headers), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]).getBody();
        }
        catch (RestClientException e) {
            throw new EloValidationException(e.getMessage());
        }
    }

    public SimularQuitarContratoDTO simularQuitarContrato(RequestSimularQuitarContratoDTO request) {
        try {
            HttpHeaders headers = this.aiseLoginServiceRest.getHttpAuthorizationHeaders();
            FormaPagamento formaPagamento = this.formaPagamentoService.getFormaPagamentoRestante().orElseGet(() -> this.formaPagamentoService.findFormaPagamentoPadrao(Optional.of(this.contextService.getExercicioAtual())));
            request.setFormaPagamento((Long)Optional.ofNullable(formaPagamento).map(FormaPagamento::getId).orElse(null));
            String url = this.tributosProperties.getAise().getWsBaseUrl().concat("/datasnap/rest/tparcelamentos/SimularQuitarContrato");
            this.createLogRequestIntegracaoAise(url, (Object)request);
            return (SimularQuitarContratoDTO)this.restTemplate.exchange(url, HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)request, (HttpHeaders)headers), SimularQuitarContratoDTO.class, new Object[0]).getBody();
        }
        catch (RestClientException e) {
            throw new EloValidationException(e.getMessage());
        }
    }

    public byte[] imprimirSimulacaoQuitarContrato(SimularQuitarContratoDTO request) {
        try {
            HttpHeaders headers = this.aiseLoginServiceRest.getHttpAuthorizationHeaders();
            String url = this.tributosProperties.getAise().getWsBaseUrl().concat("/datasnap/rest/tparcelamentos/ImprimirSimulacaoQuitarContrato");
            this.createLogRequestIntegracaoAise(url, (Object)request);
            return (byte[])this.restTemplate.exchange(url, HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)request, (HttpHeaders)headers), byte[].class, new Object[0]).getBody();
        }
        catch (RestClientException e) {
            throw new EloValidationException(e.getMessage());
        }
    }

    public BloquetoDTO quitarContrato(RequestSimularQuitarContratoDTO request) {
        FormaPagamento formaPagamento = this.formaPagamentoService.getFormaPagamentoRestante().orElseGet(() -> this.formaPagamentoService.findFormaPagamentoPadrao(Optional.of(this.contextService.getExercicioAtual())));
        request.setFormaPagamento((Long)Optional.ofNullable(formaPagamento).map(FormaPagamento::getId).orElse(null));
        try {
            HttpHeaders headers = this.aiseLoginServiceRest.getHttpAuthorizationHeaders();
            String url = this.tributosProperties.getAise().getWsBaseUrl().concat("/datasnap/rest/tparcelamentos/QuitarContrato");
            this.createLogRequestIntegracaoAise(url, (Object)request);
            return (BloquetoDTO)this.restTemplate.exchange(url, HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)request, (HttpHeaders)headers), BloquetoDTO.class, new Object[0]).getBody();
        }
        catch (RestClientException e) {
            throw new EloValidationException(e.getMessage());
        }
    }

    public byte[] imprimirBoleto(ImpressaoBoletoParcelamentoDTO request) {
        ParcelamentoPassivelQuitacaoDTO parcelamentoDTO = (ParcelamentoPassivelQuitacaoDTO)request.getParcelamentos().stream().findFirst().orElseThrow(() -> new ImpressaoBoletoParcelamentoException(HttpStatus.BAD_REQUEST, "N\u00e3o foi informado parcelamento."));
        request.setTipoCadastro(parcelamentoDTO.getTipoCadastro());
        request.setCadastroGeral(parcelamentoDTO.getCadastroGeral());
        request.setDataParcelamento(parcelamentoDTO.getDataContrato());
        request.setPorContribuinte(parcelamentoDTO.getPorContribuinte());
        this.validaImpressaoBoletoParcelamento(request);
        return this.imprimirBoletoAise(request);
    }

    private byte[] imprimirBoletoAise(ImpressaoBoletoParcelamentoDTO request) {
        try {
            HttpHeaders headers = this.aiseLoginServiceRest.getHttpAuthorizationHeaders();
            String url = this.tributosProperties.getAise().getWsBaseUrl().concat("/datasnap/rest/tparcelamentos/ImprimirBoleto");
            this.createLogRequestIntegracaoAise(url, (Object)request);
            return (byte[])this.restTemplate.exchange(url, HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)request, (HttpHeaders)headers), byte[].class, new Object[0]).getBody();
        }
        catch (RestClientException e) {
            throw new EloValidationException(e.getMessage());
        }
    }

    private void validaImpressaoBoletoParcelamento(ImpressaoBoletoParcelamentoDTO request) {
        this.validaFormaCobrancaJurosParcelamento(request);
        this.validaParcelasImpressaoBoleto(request);
    }

    private void validaFormaCobrancaJurosParcelamento(ImpressaoBoletoParcelamentoDTO request) {
        ArrayList parcelamentosTaxaIndividualPorParcela = new ArrayList();
        request.getParcelamentos().forEach(parcelamento -> {
            ParamParcelamento parametro = (ParamParcelamento)this.paramParcelamentoService.findOne((Serializable)parcelamento.getIdParametroParcelamento());
            if (parametro.getTipoJurosFinanciamento().equals((Object)FormaCobrancaJurosParcelamento.TAXA_INDIVIDUAL_POR_PARCELA)) {
                parcelamentosTaxaIndividualPorParcela.add(parcelamento);
            }
        });
        if (!parcelamentosTaxaIndividualPorParcela.isEmpty() && request.getParcelamentos().size() > parcelamentosTaxaIndividualPorParcela.size()) {
            String constratosTaxaIndividual = parcelamentosTaxaIndividualPorParcela.stream().map(elemento -> String.format("%d/%d", elemento.getNumeroContrato(), elemento.getAnoContrato())).reduce((accum, elemento) -> accum + ", " + String.format("%s", elemento)).orElse("");
            throw new ImpressaoBoletoParcelamentoException(HttpStatus.BAD_REQUEST, String.format("Contratos configurados com o Tipo de Juros de Financiamento  'Taxa Individual por Parcela' n\u00e3o podem ser quitados juntamente  com outros contratos que n\u00e3o possuem essa configura\u00e7\u00e3o.  Contratos que est\u00e3o configurados com Taxa Individual por Parcela: %s.", constratosTaxaIndividual));
        }
    }

    private void validaParcelasImpressaoBoleto(ImpressaoBoletoParcelamentoDTO request) {
        ParametroGeral parametroImpressaoParcelamento;
        String pattern = "dd/MM/yyyy";
        DateTimeFormatter simpleDateFormat = DateTimeFormatter.ofPattern(pattern);
        if (request.getVencimentoInicial().isBefore(LocalDate.now())) {
            throw new ImpressaoBoletoParcelamentoException(HttpStatus.BAD_REQUEST, String.format("O vencimento inicial informado %s \u00e9 inferior a data atual %s.", simpleDateFormat.format(request.getVencimentoInicial()), simpleDateFormat.format(LocalDate.now())));
        }
        BuscarNumeroParcelasImpressaoBoletoDTO buscarNumeroParcelasDTO = new BuscarNumeroParcelasImpressaoBoletoDTO();
        buscarNumeroParcelasDTO.setTipoCadastro(request.getTipoCadastro());
        buscarNumeroParcelasDTO.setCadastroGeral(request.getCadastroGeral());
        buscarNumeroParcelasDTO.setDataParcelamento(request.getDataParcelamento());
        buscarNumeroParcelasDTO.getParcelamentos().addAll(request.getParcelamentos());
        NumeroParcelasImpressaoBoletoDTO numeroParcelas = this.buscarNumeroParcelasImpressaoBoleto(buscarNumeroParcelasDTO);
        if (Objects.nonNull(numeroParcelas)) {
            if (numeroParcelas.getQuantidadeParcelaAberta() == 0) {
                throw new ImpressaoBoletoParcelamentoException(HttpStatus.BAD_REQUEST, "N\u00e3o existem parcelas abertas para o(s) contrato(s).");
            }
            if (request.getQuantidadeParcelas() > numeroParcelas.getQuantidadeParcelaAberta()) {
                throw new ImpressaoBoletoParcelamentoException(HttpStatus.BAD_REQUEST, String.format("Quantidade de parcelas %d maior que a quantidade de parcelas em aberto %d.", request.getQuantidadeParcelas(), numeroParcelas.getQuantidadeParcelaAberta()));
            }
            if (numeroParcelas.getDataVencimentoInicio().isBefore(LocalDate.now())) {
                throw new ImpressaoBoletoParcelamentoException(HttpStatus.BAD_REQUEST, "As parcelas para o(s) contrato(s) j\u00e1 est\u00e3o vencidas. Utilize a central de atendimento.");
            }
        }
        if (Objects.nonNull(parametroImpressaoParcelamento = this.parametroGeralService.findByParametroAndModulo(ParametroGeralEnum.VALIDACAO_EMISSAO_BLOQUETO_REPARC, ModuloEnum.MODULO_TRIBUTARIO.getValue())) && parametroImpressaoParcelamento.getValor().equals("S")) {
            if (request.getQuantidadeParcelas() > LIMITE_PARCELAS_IMPRESSAO_BOLETO) {
                throw new ImpressaoBoletoParcelamentoException(HttpStatus.BAD_REQUEST, String.format("Quantidade de parcelas %d maior que a quantidade m\u00e1xima permitida %d.", request.getQuantidadeParcelas(), LIMITE_PARCELAS_IMPRESSAO_BOLETO));
            }
            if (Objects.nonNull(numeroParcelas) && request.getVencimentoFinal().isAfter(numeroParcelas.getDataLimiteVencimento())) {
                throw new ImpressaoBoletoParcelamentoException(HttpStatus.BAD_REQUEST, String.format("O vencimento final informado %s excede o limite de vencimento %s antes da atualiza\u00e7\u00e3o monet\u00e1ria do d\u00e9bito.", simpleDateFormat.format(request.getVencimentoFinal()), simpleDateFormat.format(numeroParcelas.getDataLimiteVencimento())));
            }
        }
    }

    public NumeroParcelasImpressaoBoletoDTO buscarNumeroParcelasImpressaoBoleto(BuscarNumeroParcelasImpressaoBoletoDTO request) {
        HttpHeaders headers = this.aiseLoginServiceRest.getHttpAuthorizationHeaders();
        ParcelamentoPassivelQuitacaoDTO parcelamentoDTO = (ParcelamentoPassivelQuitacaoDTO)request.getParcelamentos().stream().findFirst().orElseThrow(() -> new ImpressaoBoletoParcelamentoException(HttpStatus.BAD_REQUEST, "N\u00e3o foi informado parcelamento."));
        Parcelamento parcelamento = (Parcelamento)this.parcelamentoService.findOne((Serializable)parcelamentoDTO.getIdParcelamento());
        Optional.ofNullable(parcelamento.getCadastroGeral()).ifPresent(cadastroGeral -> {
            request.setTipoCadastro(Long.valueOf(Optional.ofNullable(cadastroGeral.getTipoCadastro()).map(tipo -> Optional.ofNullable(tipo.getValue()).map(val -> val.intValue()).orElse(0)).orElse(0).intValue()));
            request.setCadastroGeral(Long.valueOf(Optional.ofNullable(cadastroGeral.getCadastroGeral()).map(cadastro -> cadastro.intValue()).orElse(0).intValue()));
        });
        request.setDataParcelamento(parcelamento.getDataParcelamento());
        request.setTipo(parcelamento.getTipo().getValue());
        Optional.ofNullable(parcelamento.getPessoa()).ifPresent(pessoa -> request.setContribuinte(Long.valueOf(Optional.ofNullable(pessoa.getId()).map(pessoaId -> pessoaId.intValue()).orElse(0).intValue())));
        request.setPorContribuinte(parcelamento.getPorContribuinte());
        try {
            String url = this.tributosProperties.getAise().getWsBaseUrl().concat("/datasnap/rest/tparcelamentos/BuscarNumeroParcelaImpressao");
            this.createLogRequestIntegracaoAise(url, (Object)request);
            NumeroParcelasImpressaoBoletoDTO numeroParcelasImpressaoBoletoDTO = (NumeroParcelasImpressaoBoletoDTO)this.restTemplate.exchange(url, HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)request, (HttpHeaders)headers), NumeroParcelasImpressaoBoletoDTO.class, new Object[0]).getBody();
            this.createLogResponseIntegracaoAise(url, (Object)numeroParcelasImpressaoBoletoDTO);
            numeroParcelasImpressaoBoletoDTO.setDataVencimentoFim(numeroParcelasImpressaoBoletoDTO.getDataLimiteVencimento());
            ParametroGeral parametroImpressaoParcelamento = this.parametroGeralService.findByParametroAndModulo(ParametroGeralEnum.VALIDACAO_EMISSAO_BLOQUETO_REPARC, ModuloEnum.MODULO_TRIBUTARIO.getValue());
            if (Objects.nonNull(parametroImpressaoParcelamento) && parametroImpressaoParcelamento.getValor().equals("S")) {
                numeroParcelasImpressaoBoletoDTO.setNumeroParcela(this.getNumeroParcelaImpressaoBoleto(numeroParcelasImpressaoBoletoDTO));
                numeroParcelasImpressaoBoletoDTO.setDataVencimentoFim(this.getDataVencimentoFimImpressaoBoleto(numeroParcelasImpressaoBoletoDTO));
            }
            this.handleRestricaoMesesBoleto(parcelamento, numeroParcelasImpressaoBoletoDTO);
            return numeroParcelasImpressaoBoletoDTO;
        }
        catch (RestClientException e) {
            throw new EloValidationException(e.getMessage());
        }
    }

    public void handleRestricaoMesesBoleto(Parcelamento parcelamento, NumeroParcelasImpressaoBoletoDTO numeroParcelasImpressaoBoletoDTO) {
        boolean utilizaQtdeMesesAtualAnterioresBoleto = Optional.ofNullable(parcelamento.getParamParcelamento()).map(ParamParcelamento::utilizaQtdeMesesAtualAnterioresBoleto).orElse(Boolean.FALSE);
        if (utilizaQtdeMesesAtualAnterioresBoleto) {
            LocalDate dataFim = numeroParcelasImpressaoBoletoDTO.getDataVencimentoInicio();
            numeroParcelasImpressaoBoletoDTO.setNumeroParcela(Integer.valueOf(1));
            numeroParcelasImpressaoBoletoDTO.setDataLimiteVencimento(dataFim);
            numeroParcelasImpressaoBoletoDTO.setDataVencimentoFim(dataFim);
            numeroParcelasImpressaoBoletoDTO.setUtilizaQtdeMesesAtualAnterioresBoleto(utilizaQtdeMesesAtualAnterioresBoleto);
        }
    }

    private NumeroParcelasImpressaoBoletoDTO buscarNumeroParcelasImpressaoBoleto(Parcelamento parcelamento, ParamParcelamento paramParcelamento, List<ParcelamentoDebitoParcelasDTO> parcelas) {
        List parcelasEmAberto = parcelas.stream().filter(ParcelamentoDebitoParcelasDTO::getAberto).collect(Collectors.toList());
        List parcelasPagas = parcelas.stream().filter(Predicate.not(ParcelamentoDebitoParcelasDTO::getAberto)).collect(Collectors.toList());
        ParcelamentoPassivelQuitacaoDTO parcelamentoPassivelQuitacaoDTO = ParcelamentoPassivelQuitacaoDTO.of((Parcelamento)parcelamento, (ParamParcelamento)paramParcelamento, (Integer)parcelasEmAberto.size(), (Integer)parcelasPagas.size());
        BuscarNumeroParcelasImpressaoBoletoDTO buscarNumeroParcelasDTO = new BuscarNumeroParcelasImpressaoBoletoDTO();
        buscarNumeroParcelasDTO.setTipoCadastro(parcelamento.getCadastroGeral().getTipoCadastro().getValue());
        buscarNumeroParcelasDTO.setCadastroGeral(parcelamento.getCadastroGeral().getCadastroGeral());
        buscarNumeroParcelasDTO.setDataParcelamento(parcelamento.getDataParcelamento());
        buscarNumeroParcelasDTO.getParcelamentos().addAll(Collections.singletonList(parcelamentoPassivelQuitacaoDTO));
        return this.buscarNumeroParcelasImpressaoBoleto(buscarNumeroParcelasDTO);
    }

    public byte[] imprimirCarne(Long idParcelamento) {
        Parcelamento parcelamento = (Parcelamento)this.parcelamentoService.findById((Serializable)idParcelamento).orElseThrow(() -> new EloValidationException(String.format("Parcelamento %d n\u00e3o encontrado", idParcelamento)));
        ParamParcelamento paramParcelamento = (ParamParcelamento)this.paramParcelamentoService.findOne((Serializable)parcelamento.getIdParametroParcelamento());
        FormaPagamento formaPagamento = Optional.ofNullable(paramParcelamento.getFormaPagamento()).orElseGet(() -> this.formaPagamentoService.findFormaPagamentoPadrao(Optional.of(this.contextService.getExercicioAtual())));
        List parcelamentoDebitoParcelasDTO = this.parcelamentoService.findParcelamentoDebitoParcelas(idParcelamento);
        ImpressaoBoletoParcelamentoDTO impressaoBoletoParcelamentoDTO = ImpressaoBoletoParcelamentoDTO.of((Parcelamento)parcelamento, (ParamParcelamento)paramParcelamento, (List)parcelamentoDebitoParcelasDTO, (FormaPagamento)formaPagamento);
        impressaoBoletoParcelamentoDTO.setQuantidadeParcelas(this.getNumeroParcelasImpressaoCarne(parcelamento, paramParcelamento, parcelamentoDebitoParcelasDTO));
        return this.imprimirBoletoAise(impressaoBoletoParcelamentoDTO);
    }

    private Integer getNumeroParcelasImpressaoCarne(Parcelamento parcelamento, ParamParcelamento paramParcelamento, List<ParcelamentoDebitoParcelasDTO> parcelamentoDebitoParcelasDTO) {
        if (this.parcelamentoService.podeImprimirCarneCompleto(parcelamento.getId())) {
            NumeroParcelasImpressaoBoletoDTO numeroParcelas = this.buscarNumeroParcelasImpressaoBoleto(parcelamento, paramParcelamento, parcelamentoDebitoParcelasDTO);
            return numeroParcelas.getQuantidadeParcelaAberta();
        }
        return QUANTIDADE_PARCELA_PERMITIDA;
    }

    public SimulacaoParcelamentoDTO getSimulacoesCidadao(SimulacaoParcelamentoRequestDTO request) {
        Assert.notNull((Object)request.getTipoCadastro(), (String)"Par\u00e2metro tipo cadastro est\u00e1 nulo.");
        Assert.notNull((Object)request.getCadastroGeral(), (String)"Par\u00e2metro cadastro geral est\u00e1 nulo.");
        Assert.notNull((Object)request.getIdParamParcelamento(), (String)"Par\u00e2metro id do par\u00e2metro parcelamento est\u00e1 nulo.");
        Assert.notNull((Object)request.getNumeroParcela(), (String)"Par\u00e2metro numero de parcela \u00e9 obrigat\u00f3rio.");
        Assert.notEmpty((Collection)request.getIdDebitos(), (String)"Lista de d\u00e9bitos est\u00e1 vazia.");
        ParamParcelamento paramParcelamento = this.getParamParcelamentoComApenasUmaEntrada(request.getIdParamParcelamento());
        Boolean concedeDescontoNoPagamento = paramParcelamento.getDescontosPorParcela().stream().anyMatch(desconto -> Boolean.TRUE.equals(desconto.getConcedeDescontoNoPagamento()));
        ParamParcelamentoValorMinimo paramParcelamentoValorMinimo = this.buscarTabelaValorPorNumeroParcela(paramParcelamento.getValoresMinimos(), request.getNumeroParcela());
        if (Objects.nonNull(paramParcelamentoValorMinimo)) {
            this.validarValorMinimoParcelamentoTabelaValores(paramParcelamentoValorMinimo, request.getValorTotal());
        }
        LocalDate dataCorrecao = LocalDate.now();
        LOGGER.info("Iniciando simula\u00e7\u00f5es para o parcelamento da lei {} cadastro {} com {} parcelas", new Object[]{request.getIdParamParcelamento(), request.getCadastroGeral(), request.getNumeroParcela()});
        SimulacaoParcelamentoDTO simulacaoParam = this.getSimulacaoParcelamentoDTO(request, paramParcelamento, dataCorrecao);
        this.validaParcelamento(simulacaoParam, paramParcelamento);
        paramParcelamento.getEntradas().stream().findFirst().ifPresent(paramParcelamentoEntrada -> {
            if (Boolean.TRUE.equals(paramParcelamentoEntrada.getEntradaValorNegociado())) {
                simulacaoParam.setNumeroParcelas(Integer.valueOf(1));
                simulacaoParam.setValorEntrada(BigDecimal.ZERO);
            }
        });
        SimulacaoParcelamentoDTO retorno = this.internalSimularParcelamento(simulacaoParam);
        retorno.setConcedeDescontoNoPagamento(concedeDescontoNoPagamento);
        retorno.setValorTotalAvista();
        if (Objects.nonNull(paramParcelamentoValorMinimo)) {
            this.validarTabelaValoresMinimos(paramParcelamentoValorMinimo, retorno, request.getPossuiDebitosJaParcelados());
        }
        return retorno;
    }

    private void validarTabelaValoresMinimos(ParamParcelamentoValorMinimo paramParcelamentoValorMinimo, SimulacaoParcelamentoDTO simulacaoParcelamentoDTO, Boolean possuiDebitosJaParcelados) {
        Boolean possuiParcelasMenorQueMinimo;
        BigDecimal valorMinimoParcela = paramParcelamentoValorMinimo.getValorMinimoParcela();
        List<ParcelaParcelamentoDTO> parcelas = simulacaoParcelamentoDTO.getDebitosParcelaTributoParcelamento();
        if (Boolean.TRUE.equals(possuiDebitosJaParcelados)) {
            parcelas = parcelas.stream().filter(parcelaParcelamentoDTO -> !Objects.equals(parcelaParcelamentoDTO.getParcela(), PRIMEIRA_PARCELA)).toList();
        }
        if (Boolean.TRUE.equals(possuiParcelasMenorQueMinimo = Boolean.valueOf(parcelas.stream().anyMatch(item -> item.getValorTotal().compareTo(valorMinimoParcela) < 0)))) {
            throw new EloValidationException(String.format("Existe parcela na simula\u00e7\u00e3o que possui valor abaixo do valor m\u00ednimo configurado para a gera\u00e7\u00e3o de parcelamentos no intervalo de parcelas entre %d e %d. O valor m\u00ednimo configurado por parcela \u00e9 R$ %.2f.", paramParcelamentoValorMinimo.getNumeroParcelaInicial(), paramParcelamentoValorMinimo.getNumeroParcelaFinal(), paramParcelamentoValorMinimo.getValorMinimoParcela().doubleValue()));
        }
    }

    private void validarValorMinimoParcelamentoTabelaValores(ParamParcelamentoValorMinimo paramParcelamentoValorMinimo, BigDecimal totalSelecionado) {
        if (totalSelecionado.compareTo(paramParcelamentoValorMinimo.getValorMinimoParcelamento()) < 0) {
            throw new EloValidationException(String.format("O total dos d\u00e9bitos para o intervalo de parcelas entre %d e %d deve ser no m\u00ednimo R$ %.2f.Por\u00e9m o total atualmente \u00e9 de R$ %.2f.", paramParcelamentoValorMinimo.getNumeroParcelaInicial(), paramParcelamentoValorMinimo.getNumeroParcelaFinal(), paramParcelamentoValorMinimo.getValorMinimoParcelamento().doubleValue(), totalSelecionado.doubleValue()));
        }
    }

    public ParamParcelamentoValorMinimo buscarTabelaValorPorNumeroParcela(List<ParamParcelamentoValorMinimo> lista, Long numeroParcela) {
        return lista.stream().filter(p -> numeroParcela >= p.getNumeroParcelaInicial() && numeroParcela <= p.getNumeroParcelaFinal()).findFirst().orElse(null);
    }

    private ParamParcelamento getParamParcelamentoComApenasUmaEntrada(Long idParamParcelamento) {
        ParamParcelamento paramParcelamento = (ParamParcelamento)this.paramParcelamentoService.findById((Serializable)idParamParcelamento).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi encontrado par\u00e2metro de parcelamento %s", idParamParcelamento)));
        if (paramParcelamento.getEntradas().size() > 1) {
            LOGGER.error("Par\u00e2metro Parcelado {} possui {} entradas configuradas", (Object)idParamParcelamento, (Object)paramParcelamento.getEntradas().size());
            throw new EloValidationException(String.format("Par\u00e2metro Parcelamento %s possui mais de uma entrada configurada", idParamParcelamento));
        }
        return paramParcelamento;
    }

    private SimulacaoParcelamentoDTO getSimulacaoParcelamentoDTO(SimulacaoParcelamentoRequestDTO request, ParamParcelamento paramParcelamento, LocalDate dataCorrecao) {
        ParamParcelamentoEntrada entrada = Optional.ofNullable(paramParcelamento).map(ParamParcelamento::getEntradas).map(List::getFirst).orElse(null);
        SimulacaoParcelamentoDTO simulacaoParam = new SimulacaoParcelamentoDTO();
        simulacaoParam.setTipoCadastro(Integer.valueOf(request.getTipoCadastro().intValue()));
        simulacaoParam.setCadastroGeral(request.getCadastroGeral());
        simulacaoParam.setTipo(paramParcelamento.getTipo());
        simulacaoParam.setIdParametroParcelamento(paramParcelamento.getId());
        simulacaoParam.setDataCorrecao(dataCorrecao);
        simulacaoParam.setNumeroParcelas(Integer.valueOf(request.getNumeroParcela().intValue()));
        simulacaoParam.setEntrada((Long)Optional.ofNullable(entrada).map(ParamParcelamentoEntrada::getId).map(ParamParcelamentoEntradaId::getEntrada).orElse(null));
        simulacaoParam.setRequerente(request.getRequerente());
        simulacaoParam.setDebitos(request.getIdDebitos());
        simulacaoParam.setTotalSelecionado(request.getValorTotal());
        simulacaoParam.setTipoDesconto(paramParcelamento.getTipoDesconto().getValue());
        simulacaoParam.setContribuinte(request.getContribuinte());
        if (Objects.isNull(entrada)) {
            return simulacaoParam;
        }
        if (Boolean.TRUE.equals(this.getUtilizaDataCompletaEntrada(entrada))) {
            simulacaoParam.setDataEntrada(this.getDataCompletaEntradaComDiaUtil(entrada.getDataCompletaEntrada()));
            return simulacaoParam;
        }
        if (Boolean.TRUE.equals(this.getUtilizaDataFixaEntrada(entrada))) {
            simulacaoParam.setDataEntrada(this.getMesmoDiaUtilMesSeguinte(entrada.getDataEntrada()));
        }
        return simulacaoParam;
    }

    private Boolean getUtilizaDataCompletaEntrada(ParamParcelamentoEntrada entrada) {
        if (Objects.isNull(entrada)) {
            return Boolean.FALSE;
        }
        return Optional.ofNullable(entrada.getUtilizaDataCompletaEntrada()).orElse(Boolean.FALSE) != false && Optional.ofNullable(entrada.getUtilizaDataFixaEntrada()).orElse(Boolean.FALSE) == false && Objects.nonNull(entrada.getDataCompletaEntrada());
    }

    private Boolean getUtilizaDataFixaEntrada(ParamParcelamentoEntrada entrada) {
        if (Objects.isNull(entrada)) {
            return Boolean.FALSE;
        }
        return Optional.ofNullable(entrada.getUtilizaDataFixaEntrada()).orElse(Boolean.FALSE);
    }

    private LocalDate getDataCompletaEntradaComDiaUtil(LocalDate dataCompletaEntrada) {
        return this.diaUtilService.validateDiaUtil(dataCompletaEntrada);
    }

    private LocalDate getMesmoDiaUtilMesSeguinte(Long dia) {
        LocalDate mesmoDiaMesSeguinte = DateUtils.getSameDiaMesSeguinte((int)dia.intValue());
        return this.diaUtilService.validateDiaUtil(mesmoDiaMesSeguinte);
    }

    private LocalDate getDataVencimentoFimImpressaoBoleto(NumeroParcelasImpressaoBoletoDTO dto) {
        LocalDate dataVencimentoCalculada = dto.getDataVencimentoInicio().plusMonths(dto.getNumeroParcela().intValue());
        return Stream.of(dataVencimentoCalculada, dto.getDataLimiteVencimento()).min(LocalDate::compareTo).orElse(dto.getDataLimiteVencimento());
    }

    private Integer getNumeroParcelaImpressaoBoleto(NumeroParcelasImpressaoBoletoDTO dto) {
        return Integer.min(NUMERO_PADRAO_PARCELAS_IMPRESSAO, dto.getNumeroParcela());
    }

    public byte[] imprimirCarneParcelamentoAise(ImpressaoBoletoParcelamentoDTO request) {
        request.getParcelamentos().forEach(p -> {
            Parcelamento parcelamento = (Parcelamento)this.parcelamentoService.findOne((Serializable)p.getIdParcelamento());
            p.setIdParametroParcelamento(parcelamento.getIdParametroParcelamento());
        });
        try {
            String url = this.tributosProperties.getAise().getWsBaseUrl().concat("/datasnap/rest/tparcelamentos/ImprimirCarneParcelamento");
            HttpHeaders headers = this.aiseLoginServiceRest.getHttpAuthorizationHeaders();
            this.createLogRequestIntegracaoAise(url, (Object)request);
            return (byte[])this.restTemplate.exchange(url, HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)request, (HttpHeaders)headers), byte[].class, new Object[0]).getBody();
        }
        catch (RestClientException e) {
            throw new EloValidationException(e.getMessage());
        }
    }

    private void validaValorMinimoParametrizadoParaParcelamento(SimulacaoParcelamentoDTO simulacaoParcelamentoDTO) {
        ParamParcelamento paramParcelamento = (ParamParcelamento)this.paramParcelamentoService.findOne((Serializable)simulacaoParcelamentoDTO.getIdParametroParcelamento());
        this.validaValorMinimoParametrizadoParaParcelamento(simulacaoParcelamentoDTO, paramParcelamento);
    }

    private void validaValorMinimoParametrizadoParaParcelamento(SimulacaoParcelamentoDTO simulacaoParcelamentoDTO, ParamParcelamento paramParcelamento) {
        BigDecimal valorMinimoExigido;
        BigDecimal valorTotalParcelamento = simulacaoParcelamentoDTO.getTotalSelecionado();
        if (valorTotalParcelamento.compareTo(valorMinimoExigido = paramParcelamento.getValorMinimoParcelamento()) < 0) {
            String valorComDuasCasasDecimais = valorMinimoExigido.setScale(2, RoundingMode.CEILING).toString().replace(".", ",");
            throw new SimulacaoParcelamentoException(HttpStatus.BAD_REQUEST, String.format("O valor da d\u00edvida a ser parcelada n\u00e3o pode ser inferior a R$ %s", valorComDuasCasasDecimais));
        }
    }

    public void createLogRequestIntegracaoAise(String url, Object object) {
        LOGGER.debug("Request to {} with {}", (Object)url, object);
    }

    public void createLogResponseIntegracaoAise(String url, Object object) {
        LOGGER.debug("Response of {} is {}", (Object)url, object);
    }

    @Generated
    public AiseParcelamentoServiceRest(RestTemplate restTemplate, AiseLoginServiceRest aiseLoginServiceRest, TributosProperties tributosProperties, ParamParcelamentoService paramParcelamentoService, ParcelamentoService parcelamentoService, ParametroGeralService parametroGeralService, FormaPagamentoService formaPagamentoService, ContextService contextService, ConfigurableEnvironment environment, TarefaAssincronaService tarefaAssincronaService, NotificacaoService notificacaoService, ObjectMapper objectMapper, HistoricoAtendimentoService historicoAtendimentoService, GeraLivroDividaAtivaService geraLivroDividaAtivaService, AiseUrlParcelamentoResolver aiseUrlParcelamentoResolver, DebitoService debitoService, DiaUtilService diaUtilService) {
        this.restTemplate = restTemplate;
        this.aiseLoginServiceRest = aiseLoginServiceRest;
        this.tributosProperties = tributosProperties;
        this.paramParcelamentoService = paramParcelamentoService;
        this.parcelamentoService = parcelamentoService;
        this.parametroGeralService = parametroGeralService;
        this.formaPagamentoService = formaPagamentoService;
        this.contextService = contextService;
        this.environment = environment;
        this.tarefaAssincronaService = tarefaAssincronaService;
        this.notificacaoService = notificacaoService;
        this.objectMapper = objectMapper;
        this.historicoAtendimentoService = historicoAtendimentoService;
        this.geraLivroDividaAtivaService = geraLivroDividaAtivaService;
        this.aiseUrlParcelamentoResolver = aiseUrlParcelamentoResolver;
        this.debitoService = debitoService;
        this.diaUtilService = diaUtilService;
    }
}

