/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ws.rest;

import br.com.elotech.fluent.ReportDatasource;
import br.com.elotech.fluent.dataset.DatasetRecord;
import br.com.elotech.fluent.dataset.loader.DatasetLoader;
import br.com.elotech.fluent.dataset.loader.DatasetLoaders;
import br.com.elotech.fluent.dataset.loader.ReportDataLoader;
import br.com.elotech.fluent.param.Param;
import br.com.elotech.fluent.param.ParamLoader;
import br.com.elotech.report.EloReportFactory;
import br.com.elotech.report.file.ReportFileResolverFactory;
import br.com.elotech.tributos.config.HttpEntityFactory;
import br.com.elotech.tributos.domain.ArquivoJasper;
import br.com.elotech.tributos.domain.ContatoPessoa;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.parcelamento.EstornoParcelamento;
import br.com.elotech.tributos.domain.parcelamento.ParamParcelamento;
import br.com.elotech.tributos.domain.parcelamento.Parcelamento;
import br.com.elotech.tributos.dto.DebitoEmAbertoDTO;
import br.com.elotech.tributos.dto.ListasNecessariasCalculaAcrescimoDTO;
import br.com.elotech.tributos.dto.pagamento.EstornoParcelamentoDebitoReceitaEmAbertoDTO;
import br.com.elotech.tributos.dto.parcelamento.AiseEstornoParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.AiseParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.SimulacaoEstornoParcelamentoDTO;
import br.com.elotech.tributos.dto.parcelamento.TermoRecisaoParcelamentoDTO;
import br.com.elotech.tributos.enums.TipoArquivoJasper;
import br.com.elotech.tributos.report.loader.TermoCancelamentoParcelamentoParamLoader;
import br.com.elotech.tributos.repository.parcelamento.EstornoParcelamentoRepository;
import br.com.elotech.tributos.service.AiseDebitoService;
import br.com.elotech.tributos.service.ArquivoJasperService;
import br.com.elotech.tributos.service.CancelamentoBoletoEstornoParcelamentoService;
import br.com.elotech.tributos.service.FormaPagamentoService;
import br.com.elotech.tributos.service.ParcelamentoService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import br.com.elotech.tributos.service.ws.AiseEstornoParcelamentoService;
import br.com.elotech.tributos.service.ws.rest.AiseLoginServiceRest;
import br.com.elotech.tributos.service.ws.rest.AiseUrlParcelamentoResolver;
import br.com.elotech.tributos.util.FileUtils;
import br.com.elotech.tributos.utils.TenantUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.persistence.EntityNotFoundException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class AiseEstornoParcelamentoServiceRest
implements AiseEstornoParcelamentoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AiseEstornoParcelamentoServiceRest.class);
    private final RestTemplate restTemplate;
    private final AiseLoginServiceRest aiseLoginServiceRest;
    private final AiseDebitoService debitoService;
    private final CancelamentoBoletoEstornoParcelamentoService cancelamentoBoletoEstornoParcelamentoService;
    private final AiseUrlParcelamentoResolver aiseUrlParcelamentoResolver;
    private final ParcelamentoService parcelamentoService;
    private final TermoCancelamentoParcelamentoParamLoader termoCancelamentoParcelamentoParamLoader;
    private final ReportFileResolverFactory reportFileResolverFactory;
    private final ArquivoJasperService arquivoJasperService;
    private final EstornoParcelamentoRepository estornoParcelamentoRepository;
    private final ObjectMapper objectMapper;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final FormaPagamentoService formaPagamentoService;
    public static final String DEFAULT_TERMO_CANCELAMENTO_PARCELAMENTO = "termo-estorno-parcelamento.jrxml";

    public SimulacaoEstornoParcelamentoDTO simularEstornoParcelamento(AiseEstornoParcelamentoDTO request) {
        HttpHeaders headers = this.aiseLoginServiceRest.getHttpAuthorizationHeaders();
        String urlWsAise = this.aiseUrlParcelamentoResolver.buildUrlAiseAndSetHostHeader(headers);
        String url = urlWsAise.concat("/datasnap/rest/tEstornoParcelamento/simular");
        log.debug("URL WS aise simula\u00e7\u00e3o estorno parcelamento: {}", (Object)url);
        AiseParcelamentoDTO parcelamentoDTO = (AiseParcelamentoDTO)this.restTemplate.exchange(url, HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)request, (HttpHeaders)headers), AiseParcelamentoDTO.class, new Object[0]).getBody();
        return SimulacaoEstornoParcelamentoDTO.from((AiseParcelamentoDTO)parcelamentoDTO, (List)this.debitoService.getDebitosParcelamento(request.getIdParcelamento()));
    }

    public AiseEstornoParcelamentoDTO estornarParcelamento(AiseEstornoParcelamentoDTO request) {
        AiseEstornoParcelamentoDTO estornoParcelamentoDTO = this.estornarParcelamentoUsandoWebServiceAise(request);
        Parcelamento parcelamento = this.findParcelamentoById(request.getIdParcelamento());
        this.cancelarBoletosDoParcelamento(parcelamento);
        this.enviarEmailEstornoContrato(parcelamento);
        return estornoParcelamentoDTO;
    }

    private AiseEstornoParcelamentoDTO estornarParcelamentoUsandoWebServiceAise(AiseEstornoParcelamentoDTO request) {
        HttpHeaders headers = this.aiseLoginServiceRest.getHttpAuthorizationHeaders();
        String urlWsAise = this.aiseUrlParcelamentoResolver.buildUrlAiseAndSetHostHeader(headers);
        String url = urlWsAise.concat("/datasnap/rest/tEstornoParcelamento/executar");
        log.debug("URL WS aise estorno parcelamento: {}", (Object)url);
        return (AiseEstornoParcelamentoDTO)this.restTemplate.exchange(url, HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)request, (HttpHeaders)headers), AiseEstornoParcelamentoDTO.class, new Object[0]).getBody();
    }

    private void enviarEmailEstornoContrato(Parcelamento parcelamento) {
        ParamParcelamento parametroParcelamento = parcelamento.getParamParcelamento();
        boolean enviaEmail = parametroParcelamento.enviaEmailEstornoContrato();
        Optional<String> emailPrincipal = Optional.ofNullable(parcelamento.getRequerente()).map(Pessoa::getContatoPrincipal).map(ContatoPessoa::getEmail);
        if (!enviaEmail || emailPrincipal.isEmpty()) {
            return;
        }
        String template = parametroParcelamento.getTemplateEmailEstornoContrato();
        Long numeroContrato = parcelamento.getNumeroContrato();
        Long anoContrato = parcelamento.getAnoContrato();
        String conteudo = this.montarConteudoEmailEstornoDeContrato(template, numeroContrato, anoContrato);
        this.parcelamentoService.enviarEmailContratoEstornado(emailPrincipal.get(), conteudo);
    }

    private String montarConteudoEmailEstornoDeContrato(String template, Long numeroContrato, Long anoContrato) {
        return String.format("%s \n Contrato de parcelamento: %d/%d", template, numeroContrato, anoContrato);
    }

    public List<AiseEstornoParcelamentoDTO> estornarParcelamentoEmLote(List<AiseEstornoParcelamentoDTO> requests) {
        return requests.stream().map(arg_0 -> this.estornarParcelamento(arg_0)).collect(Collectors.toList());
    }

    public void desfazerEstornoParcelamento(Long idEstornoParcelamento) {
        HttpHeaders headers = this.aiseLoginServiceRest.getHttpAuthorizationHeaders();
        String urlWsAise = this.aiseUrlParcelamentoResolver.buildUrlAiseAndSetHostHeader(headers);
        String url = urlWsAise.concat("/datasnap/rest/tEstornoParcelamento/desfazer");
        log.debug("URL WS aise desfazer estorno parcelamento: {}", (Object)url);
        AiseEstornoParcelamentoDTO request = new AiseEstornoParcelamentoDTO();
        request.setIdEstornoParcelamento(idEstornoParcelamento);
        this.restTemplate.exchange(url, HttpMethod.POST, HttpEntityFactory.createHttpEntity((Object)request, (HttpHeaders)headers), AiseEstornoParcelamentoDTO.class, new Object[0]).getBody();
    }

    private Parcelamento findParcelamentoById(Long id) {
        return (Parcelamento)this.parcelamentoService.findById((Serializable)id).orElseThrow(() -> new EntityNotFoundException("N\u00e3o encontrado parcelamento " + id));
    }

    private void cancelarBoletosDoParcelamento(Parcelamento parcelamento) {
        this.cancelamentoBoletoEstornoParcelamentoService.cancelamentoBoletoPorEstornoParcelamento(parcelamento);
    }

    public byte[] imprimirTermoCancelamento(Long idParcelamento) throws IOException {
        log.info("Gerando termo de cancelamento do parcelamento de ID {}", (Object)idParcelamento);
        TermoRecisaoParcelamentoDTO termoCancelamentoParcelamento = this.buildTermoCancelamentoParcelamento(idParcelamento);
        DatasetLoader mainDatasetLoader = DatasetLoaders.single((DatasetRecord)termoCancelamentoParcelamento, TermoRecisaoParcelamentoDTO.class);
        ReportDatasource datasource = ReportDatasource.builder().add("main", (ReportDataLoader)mainDatasetLoader).param(Param.of((String)"PARAM_ParcelasPagas", (Object)termoCancelamentoParcelamento.getParcelasPagas())).param(Param.of((String)"PARAM_ReceitasPendentes", (Object)termoCancelamentoParcelamento.getReceitasPendentes())).params((ParamLoader)this.termoCancelamentoParcelamentoParamLoader).build();
        log.debug("Buscando arquivo modificado do termo de cancelamento do parcelamento");
        ArquivoJasper arquivoJasper = this.arquivoJasperService.buscarArquivoJasperPorTipo(TipoArquivoJasper.TERMO_CANCELAMENTO_PARCELAMENTO);
        String filePath = this.getPathRelatorioPrivadoOuPadrao(arquivoJasper);
        if (Objects.nonNull(arquivoJasper)) {
            log.debug("Arquivo Jasper encontrado, gerando relat\u00f3rio privado {}.", (Object)filePath);
            return this.relatorioPrivadoTermoCancelamentoParcelamento(filePath, datasource);
        }
        log.debug("Arquivo Jasper n\u00e3o encontrado, gerando relat\u00f3rio padr\u00e3o.");
        return EloReportFactory.jasper().reportFile(this.reportFileResolverFactory.fromFile(filePath)).setReportDatasource(datasource).setObjectMapper(this.objectMapper).build().exportToPdf();
    }

    private TermoRecisaoParcelamentoDTO buildTermoCancelamentoParcelamento(Long idParcelamento) {
        log.debug("Buscando dados para dataset de termo de cancelamento do parcelamento");
        Parcelamento parcelamento = (Parcelamento)this.parcelamentoService.findById((Serializable)idParcelamento).orElseThrow(() -> new EntityNotFoundException(String.format("Parcelamento com ID %d n\u00e3o encontrado", idParcelamento)));
        EstornoParcelamento estornoParcelamento = this.getEstornoParcelamentoMaisRecente(idParcelamento);
        log.debug("Estorno de parcelamento mais recente encontrado: {}", (Object)estornoParcelamento.getId());
        log.debug("Buscando parcelas pagas e receitas pendentes do estorno de parcelamento de ID {}", (Object)estornoParcelamento.getId());
        List parcelasPagas = this.estornoParcelamentoRepository.findParcelasPagasByIdEstornoParcelamento(estornoParcelamento.getId());
        log.debug("Parcelas pagas encontradas: {}", (Object)parcelasPagas.size());
        List receitasPendentes = this.estornoParcelamentoRepository.findReceitasPendentesByIdEstornoParcelamento(estornoParcelamento.getId());
        log.debug("Receitas pendentes encontradas: {}", (Object)receitasPendentes.size());
        if (!receitasPendentes.isEmpty()) {
            log.debug("Calculando acr\u00e9scimos de {} receitas pendentes", (Object)receitasPendentes.size());
            this.calcularAcrescimos(receitasPendentes);
            log.debug("Acr\u00e9scimos calculados");
        }
        return new TermoRecisaoParcelamentoDTO(parcelamento, estornoParcelamento, parcelasPagas, receitasPendentes);
    }

    private EstornoParcelamento getEstornoParcelamentoMaisRecente(Long idParcelamento) {
        return (EstornoParcelamento)this.estornoParcelamentoRepository.findTopByIdParcelamentoOrderByIdDesc(idParcelamento).orElseThrow(() -> new EntityNotFoundException(String.format("Nenhum estorno de parcelamento encontrado para o parcelamento de ID %d", idParcelamento)));
    }

    private String getPathRelatorioPrivadoOuPadrao(ArquivoJasper arquivoJasper) throws IOException {
        if (Objects.nonNull(arquivoJasper)) {
            String fileName = TenantUtils.getIdentificadorTenant().concat("-").concat(arquivoJasper.getNomeArquivo());
            File tempFile = FileUtils.createTempFile((String)fileName, (String)".jrxml", (byte[])arquivoJasper.getArquivo());
            return tempFile.getPath();
        }
        return DEFAULT_TERMO_CANCELAMENTO_PARCELAMENTO;
    }

    private byte[] relatorioPrivadoTermoCancelamentoParcelamento(String filePath, ReportDatasource datasource) throws IOException {
        byte[] pdf = EloReportFactory.jasper().reportFile(new ReportFileResolverFactory("").fromFile(filePath)).setReportDatasource(datasource).setObjectMapper(this.objectMapper).build().exportToPdf();
        Files.deleteIfExists(Paths.get(filePath, new String[0]));
        return pdf;
    }

    private void calcularAcrescimos(List<EstornoParcelamentoDebitoReceitaEmAbertoDTO> receitasPendentes) {
        List<DebitoEmAbertoDTO> debitos = receitasPendentes.stream().map(EstornoParcelamentoDebitoReceitaEmAbertoDTO::toDebitoEmAbertoDTO).toList();
        Long formaPagamento = this.formaPagamentoService.findFormaPagamentoPadrao(Optional.empty()).getId();
        ListasNecessariasCalculaAcrescimoDTO listas = this.calculoAcrescimoService.createNecessariasCalculaAcrescimo();
        log.debug("Calculando acr\u00e9scimos para {} receitas", (Object)debitos.size());
        List debitosComAcrescimos = this.calculoAcrescimoService.calculaAcrescimos(debitos, formaPagamento, LocalDate.now(), listas, Boolean.FALSE);
        log.debug("Aplicando acr\u00e9scimos calculados nas receitas pendentes");
        this.addAcrescimosEmReceitasPendentes(receitasPendentes, debitosComAcrescimos);
    }

    private void addAcrescimosEmReceitasPendentes(List<EstornoParcelamentoDebitoReceitaEmAbertoDTO> receitasPendentes, List<DebitoEmAbertoDTO> debitosComAcrescimos) {
        receitasPendentes.forEach(receita -> debitosComAcrescimos.stream().filter(acrescimo -> receita.getIdDebito().equals(acrescimo.getIdDebito()) && receita.getIdDebitoParcelaReceita().equals(acrescimo.getIdDebitoParcelaReceita())).findFirst().ifPresent(acrescimo -> {
            receita.setValorMulta(acrescimo.getValorMulta());
            receita.setValorJuros(acrescimo.getValorJuros());
            receita.setValorCorrecao(acrescimo.getValorCorrecao());
            receita.setValorDesconto(acrescimo.getValorDescontos());
        }));
    }

    @Generated
    public AiseEstornoParcelamentoServiceRest(RestTemplate restTemplate, AiseLoginServiceRest aiseLoginServiceRest, AiseDebitoService debitoService, CancelamentoBoletoEstornoParcelamentoService cancelamentoBoletoEstornoParcelamentoService, AiseUrlParcelamentoResolver aiseUrlParcelamentoResolver, ParcelamentoService parcelamentoService, TermoCancelamentoParcelamentoParamLoader termoCancelamentoParcelamentoParamLoader, ReportFileResolverFactory reportFileResolverFactory, ArquivoJasperService arquivoJasperService, EstornoParcelamentoRepository estornoParcelamentoRepository, ObjectMapper objectMapper, CalculoAcrescimoService calculoAcrescimoService, FormaPagamentoService formaPagamentoService) {
        this.restTemplate = restTemplate;
        this.aiseLoginServiceRest = aiseLoginServiceRest;
        this.debitoService = debitoService;
        this.cancelamentoBoletoEstornoParcelamentoService = cancelamentoBoletoEstornoParcelamentoService;
        this.aiseUrlParcelamentoResolver = aiseUrlParcelamentoResolver;
        this.parcelamentoService = parcelamentoService;
        this.termoCancelamentoParcelamentoParamLoader = termoCancelamentoParcelamentoParamLoader;
        this.reportFileResolverFactory = reportFileResolverFactory;
        this.arquivoJasperService = arquivoJasperService;
        this.estornoParcelamentoRepository = estornoParcelamentoRepository;
        this.objectMapper = objectMapper;
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.formaPagamentoService = formaPagamentoService;
    }
}

