/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ws.oxy;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.calculo.dto.CadastroCalculoRoot;
import br.com.elotech.tributos.calculo.service.CalculoTributoExecucaoService;
import br.com.elotech.tributos.calculo.service.CalculoTributoService;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.ImobiliarioItbi;
import br.com.elotech.tributos.domain.ParametroItbi;
import br.com.elotech.tributos.domain.calculo.CalculoTributo;
import br.com.elotech.tributos.dto.DebitoManualDTO;
import br.com.elotech.tributos.dto.DebitoManualTributoDTO;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DividaService;
import br.com.elotech.tributos.service.ImobiliarioItbiService;
import br.com.elotech.tributos.service.exception.ImobiliarioItbiException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class OxyAiseTaxaItbiService {
    private final ImobiliarioItbiService imobiliarioItbiService;
    private final CalculoTributoService calculoTributoService;
    private final DividaService dividaService;
    private final CalculoTributoExecucaoService calculoTributoExecucaoService;
    private final ContextService contextService;

    public List<DebitoManualTributoDTO> geraReceitaDasTaxas(DebitoManualDTO debitoRequest, Long idImobiliarioItbi) {
        ParametroItbi parametroItbi = this.findParametroItbiRequired(idImobiliarioItbi);
        this.lancaErroSeDividaDiferente(debitoRequest, parametroItbi);
        return parametroItbi.getUtilizaFormulaCalculo() != false ? this.criaReceitas(debitoRequest, parametroItbi) : Collections.emptyList();
    }

    private List<DebitoManualTributoDTO> criaReceitas(DebitoManualDTO debitoRequest, ParametroItbi parametroItbi) {
        List calculoRoots = this.calcula(debitoRequest, parametroItbi);
        this.lancaErroSeTiverInconsistencias(calculoRoots);
        List tributosGerados = this.geraReceitas(calculoRoots);
        return this.filtraTributosQueTemNoDebito(debitoRequest, tributosGerados);
    }

    private List<CadastroCalculoRoot<Long>> calcula(DebitoManualDTO debito, ParametroItbi parametroItbi) {
        Divida divida = this.findDividaRequired(debito, parametroItbi);
        List calculoTributos = this.findCalculoTributosByDividaAndExercicio(debito, divida);
        Long exercicio = debito.getExercicio();
        LocalDate referencia = debito.getDataLancamento();
        String filtro = String.format("cadastrogeral.tipocadastro = %s and cadastrogeral.cadastrogeral = %s", debito.getTipoCadastro().getValue(), debito.getCadastroGeral());
        return this.calculoTributoExecucaoService.calcular(calculoTributos, exercicio, filtro, Boolean.valueOf(false), referencia);
    }

    private void lancaErroSeTiverInconsistencias(List<CadastroCalculoRoot<Long>> calculoRoots) {
        for (CadastroCalculoRoot<Long> root : calculoRoots) {
            List inconsistencias = root.getInconsistencias();
            if (inconsistencias.isEmpty()) continue;
            String messagesInconsistencias = inconsistencias.stream().map(inconsistencia -> String.format("%s:%s", inconsistencia.getTributo(), inconsistencia.getMessage())).collect(Collectors.joining(","));
            throw new EloValidationException(String.format("Erro ao realizar o c\u00e1lculo da taxa de ITBI [ CadastroCalculoRoot = id: %s - tipoCadastro: %s - cadastroGeral: %s ]. Inconsist\u00eancias: %s", root.getId(), root.getTipoCadastro(), root.getCadastroGeral(), messagesInconsistencias));
        }
    }

    private List<DebitoManualTributoDTO> geraReceitas(List<CadastroCalculoRoot<Long>> calculoRoots) {
        return calculoRoots.stream().map(arg_0 -> this.geraReceita(arg_0)).collect(Collectors.toList());
    }

    private DebitoManualTributoDTO geraReceita(CadastroCalculoRoot<Long> root) {
        DebitoManualTributoDTO tributo = new DebitoManualTributoDTO();
        root.getResultado().forEach((calculoTributo, resultadoDTO) -> {
            tributo.setTributo(calculoTributo.getTributo().getTributo());
            tributo.setValorTributo(BigDecimal.valueOf(resultadoDTO.getValor()));
            tributo.setValorDesconto(BigDecimal.valueOf(resultadoDTO.getValorRenuncia()));
            tributo.setValorBaseCalculo(BigDecimal.valueOf(resultadoDTO.getValorBase()));
        });
        return tributo;
    }

    private List<DebitoManualTributoDTO> filtraTributosQueTemNoDebito(DebitoManualDTO debitoManual, List<DebitoManualTributoDTO> tributosGerados) {
        List tributosInclusoNoDebitoSigla = debitoManual.getTributos().stream().map(DebitoManualTributoDTO::getTributo).collect(Collectors.toList());
        return tributosGerados.stream().filter(tributo -> !tributosInclusoNoDebitoSigla.contains(tributo.getTributo())).distinct().collect(Collectors.toList());
    }

    private void lancaErroSeDividaDiferente(DebitoManualDTO debitoManual, ParametroItbi parametroItbi) {
        if (!debitoManual.getDivida().equals(parametroItbi.getDivida())) {
            throw new RestException(HttpStatus.CONFLICT, String.format("Divida do Debito diferente do Par\u00e2metro de ITBI. D\u00edvida do d\u00e9bito:  %s, Divida do Par\u00e2metro: %s", debitoManual.getDivida(), parametroItbi.getDivida()));
        }
    }

    private List<CalculoTributo> findCalculoTributosByDividaAndExercicio(DebitoManualDTO debitoRequest, Divida divida) {
        return this.calculoTributoService.findByDividasAndExercicio(Collections.singletonList(divida), debitoRequest.getExercicio());
    }

    private ParametroItbi findParametroItbiRequired(Long idImobiliarioItbi) {
        ImobiliarioItbi imobiliarioItbi = this.findImobiliarioItbiRequired(idImobiliarioItbi);
        ParametroItbi parametroItbi = imobiliarioItbi.getParametroItbi();
        if (parametroItbi == null) {
            throw new RestException(HttpStatus.NOT_FOUND, String.format("N\u00e3o foi encontrado ParametroItbi vinculado ao ImobiliarioITBI com o id %s. N\u00e3o ser\u00e1 poss\u00edvel prosseguir", idImobiliarioItbi));
        }
        return parametroItbi;
    }

    private ImobiliarioItbi findImobiliarioItbiRequired(Long id) {
        ImobiliarioItbi imobiliarioItbi = (ImobiliarioItbi)this.imobiliarioItbiService.findOne((Serializable)id);
        if (imobiliarioItbi == null) {
            throw new ImobiliarioItbiException(HttpStatus.NOT_FOUND, String.format("N\u00e3o foi encontrado ImobiliarioItbi com o id %s. N\u00e3o ser\u00e1 poss\u00edvel prosseguir", id));
        }
        return imobiliarioItbi;
    }

    private Divida findDividaRequired(DebitoManualDTO debitoRequest, ParametroItbi parametroItbi) {
        Long entidade = this.contextService.getEntidadePrincipal();
        Long exercicio = debitoRequest.getExercicio();
        Long divida = parametroItbi.getDivida();
        Long idParametro = parametroItbi.getId();
        return (Divida)this.dividaService.findByEntidadeAndExercicioAndDivida(entidade, debitoRequest.getExercicio(), parametroItbi.getDivida()).orElseThrow(() -> new RestException(HttpStatus.NOT_FOUND, String.format("N\u00e3o foi encontrado d\u00edvida parametrizada no parametro do itbi [id: %s], divida [entidade: %d, exercicio: %d e guiarecolhimento: %d]", idParametro, entidade, exercicio, divida)));
    }

    @Generated
    public OxyAiseTaxaItbiService(ImobiliarioItbiService imobiliarioItbiService, CalculoTributoService calculoTributoService, DividaService dividaService, CalculoTributoExecucaoService calculoTributoExecucaoService, ContextService contextService) {
        this.imobiliarioItbiService = imobiliarioItbiService;
        this.calculoTributoService = calculoTributoService;
        this.dividaService = dividaService;
        this.calculoTributoExecucaoService = calculoTributoExecucaoService;
        this.contextService = contextService;
    }
}

