/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.webiss;

import br.com.elotech.tributos.domain.webiss.WebIssArquivo;
import br.com.elotech.tributos.domain.webiss.WebIssRegistro312;
import br.com.elotech.tributos.domain.webiss.WebIssRegistro334;
import br.com.elotech.tributos.dto.webiss.Registro312DTO;
import br.com.elotech.tributos.dto.webiss.Registro334DTO;
import br.com.elotech.tributos.enums.webiss.TipoRegistroWebIss;
import br.com.elotech.tributos.repository.webiss.WebIssArquivoRepository;
import br.com.elotech.tributos.repository.webiss.WebIssRegistro312Repository;
import br.com.elotech.tributos.repository.webiss.WebIssRegistro334Repository;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WebIssProcessorService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebIssProcessorService.class);
    private final WebIssArquivoRepository webIssArquivoRepository;
    private final WebIssRegistro334Repository webIssRegistro334Repository;
    private final WebIssRegistro312Repository webIssRegistro312Repository;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public WebIssArquivo inserirArquivo(LocalDate dataInicio, LocalDate dataFinal, Long quantidadeRegistros, TipoRegistroWebIss tipoRegistroWebIss) {
        WebIssArquivo webIssArquivo = new WebIssArquivo();
        webIssArquivo.setDataImportacao(LocalDate.now());
        webIssArquivo.setHoraImportacao(DateUtils.localDateTimeToHoraFormatoBrasileiro((LocalDateTime)LocalDateTime.now()));
        webIssArquivo.setDataInicioConsulta(dataInicio);
        webIssArquivo.setDataFinalConsulta(dataFinal);
        webIssArquivo.setQuantidadeRegistros(quantidadeRegistros);
        webIssArquivo.setTipoRegistro(tipoRegistroWebIss.getDescricao());
        return (WebIssArquivo)this.webIssArquivoRepository.save((Object)webIssArquivo);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void gravarDadosWebIssRegistro334(Registro334DTO registro334DTO) {
        try {
            WebIssRegistro334 webIssRegistro334;
            if (Objects.isNull(registro334DTO.getId())) {
                webIssRegistro334 = registro334DTO.toEntity(registro334DTO);
            } else {
                WebIssRegistro334 entity = (WebIssRegistro334)this.webIssRegistro334Repository.findOne((Object)registro334DTO.getId());
                webIssRegistro334 = registro334DTO.merge(entity, registro334DTO);
            }
            this.webIssRegistro334Repository.save((Object)webIssRegistro334);
        }
        catch (Exception ex) {
            log.error("Erro ao salvar registro com inconsist\u00eancia: {}", (Object)registro334DTO, (Object)ex);
        }
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void gravarDadosWebIssRegistro312(Registro312DTO registro312DTO) {
        try {
            WebIssRegistro312 webIssRegistro312;
            if (Objects.isNull(registro312DTO.getId())) {
                webIssRegistro312 = registro312DTO.toEntity(registro312DTO);
            } else {
                WebIssRegistro312 entity = (WebIssRegistro312)this.webIssRegistro312Repository.findOne((Object)registro312DTO.getId());
                webIssRegistro312 = registro312DTO.merge(entity, registro312DTO);
            }
            this.webIssRegistro312Repository.save((Object)webIssRegistro312);
        }
        catch (Exception ex) {
            log.error("Erro ao salvar registro com inconsist\u00eancia: {}", (Object)registro312DTO, (Object)ex);
        }
    }

    @Generated
    public WebIssProcessorService(WebIssArquivoRepository webIssArquivoRepository, WebIssRegistro334Repository webIssRegistro334Repository, WebIssRegistro312Repository webIssRegistro312Repository) {
        this.webIssArquivoRepository = webIssArquivoRepository;
        this.webIssRegistro334Repository = webIssRegistro334Repository;
        this.webIssRegistro312Repository = webIssRegistro312Repository;
    }
}

