/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.webiss;

import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.webiss.WebIssContaBancaria;
import br.com.elotech.tributos.dto.webiss.LogRegistroWebIssDTO;
import br.com.elotech.tributos.dto.webiss.Registro334DTO;
import br.com.elotech.tributos.enums.webiss.ExceptionWebIssEnum;
import br.com.elotech.tributos.service.exception.WebIssException;
import br.com.elotech.tributos.service.webiss.ImportacaoArquivoWebIssRegistro334Service;
import br.com.elotech.tributos.service.webiss.LoteWebIssService;
import br.com.elotech.tributos.service.webiss.WebIssAuxiliarService;
import br.com.elotech.tributos.service.webiss.WebIssLogRegistroService;
import br.com.elotech.tributos.service.webiss.WebIssProcessorService;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WebIssProcessorRegistro334Service {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebIssProcessorRegistro334Service.class);
    private final LoteWebIssService loteWebIssService;
    private final ImportacaoArquivoWebIssRegistro334Service importacaoArquivoWebIssRegistro334Service;
    private final WebIssProcessorService webIssProcessorService;
    private final WebIssAuxiliarService webIssAuxiliarService;
    private final WebIssLogRegistroService webIssLogRegistroService;

    public void processarRegistro334WebIss(Map<LocalDate, List<Registro334DTO>> registros) {
        for (Map.Entry<LocalDate, List<Registro334DTO>> entry : registros.entrySet()) {
            LocalDate dataCredito = entry.getKey();
            List<Registro334DTO> registros334 = entry.getValue();
            log.debug("Processando dia [{}]", (Object)dataCredito);
            for (Registro334DTO dto : registros334) {
                try {
                    WebIssContaBancaria contaBancaria = this.webIssAuxiliarService.getContaBancaria(dto.getCodigoBanco(), dto.getCodigoAgencia());
                    PagamentoLote pagamentoLote = this.loteWebIssService.gravarLotePagamentoCriadoIfNotExists(contaBancaria, dataCredito);
                    this.importacaoArquivoWebIssRegistro334Service.processarDados(dto, pagamentoLote, contaBancaria);
                }
                catch (WebIssException e) {
                    log.error("Erro ao processar registro 334: [{}] - Erro: [{}]", (Object)dto, (Object)e.getErrorType());
                    this.gravarMensagemErro(dto, e.getErrorType(), e.getMessage());
                }
                catch (Exception e) {
                    log.error("Erro gen\u00e9rico ao processar o registro registro 334: [{}] - Erro: [{}]", (Object)dto, (Object)e.getMessage());
                    this.gravarMensagemErro(dto, ExceptionWebIssEnum.ERRO_GENERICO, e.getMessage());
                }
            }
            this.loteWebIssService.fecharTodosOsLotesByData(dataCredito);
        }
    }

    public void gravarMensagemErro(Registro334DTO dto, ExceptionWebIssEnum excecao, String descricaoErro) {
        dto.setInconsistencia(excecao.name());
        this.webIssProcessorService.gravarDadosWebIssRegistro334(dto);
        this.webIssLogRegistroService.gravarLog(LogRegistroWebIssDTO.from((Registro334DTO)dto, (String)descricaoErro));
    }

    @Generated
    public WebIssProcessorRegistro334Service(LoteWebIssService loteWebIssService, ImportacaoArquivoWebIssRegistro334Service importacaoArquivoWebIssRegistro334Service, WebIssProcessorService webIssProcessorService, WebIssAuxiliarService webIssAuxiliarService, WebIssLogRegistroService webIssLogRegistroService) {
        this.loteWebIssService = loteWebIssService;
        this.importacaoArquivoWebIssRegistro334Service = importacaoArquivoWebIssRegistro334Service;
        this.webIssProcessorService = webIssProcessorService;
        this.webIssAuxiliarService = webIssAuxiliarService;
        this.webIssLogRegistroService = webIssLogRegistroService;
    }
}

