/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.webiss;

import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.webiss.WebIssContaBancaria;
import br.com.elotech.tributos.dto.CadastroGeralResumidoDTO;
import br.com.elotech.tributos.enums.webiss.ExceptionWebIssEnum;
import br.com.elotech.tributos.repository.webiss.WebIssContaBancariaRepository;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.service.exception.WebIssException;
import br.com.elotech.tributos.service.webiss.GerarCadastroAvulsoWebIssService;
import br.com.elotech.tributos.service.webiss.GerarPessoaWebIssService;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WebIssAuxiliarService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebIssAuxiliarService.class);
    private final PessoaService pessoaService;
    private final CadastroGeralService cadastroGeralService;
    private final WebIssContaBancariaRepository webIssContaBancariaRepository;
    private final GerarPessoaWebIssService gerarPessoaWebIssService;
    private final GerarCadastroAvulsoWebIssService gerarCadastroAvulsoWebIssService;
    private final ParametroGeralService parametroGeralService;

    public CadastroGeralResumidoDTO findCadastroByCnpj(String cnpjCpf) {
        log.debug("Iniciando busca de cadastro para CNPJ/CPF: {}", (Object)cnpjCpf);
        Boolean geraCadastroAvulso = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.GERA_CADASTRO_AVULSO_WEBISS);
        Pessoa pessoa = this.pessoaService.findByCnpjCpf(cnpjCpf);
        pessoa = Optional.ofNullable(pessoa).orElseGet(() -> {
            if (Boolean.TRUE.equals(geraCadastroAvulso)) {
                return this.gerarPessoaWebIssService.incluirPessoa(cnpjCpf);
            }
            throw new WebIssException(ExceptionWebIssEnum.PESSOA_NAO_ENCONTRADA);
        });
        List cadastroGeralList = this.cadastroGeralService.findByPessoaCnpjCpf(cnpjCpf);
        Optional cadastroGeral = cadastroGeralList.stream().filter(c -> c.getTipoCadastro().equals((Object)TipoCadastro.MOBILIARIO)).findFirst();
        if (cadastroGeral.isEmpty()) {
            cadastroGeral = cadastroGeralList.stream().filter(c -> c.getTipoCadastro().equals((Object)TipoCadastro.AVULSO)).findFirst();
        }
        if (cadastroGeral.isEmpty()) {
            log.debug("Nenhum cadastro MOBILIARIO OU AVULSO para CNPJ/CPF: {}", (Object)cnpjCpf);
            if (Boolean.TRUE.equals(geraCadastroAvulso)) {
                cadastroGeral = this.gerarCadastroAvulso(pessoa.getId());
            }
        }
        if (cadastroGeral.isEmpty()) {
            throw new WebIssException(ExceptionWebIssEnum.CADASTRO_NAO_ENCONTRADO);
        }
        CadastroGeral cadastro = cadastroGeral.get();
        log.debug("Cadastro encontrado com sucesso para CNPJ/CPF: {}", (Object)cnpjCpf);
        return CadastroGeralResumidoDTO.from((CadastroGeral)cadastro);
    }

    public WebIssContaBancaria getContaBancaria(String codigoBanco, String codigoAgencia) {
        WebIssContaBancaria webIssContaBancaria = this.webIssContaBancariaRepository.findByCodigoBancoAndCodigoAgencia(codigoBanco, codigoAgencia);
        if (Objects.isNull(webIssContaBancaria)) {
            log.error("Banco n\u00e3o configurado para o banco [{}] e agencia [{}]", (Object)codigoBanco, (Object)codigoAgencia);
            throw new WebIssException(ExceptionWebIssEnum.BANCO_NAO_CONFIGURADO);
        }
        return webIssContaBancaria;
    }

    private Optional<CadastroGeral> gerarCadastroAvulso(Long id) {
        Pessoa pessoaToGerarCadastro = this.pessoaService.findOne(id);
        return Optional.ofNullable(this.gerarCadastroAvulsoWebIssService.gerarCadastroAvulso(pessoaToGerarCadastro));
    }

    @Generated
    public WebIssAuxiliarService(PessoaService pessoaService, CadastroGeralService cadastroGeralService, WebIssContaBancariaRepository webIssContaBancariaRepository, GerarPessoaWebIssService gerarPessoaWebIssService, GerarCadastroAvulsoWebIssService gerarCadastroAvulsoWebIssService, ParametroGeralService parametroGeralService) {
        this.pessoaService = pessoaService;
        this.cadastroGeralService = cadastroGeralService;
        this.webIssContaBancariaRepository = webIssContaBancariaRepository;
        this.gerarPessoaWebIssService = gerarPessoaWebIssService;
        this.gerarCadastroAvulsoWebIssService = gerarCadastroAvulsoWebIssService;
        this.parametroGeralService = parametroGeralService;
    }
}

