/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.webiss;

import br.com.elotech.tributos.domain.webiss.WebIssRegistro334;
import br.com.elotech.tributos.dto.webiss.Registro334DTO;
import br.com.elotech.tributos.repository.webiss.WebIssRegistro334Repository;
import br.com.elotech.tributos.service.webiss.WebIssProcessorRegistro334Service;
import br.com.elotech.tributos.util.webiss.WebIssUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ReprocessarArquivo334WebIssService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReprocessarArquivo334WebIssService.class);
    private final WebIssRegistro334Repository webIssRegistro334Repository;
    private final WebIssProcessorRegistro334Service webIssProcessorRegistro334Service;

    public void reprocessarLinhasComInconsistencias(Long idArquivo) {
        List registro334DTOList = this.getListRegistros(idArquivo);
        Map agrupadoPorDataCredito = WebIssUtils.getRegistrosAgrupados((List)registro334DTOList);
        log.debug("Lista agrupada por data credito [{}]", (Object)agrupadoPorDataCredito);
        this.webIssProcessorRegistro334Service.processarRegistro334WebIss(agrupadoPorDataCredito);
    }

    public void reprocessarByNumLinha(Long idArquivo, Long numLinha) {
        List registro334DTOList = this.getListRegistros(idArquivo, numLinha);
        Map agrupadoPorDataCredito = WebIssUtils.getRegistrosAgrupados((List)registro334DTOList);
        log.debug("Linha agrupada por data credito [{}]", (Object)agrupadoPorDataCredito);
        this.webIssProcessorRegistro334Service.processarRegistro334WebIss(agrupadoPorDataCredito);
    }

    private List<Registro334DTO> getListRegistros(Long idArquivo) {
        return this.getArquivoById(idArquivo).stream().filter(webIssRegistro334 -> Objects.isNull(webIssRegistro334.getIdDebito())).map(Registro334DTO::from).toList();
    }

    private List<Registro334DTO> getListRegistros(Long idArquivo, Long numLinha) {
        return this.getArquivoById(idArquivo).stream().filter(webIssRegistro334 -> numLinha.equals(webIssRegistro334.getNumLinha())).map(Registro334DTO::from).toList();
    }

    private List<WebIssRegistro334> getArquivoById(Long idArquivo) {
        return this.webIssRegistro334Repository.findByIdArquivo(idArquivo);
    }

    @Generated
    public ReprocessarArquivo334WebIssService(WebIssRegistro334Repository webIssRegistro334Repository, WebIssProcessorRegistro334Service webIssProcessorRegistro334Service) {
        this.webIssRegistro334Repository = webIssRegistro334Repository;
        this.webIssProcessorRegistro334Service = webIssProcessorRegistro334Service;
    }
}

