/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.webiss;

import br.com.elotech.tributos.domain.webiss.WebIssParametro;
import br.com.elotech.tributos.domain.webiss.WebIssRegistro312;
import br.com.elotech.tributos.dto.webiss.Registro312DTO;
import br.com.elotech.tributos.enums.webiss.ExceptionWebIssEnum;
import br.com.elotech.tributos.repository.webiss.WebIssParametroRepository;
import br.com.elotech.tributos.repository.webiss.WebIssRegistro312Repository;
import br.com.elotech.tributos.service.exception.WebIssException;
import br.com.elotech.tributos.service.webiss.WebIssProcessorRegistro312Service;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ReprocessarArquivo312WebIssService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReprocessarArquivo312WebIssService.class);
    private final WebIssRegistro312Repository webIssRegistro312Repository;
    private final WebIssProcessorRegistro312Service webIssProcessorRegistro312Service;
    private final WebIssParametroRepository webIssParametroRepository;
    private static final Long ID_PARAMETRO = 1L;

    public void reprocessarLinhasComInconsistencias(Long idArquivo) {
        List registro312DTOList = this.getListRegistros(idArquivo);
        this.webIssProcessorRegistro312Service.processarRegistros312WebIss(registro312DTOList, this.getParametroWebIss());
    }

    public void reprocessarByNumLinha(Long idArquivo, Long numLinha) {
        List registro312DTOList = this.getListRegistros(idArquivo, numLinha);
        this.webIssProcessorRegistro312Service.processarRegistros312WebIss(registro312DTOList, this.getParametroWebIss());
    }

    private List<Registro312DTO> getListRegistros(Long idArquivo) {
        return this.getArquivoById(idArquivo).stream().filter(webIssRegistro312 -> Objects.isNull(webIssRegistro312.getIdDebito())).map(Registro312DTO::from).toList();
    }

    private List<Registro312DTO> getListRegistros(Long idArquivo, Long numLinha) {
        return this.getArquivoById(idArquivo).stream().filter(webIssRegistro312 -> numLinha.equals(webIssRegistro312.getNumLinha())).map(Registro312DTO::from).toList();
    }

    private List<WebIssRegistro312> getArquivoById(Long idArquivo) {
        return this.webIssRegistro312Repository.findByIdArquivo(idArquivo);
    }

    private WebIssParametro getParametroWebIss() {
        return (WebIssParametro)this.webIssParametroRepository.findById((Object)ID_PARAMETRO).orElseThrow(() -> new WebIssException(ExceptionWebIssEnum.PARAMETRO_NAO_CONFIGURADO));
    }

    @Generated
    public ReprocessarArquivo312WebIssService(WebIssRegistro312Repository webIssRegistro312Repository, WebIssProcessorRegistro312Service webIssProcessorRegistro312Service, WebIssParametroRepository webIssParametroRepository) {
        this.webIssRegistro312Repository = webIssRegistro312Repository;
        this.webIssProcessorRegistro312Service = webIssProcessorRegistro312Service;
        this.webIssParametroRepository = webIssParametroRepository;
    }
}

