/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.webiss;

import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.webiss.WebIssTributo;
import br.com.elotech.tributos.dto.CadastroGeralResumidoDTO;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.webiss.CamposDebitoWebIssDTO;
import br.com.elotech.tributos.enums.webiss.ExceptionWebIssEnum;
import br.com.elotech.tributos.repository.webiss.WebIssTributoRepository;
import br.com.elotech.tributos.service.exception.WebIssException;
import br.com.elotech.tributos.service.webiss.GerarBoletoWebIssService;
import br.com.elotech.tributos.service.webiss.GerarDebitoWebIssService;
import br.com.elotech.tributos.service.webiss.LotePagamentoWebIssService;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProcessarArquivo334WebIssService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessarArquivo334WebIssService.class);
    private final GerarDebitoWebIssService gerarDebitoWebIssService;
    private final GerarBoletoWebIssService gerarBoletoWebIssService;
    private final LotePagamentoWebIssService lotePagamentoWebIssService;
    private final WebIssTributoRepository webIssTributoRepository;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public DebitoIdDTO gerarDebitoAndBoletoAndPagamento(CadastroGeralResumidoDTO cadastro, CamposDebitoWebIssDTO camposDebitoWebIssDTO, PagamentoLote pagamentoLote) {
        DebitoIdDTO debitoIdDTO = this.gerarDebito(cadastro, camposDebitoWebIssDTO);
        if (Objects.nonNull(debitoIdDTO)) {
            Bloqueto bloqueto = this.gerarBoleto(camposDebitoWebIssDTO, debitoIdDTO);
            this.realizarBaixa(bloqueto, pagamentoLote, camposDebitoWebIssDTO.getSequenciaArquivo());
        }
        if (Objects.isNull(debitoIdDTO)) {
            throw new WebIssException(ExceptionWebIssEnum.DEBITO_NAO_GERADO);
        }
        return debitoIdDTO;
    }

    private DebitoIdDTO gerarDebito(CadastroGeralResumidoDTO cadastro, CamposDebitoWebIssDTO campos) {
        WebIssTributo tributoConfig = this.webIssTributoRepository.findByTributo(campos.getTributoId());
        return this.gerarDebitoWebIssService.gerar(cadastro, campos, tributoConfig.getGuiaRecolhimento());
    }

    private Bloqueto gerarBoleto(CamposDebitoWebIssDTO campos, DebitoIdDTO debitoId) {
        Bloqueto bloqueto = this.gerarBoletoWebIssService.gerarBoleto(campos, debitoId);
        log.debug("Bloqueto gerado: {}", (Object)bloqueto);
        return bloqueto;
    }

    private void realizarBaixa(Bloqueto bloqueto, PagamentoLote pagamentoLote, Long sequenciaLote) {
        this.lotePagamentoWebIssService.baixaDebitosEBoletos(bloqueto, pagamentoLote, sequenciaLote);
    }

    @Generated
    public ProcessarArquivo334WebIssService(GerarDebitoWebIssService gerarDebitoWebIssService, GerarBoletoWebIssService gerarBoletoWebIssService, LotePagamentoWebIssService lotePagamentoWebIssService, WebIssTributoRepository webIssTributoRepository) {
        this.gerarDebitoWebIssService = gerarDebitoWebIssService;
        this.gerarBoletoWebIssService = gerarBoletoWebIssService;
        this.lotePagamentoWebIssService = lotePagamentoWebIssService;
        this.webIssTributoRepository = webIssTributoRepository;
    }
}

