/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.webiss;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.webiss.WebIssTributoOrigem;
import br.com.elotech.tributos.dto.CadastroGeralResumidoDTO;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.webiss.CamposDebitoWebIssDTO;
import br.com.elotech.tributos.repository.webiss.WebIssTributoOrigemRepository;
import br.com.elotech.tributos.service.webiss.GerarDebitoWebIssService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ProcessarArquivo312WebIssService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessarArquivo312WebIssService.class);
    private final GerarDebitoWebIssService gerarDebitoWebIssService;
    private final WebIssTributoOrigemRepository webIssTributoOrigemRepository;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public DebitoIdDTO gerarDebito(CadastroGeralResumidoDTO cadastro, CamposDebitoWebIssDTO campos) {
        WebIssTributoOrigem tributoConfig = (WebIssTributoOrigem)this.webIssTributoOrigemRepository.findByTributoAndOrigem(campos.getTributoId(), campos.getOrigemLancamento()).orElseThrow(() -> new EloValidationException(String.format("Tributo %s e Origem %s n\u00e3o possui guia de recolhimento configurada", campos.getTributoId(), campos.getOrigemLancamento())));
        return this.gerarDebitoWebIssService.gerar(cadastro, campos, tributoConfig.getGuiaRecolhimento());
    }

    @Generated
    public ProcessarArquivo312WebIssService(GerarDebitoWebIssService gerarDebitoWebIssService, WebIssTributoOrigemRepository webIssTributoOrigemRepository) {
        this.gerarDebitoWebIssService = gerarDebitoWebIssService;
        this.webIssTributoOrigemRepository = webIssTributoOrigemRepository;
    }
}

