/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.webiss;

import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.pagamento.SituacaoPagamentoLote;
import br.com.elotech.tributos.domain.webiss.WebIssContaBancaria;
import br.com.elotech.tributos.domain.webiss.WebIssLote;
import br.com.elotech.tributos.enums.webiss.ExceptionWebIssEnum;
import br.com.elotech.tributos.repository.webiss.WebIssLoteRepository;
import br.com.elotech.tributos.service.PagamentoLoteService;
import br.com.elotech.tributos.service.exception.WebIssException;
import br.com.elotech.tributos.service.webiss.LotePagamentoWebIssService;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LoteWebIssService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoteWebIssService.class);
    private final PagamentoLoteService pagamentoLoteService;
    private final LotePagamentoWebIssService lotePagamentoWebIssService;
    private final WebIssLoteRepository webIssLoteRepository;

    public boolean possuiLote(WebIssContaBancaria conta, LocalDate data) {
        WebIssLote webIssLote = this.getLoteByBancoAndAgenciaAndData(conta.getCodigoBanco(), conta.getCodigoAgencia(), data);
        return Objects.nonNull(webIssLote);
    }

    public PagamentoLote getLote(WebIssContaBancaria conta, LocalDate data) {
        WebIssLote webIssLote = this.getLoteByBancoAndAgenciaAndData(conta.getCodigoBanco(), conta.getCodigoAgencia(), data);
        if (!Objects.isNull(webIssLote)) {
            PagamentoLote pagamentoLote = this.pagamentoLoteService.findByPagamentoLote(webIssLote.getEntidade(), webIssLote.getExercicioLote(), webIssLote.getLote());
            if (pagamentoLote.getSituacao().equals((Object)SituacaoPagamentoLote.FECHADO)) {
                this.pagamentoLoteService.reabrirLote(pagamentoLote.getId().getEntidade(), pagamentoLote.getId().getExercicio(), pagamentoLote.getId().getLote());
            }
            return pagamentoLote;
        }
        return null;
    }

    public void adicionarLote(WebIssContaBancaria conta, PagamentoLote lote) {
        WebIssLote webIssLote = new WebIssLote();
        webIssLote.setCodigoBanco(conta.getCodigoBanco());
        webIssLote.setCodigoAgencia(conta.getCodigoAgencia());
        webIssLote.setEntidade(lote.getId().getEntidade());
        webIssLote.setExercicioLote(lote.getId().getExercicio());
        webIssLote.setLote(lote.getId().getLote());
        webIssLote.setData(lote.getDataLote());
        this.webIssLoteRepository.save((Object)webIssLote);
        log.debug("Lote Criado {}", (Object)webIssLote);
    }

    public WebIssLote getLoteByBancoAndAgenciaAndData(String codigoBanco, String codigoAgencia, LocalDate data) {
        Optional webIssLote = this.webIssLoteRepository.findByCodigoBancoAndCodigoAgenciaAndData(codigoBanco, codigoAgencia, data);
        return webIssLote.orElse(null);
    }

    public void fecharTodosOsLotesByData(LocalDate data) {
        List webIssLoteList = this.webIssLoteRepository.findByData(data);
        for (WebIssLote webIssLote : webIssLoteList) {
            PagamentoLote pagamentoLote = this.pagamentoLoteService.findByPagamentoLote(webIssLote.getEntidade(), webIssLote.getExercicioLote(), webIssLote.getLote());
            log.debug("Fechando Lote {}", (Object)webIssLote);
            this.pagamentoLoteService.fecharLote(pagamentoLote);
        }
    }

    public PagamentoLote gravarLotePagamentoCriadoIfNotExists(WebIssContaBancaria contaBancaria, LocalDate dataCredito) {
        PagamentoLote pagamentoLote;
        if (this.possuiLote(contaBancaria, dataCredito)) {
            pagamentoLote = this.getLote(contaBancaria, dataCredito);
        } else {
            pagamentoLote = this.lotePagamentoWebIssService.createLotePagamento(dataCredito, contaBancaria.getConvenio());
            this.adicionarLote(contaBancaria, pagamentoLote);
        }
        if (Objects.isNull(pagamentoLote)) {
            throw new WebIssException(ExceptionWebIssEnum.LOTE_NAO_ENCONTRADO);
        }
        return pagamentoLote;
    }

    @Generated
    public LoteWebIssService(PagamentoLoteService pagamentoLoteService, LotePagamentoWebIssService lotePagamentoWebIssService, WebIssLoteRepository webIssLoteRepository) {
        this.pagamentoLoteService = pagamentoLoteService;
        this.lotePagamentoWebIssService = lotePagamentoWebIssService;
        this.webIssLoteRepository = webIssLoteRepository;
    }
}

