/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.webiss;

import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.dto.pagamento.PagamentoLoteManualDTO;
import br.com.elotech.tributos.enums.webiss.ExceptionWebIssEnum;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.PagamentoLoteManualService;
import br.com.elotech.tributos.service.PagamentoService;
import br.com.elotech.tributos.service.exception.WebIssException;
import java.time.LocalDate;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class LotePagamentoWebIssService {
    private final PagamentoService pagamentoService;
    private final PagamentoLoteManualService pagamentoLoteManualService;
    private final ContextService contextService;

    public void baixaDebitosEBoletos(Bloqueto bloqueto, PagamentoLote pagamentoLote, Long sequenciaLote) {
        try {
            this.baixarItem(bloqueto, pagamentoLote, sequenciaLote);
        }
        catch (WebIssException e) {
            throw new WebIssException(ExceptionWebIssEnum.ERRO_AO_GERAR_PAGAMENTO, e.getMessage());
        }
    }

    public PagamentoLote createLotePagamento(LocalDate dataLote, Long convenio) {
        PagamentoLoteManualDTO loteManual = new PagamentoLoteManualDTO();
        loteManual.setEntidade(this.contextService.getEntidadePrincipal());
        loteManual.setExercicio(Long.valueOf(dataLote.getYear()));
        loteManual.setDataLote(dataLote);
        loteManual.setDataMovimento(dataLote);
        loteManual.setDataCredito(dataLote);
        loteManual.setConvenio(convenio);
        loteManual.setObservacao("Lote gerado pela importa\u00e7\u00e3o do arquivo de pagamentos de WEBISS");
        this.pagamentoLoteManualService.validaMovimentacaoDiaria(loteManual);
        return this.pagamentoLoteManualService.createPagamentoLote(loteManual);
    }

    private void baixarItem(Bloqueto bloqueto, PagamentoLote pagamentoLote, Long sequenciaLote) {
        bloqueto.setUtilizaValorBloqueto(Boolean.TRUE);
        this.pagamentoService.geraPagamentoBaixaGenerico(pagamentoLote, bloqueto, Boolean.TRUE, bloqueto.getUsuario(), sequenciaLote);
    }

    @Generated
    public LotePagamentoWebIssService(PagamentoService pagamentoService, PagamentoLoteManualService pagamentoLoteManualService, ContextService contextService) {
        this.pagamentoService = pagamentoService;
        this.pagamentoLoteManualService = pagamentoLoteManualService;
        this.contextService = contextService;
    }
}

