/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.webiss;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaExecucao;
import br.com.elotech.tributos.domain.tarefaassincrona.TipoTarefaAssincrona;
import br.com.elotech.tributos.domain.webiss.WebIssArquivo;
import br.com.elotech.tributos.domain.webiss.WebIssParametro;
import br.com.elotech.tributos.dto.webiss.Registro312DTO;
import br.com.elotech.tributos.dto.webiss.Registro334DTO;
import br.com.elotech.tributos.dto.webiss.RegistroWebIss;
import br.com.elotech.tributos.enums.webiss.TipoRegistroWebIss;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.webiss.DownloadArquivoWebIssService;
import br.com.elotech.tributos.service.webiss.ImportacaoArquivoWebIssRegistro312Service;
import br.com.elotech.tributos.service.webiss.ImportacaoArquivoWebIssRegistro334Service;
import br.com.elotech.tributos.service.webiss.ReprocessarArquivo312WebIssService;
import br.com.elotech.tributos.service.webiss.ReprocessarArquivo334WebIssService;
import br.com.elotech.tributos.service.webiss.WebIssArquivoService;
import br.com.elotech.tributos.service.webiss.WebIssParametroService;
import br.com.elotech.tributos.service.webiss.WebIssProcessorRegistro312Service;
import br.com.elotech.tributos.service.webiss.WebIssProcessorRegistro334Service;
import br.com.elotech.tributos.service.webiss.WebIssProcessorService;
import br.com.elotech.tributos.util.webiss.WebIssUtils;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class ImportacaoArquivoWebIssService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportacaoArquivoWebIssService.class);
    private final ImportacaoArquivoWebIssRegistro334Service importacaoArquivoWebIssRegistro334Service;
    private final ImportacaoArquivoWebIssRegistro312Service importacaoArquivoWebIssRegistro312Service;
    private final DownloadArquivoWebIssService downloadArquivoWebIssService;
    private final WebIssParametroService webIssParametroService;
    private final TarefaAssincronaService tarefaAssincronaService;
    private final WebIssProcessorService webIssProcessorService;
    private final ReprocessarArquivo334WebIssService reprocessarArquivo334WebIssService;
    private final WebIssProcessorRegistro334Service webIssProcessorRegistro334Service;
    private final WebIssArquivoService webIssArquivoService;
    private final WebIssProcessorRegistro312Service webIssProcessorRegistro312Service;
    private final ReprocessarArquivo312WebIssService reprocessarArquivo312WebIssService;
    private static final Integer QUANTIDADE_LINHA_DESCONSIDERAR = 1;

    public void reprocessarArquivo(TipoRegistroWebIss tipoRegistroWebIss, Long idArquivo) {
        if (TipoRegistroWebIss.REGISTRO_334.equals((Object)tipoRegistroWebIss)) {
            this.reprocessarArquivo334WebIssService.reprocessarLinhasComInconsistencias(idArquivo);
        }
        if (TipoRegistroWebIss.REGISTRO_312.equals((Object)tipoRegistroWebIss)) {
            this.reprocessarArquivo312WebIssService.reprocessarLinhasComInconsistencias(idArquivo);
        }
    }

    public void reprocessarLinha(TipoRegistroWebIss tipoRegistroWebIss, Long idArquivo, Long numLinha) {
        if (TipoRegistroWebIss.REGISTRO_334.equals((Object)tipoRegistroWebIss)) {
            this.reprocessarArquivo334WebIssService.reprocessarByNumLinha(idArquivo, numLinha);
        }
        if (TipoRegistroWebIss.REGISTRO_312.equals((Object)tipoRegistroWebIss)) {
            this.reprocessarArquivo312WebIssService.reprocessarByNumLinha(idArquivo, numLinha);
        }
    }

    @Async
    public void downloadArquivoPagamentoWebIss(LocalDate dataInicio, LocalDate dataFinal) {
        if (Boolean.TRUE.equals(this.verificarTarefaEmExecucao(TipoTarefaAssincrona.IMPORTACAO_DEBITOS_WEBISS, "DATA_IMPORTACAO", String.valueOf(LocalDate.now())))) {
            log.debug("Importacao dos d\u00e9bitos do Webiss do dia {} est\u00e1 em andamento.", (Object)LocalDate.now());
            return;
        }
        TarefaAssincronaExecucao tarefa = this.tarefaAssincronaService.createTarefaImportacaoDebitosWebIss(LocalDate.now());
        try {
            this.validaArquivoJaImportado(dataInicio, dataFinal, TipoRegistroWebIss.REGISTRO_334);
            List arquivoFinanceiro = this.getArquivoFromWebIss(TipoRegistroWebIss.REGISTRO_334, this.getParametroWebIss(), new LocalDate[]{dataInicio, dataFinal});
            WebIssArquivo webIssArquivo = this.salvarDadosArquivoWebIss(dataInicio, dataFinal, arquivoFinanceiro, TipoRegistroWebIss.REGISTRO_334);
            this.processarArquivoPagamentoRegistros(webIssArquivo);
            this.tarefaAssincronaService.finalizarExecucao(tarefa);
        }
        catch (Exception e) {
            String mensagemErro = String.format("Erro ao fazer o Processamento do arquivo do WEBISS. Erro: %s ", e.getMessage());
            log.error(mensagemErro, (Throwable)e);
            this.tarefaAssincronaService.marcarExecucaoComErro(tarefa, mensagemErro);
        }
    }

    @Async
    public void downloadArquivoDebitosBloqueadosWebIss(LocalDate dataBloqueio) {
        if (this.verificarTarefaEmExecucao(TipoTarefaAssincrona.IMPORTACAO_DEBITOS_BLOQUEADOS_WEBISS, "DATA_BLOQUEIO", String.valueOf(dataBloqueio)).booleanValue()) {
            log.debug("Importacao dos d\u00e9bitos bloqueados do Webiss do dia {} est\u00e1 em andamento.", (Object)dataBloqueio);
            return;
        }
        TarefaAssincronaExecucao tarefa = this.tarefaAssincronaService.createTarefaImportacaoDebitosBloqueadosWebIss(dataBloqueio);
        try {
            this.validaArquivoJaImportado(dataBloqueio, dataBloqueio, TipoRegistroWebIss.REGISTRO_312);
            WebIssParametro webIssParametro = this.getParametroWebIss();
            List arquivoFinanceiro = this.getArquivoFromWebIss(TipoRegistroWebIss.REGISTRO_312, webIssParametro, new LocalDate[]{dataBloqueio});
            WebIssArquivo webIssArquivo = this.salvarDadosArquivoWebIss(dataBloqueio, dataBloqueio, arquivoFinanceiro, TipoRegistroWebIss.REGISTRO_312);
            this.processarArquivoDebitosBloqueadosRegistros(webIssArquivo, webIssParametro);
            this.tarefaAssincronaService.finalizarExecucao(tarefa);
        }
        catch (Exception e) {
            String mensagemErro = String.format("Erro ao fazer o Processamento do arquivo do WEBISS. Erro: %s ", e.getMessage());
            log.error(mensagemErro, (Throwable)e);
            this.tarefaAssincronaService.marcarExecucaoComErro(tarefa, mensagemErro);
        }
    }

    private void validaArquivoJaImportado(LocalDate dataInicio, LocalDate dataFinal, TipoRegistroWebIss tipoRegistroWebIss) {
        if (Boolean.TRUE.equals(this.webIssArquivoService.existsArquivoImportadoByDataInicioEDataFim(dataInicio, dataFinal, tipoRegistroWebIss))) {
            throw new EloValidationException(String.format("Arquivo j\u00e1 importado com o filtro. Data In\u00edcio: %s | Data Fim: %s", dataInicio, dataFinal));
        }
    }

    public void processarArquivoPagamentoRegistros(WebIssArquivo webIssArquivo) {
        List registro334DTOList = this.carregarDadosArquivoPagamento(webIssArquivo.getId());
        Map agrupadoPorDataCredito = WebIssUtils.getRegistrosAgrupados((List)registro334DTOList);
        log.info("Lista agrupada por data credito [{}]", (Object)agrupadoPorDataCredito);
        this.webIssProcessorRegistro334Service.processarRegistro334WebIss(agrupadoPorDataCredito);
    }

    public void processarArquivoDebitosBloqueadosRegistros(WebIssArquivo webIssArquivo, WebIssParametro webIssParametro) {
        List registro312DTOList = this.carregarDadosArquivoDebitosBloqueados(webIssArquivo.getId());
        this.webIssProcessorRegistro312Service.processarRegistros312WebIss(registro312DTOList, webIssParametro);
    }

    public WebIssArquivo salvarDadosArquivoWebIss(LocalDate dataInicio, LocalDate dataFinal, List<String> arquivoFinanceiro, TipoRegistroWebIss tipoRegistroWebIss) {
        WebIssArquivo webIssArquivo = this.webIssProcessorService.inserirArquivo(dataInicio, dataFinal, Long.valueOf(arquivoFinanceiro.size() - QUANTIDADE_LINHA_DESCONSIDERAR), tipoRegistroWebIss);
        this.gravarItensArquivoWebIss(arquivoFinanceiro, webIssArquivo.getId());
        return webIssArquivo;
    }

    public List<String> getArquivoFromWebIss(TipoRegistroWebIss tipoRegistroWebIss, WebIssParametro webIssParametro, LocalDate ... datas) {
        byte[] arquivo = this.downloadArquivoWebIssService.downloadArquivoWebIss(webIssParametro.getUrlAcesso(), webIssParametro.getToken(), tipoRegistroWebIss, datas);
        return this.downloadArquivoWebIssService.extrairArquivoFinanceiro(arquivo);
    }

    public List<Registro334DTO> carregarDadosArquivoPagamento(Long idArquivo) {
        return this.importacaoArquivoWebIssRegistro334Service.getRegistrosByIdArquivo(idArquivo);
    }

    public List<Registro312DTO> carregarDadosArquivoDebitosBloqueados(Long idArquivo) {
        return this.importacaoArquivoWebIssRegistro312Service.getRegistrosByIdArquivo(idArquivo);
    }

    private Boolean verificarTarefaEmExecucao(TipoTarefaAssincrona tipoTarefaAssincrona, String chaveParametroTarefaAssincrona, String valorChaveTarefaAssincrona) {
        return this.tarefaAssincronaService.existsProcessoEmExecucao(tipoTarefaAssincrona, chaveParametroTarefaAssincrona, valorChaveTarefaAssincrona);
    }

    public void gravarItensArquivoWebIss(List<String> lista, Long idArquivo) {
        lista.forEach(s -> this.gravarDadosWebIss(s, idArquivo));
    }

    public void gravarDadosWebIss(String linha, Long idArquivo) {
        RegistroWebIss registroWebIss = this.getRegistroDtoFromLinha(linha);
        if (registroWebIss instanceof Registro334DTO) {
            Registro334DTO registro334DTO = (Registro334DTO)registroWebIss;
            log.debug("Gravando registro: {}", (Object)registro334DTO);
            registro334DTO.setIdArquivo(idArquivo);
            this.webIssProcessorService.gravarDadosWebIssRegistro334(registro334DTO);
        }
        if (registroWebIss instanceof Registro312DTO) {
            Registro312DTO registro312DTO = (Registro312DTO)registroWebIss;
            log.debug("Gravando registro: {}", (Object)registro312DTO);
            registro312DTO.setIdArquivo(idArquivo);
            this.webIssProcessorService.gravarDadosWebIssRegistro312(registro312DTO);
        }
    }

    public RegistroWebIss getRegistroDtoFromLinha(String linha) {
        return WebIssUtils.getRegistroDtoFromLinha((String)linha);
    }

    private WebIssParametro getParametroWebIss() {
        return this.webIssParametroService.getParametrosWebIss();
    }

    @Generated
    public ImportacaoArquivoWebIssService(ImportacaoArquivoWebIssRegistro334Service importacaoArquivoWebIssRegistro334Service, ImportacaoArquivoWebIssRegistro312Service importacaoArquivoWebIssRegistro312Service, DownloadArquivoWebIssService downloadArquivoWebIssService, WebIssParametroService webIssParametroService, TarefaAssincronaService tarefaAssincronaService, WebIssProcessorService webIssProcessorService, ReprocessarArquivo334WebIssService reprocessarArquivo334WebIssService, WebIssProcessorRegistro334Service webIssProcessorRegistro334Service, WebIssArquivoService webIssArquivoService, WebIssProcessorRegistro312Service webIssProcessorRegistro312Service, ReprocessarArquivo312WebIssService reprocessarArquivo312WebIssService) {
        this.importacaoArquivoWebIssRegistro334Service = importacaoArquivoWebIssRegistro334Service;
        this.importacaoArquivoWebIssRegistro312Service = importacaoArquivoWebIssRegistro312Service;
        this.downloadArquivoWebIssService = downloadArquivoWebIssService;
        this.webIssParametroService = webIssParametroService;
        this.tarefaAssincronaService = tarefaAssincronaService;
        this.webIssProcessorService = webIssProcessorService;
        this.reprocessarArquivo334WebIssService = reprocessarArquivo334WebIssService;
        this.webIssProcessorRegistro334Service = webIssProcessorRegistro334Service;
        this.webIssArquivoService = webIssArquivoService;
        this.webIssProcessorRegistro312Service = webIssProcessorRegistro312Service;
        this.reprocessarArquivo312WebIssService = reprocessarArquivo312WebIssService;
    }
}

