/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.webiss;

import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.webiss.WebIssContaBancaria;
import br.com.elotech.tributos.dto.CadastroGeralResumidoDTO;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.webiss.CamposDebitoWebIssDTO;
import br.com.elotech.tributos.dto.webiss.LogRegistroWebIssDTO;
import br.com.elotech.tributos.dto.webiss.Registro334DTO;
import br.com.elotech.tributos.enums.webiss.ExceptionWebIssEnum;
import br.com.elotech.tributos.repository.webiss.WebIssRegistro334Repository;
import br.com.elotech.tributos.service.exception.WebIssException;
import br.com.elotech.tributos.service.webiss.ProcessarArquivo334WebIssService;
import br.com.elotech.tributos.service.webiss.WebIssAuxiliarService;
import br.com.elotech.tributos.service.webiss.WebIssLogRegistroService;
import br.com.elotech.tributos.service.webiss.WebIssProcessorService;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ImportacaoArquivoWebIssRegistro334Service {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportacaoArquivoWebIssRegistro334Service.class);
    private final WebIssRegistro334Repository webIssRegistro334Repository;
    private final WebIssAuxiliarService webIssAuxiliarService;
    private final ProcessarArquivo334WebIssService processarArquivo334WebIssService;
    private final WebIssProcessorService webIssProcessorService;
    private static final Long MOTIVO_BAIXA_BANCARIA = 1L;
    private final WebIssLogRegistroService webIssLogRegistroService;

    public List<Registro334DTO> getRegistrosByIdArquivo(Long idArquivo) {
        List registros = this.webIssRegistro334Repository.findByIdArquivo(idArquivo);
        return registros.stream().map(Registro334DTO::from).collect(Collectors.toList());
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void processarDados(Registro334DTO registro334DTO, PagamentoLote pagamentoLote, WebIssContaBancaria contaBancaria) {
        try {
            log.debug("Processando linha: {}", (Object)registro334DTO);
            registro334DTO.setInconsistencia(null);
            this.validarDados(registro334DTO);
            CadastroGeralResumidoDTO cadastro = this.buscarCadastro(registro334DTO);
            DebitoIdDTO debito = this.processarArquivo334WebIssService.gerarDebitoAndBoletoAndPagamento(cadastro, CamposDebitoWebIssDTO.from((Registro334DTO)registro334DTO, (WebIssContaBancaria)contaBancaria), pagamentoLote);
            log.debug("D\u00e9bito gerado com o id: {}", (Object)debito.getIdDebito());
            registro334DTO.setIdDebito(debito.getIdDebito());
        }
        catch (WebIssException e) {
            registro334DTO.setInconsistencia(e.getErrorType().name());
            this.webIssLogRegistroService.gravarLog(LogRegistroWebIssDTO.from((Registro334DTO)registro334DTO, (String)e.getMessage()));
        }
        catch (Exception e) {
            String mensagemErro = String.format(" Erro: %s %s", e.getMessage(), registro334DTO.toString());
            log.error(mensagemErro, (Throwable)e);
            registro334DTO.setInconsistencia(ExceptionWebIssEnum.ERRO_GENERICO.name());
            this.webIssLogRegistroService.gravarLog(LogRegistroWebIssDTO.from((Registro334DTO)registro334DTO, (String)e.getMessage()));
        }
        this.webIssProcessorService.gravarDadosWebIssRegistro334(registro334DTO);
    }

    private void validarDados(Registro334DTO registro334DTO) {
        this.validaMotivoBaixaBancaria(registro334DTO);
        this.validaCompetencia(registro334DTO);
    }

    public void validaMotivoBaixaBancaria(Registro334DTO registro334DTO) {
        if (Objects.isNull(registro334DTO.getTipoMotivoBaixa()) && Objects.isNull(registro334DTO.getTipoMotivoRecusa())) {
            throw new WebIssException(ExceptionWebIssEnum.REGISTRO_SEM_MOTIVO_BAIXA_E_RECUSA);
        }
        if (!Objects.isNull(registro334DTO.getTipoMotivoBaixa()) && !registro334DTO.getTipoMotivoBaixa().equals(MOTIVO_BAIXA_BANCARIA) && Objects.isNull(registro334DTO.getTipoMotivoRecusa())) {
            throw new WebIssException(ExceptionWebIssEnum.MOTIVO_DIFERENTE_BAIXA_BANCARIA);
        }
    }

    public void validaCompetencia(Registro334DTO registro334DTO) {
        if (Objects.isNull(registro334DTO.getAnoCompetencia()) || Objects.isNull(registro334DTO.getMesCompetencia())) {
            throw new WebIssException(ExceptionWebIssEnum.ANO_OU_MES_COMPETENCIA_NULO);
        }
    }

    private CadastroGeralResumidoDTO buscarCadastro(Registro334DTO dto) {
        CadastroGeralResumidoDTO cadastro = this.webIssAuxiliarService.findCadastroByCnpj(dto.getNumDocumento());
        log.debug("Cadastro encontrado: {}", (Object)cadastro);
        return cadastro;
    }

    @Generated
    public ImportacaoArquivoWebIssRegistro334Service(WebIssRegistro334Repository webIssRegistro334Repository, WebIssAuxiliarService webIssAuxiliarService, ProcessarArquivo334WebIssService processarArquivo334WebIssService, WebIssProcessorService webIssProcessorService, WebIssLogRegistroService webIssLogRegistroService) {
        this.webIssRegistro334Repository = webIssRegistro334Repository;
        this.webIssAuxiliarService = webIssAuxiliarService;
        this.processarArquivo334WebIssService = processarArquivo334WebIssService;
        this.webIssProcessorService = webIssProcessorService;
        this.webIssLogRegistroService = webIssLogRegistroService;
    }
}

