/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.webiss;

import br.com.elotech.tributos.domain.webiss.WebIssParametro;
import br.com.elotech.tributos.dto.CadastroGeralResumidoDTO;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.webiss.CamposDebitoWebIssDTO;
import br.com.elotech.tributos.dto.webiss.LogRegistroWebIssDTO;
import br.com.elotech.tributos.dto.webiss.Registro312DTO;
import br.com.elotech.tributos.enums.webiss.ExceptionWebIssEnum;
import br.com.elotech.tributos.repository.webiss.WebIssRegistro312Repository;
import br.com.elotech.tributos.service.exception.WebIssException;
import br.com.elotech.tributos.service.webiss.ProcessarArquivo312WebIssService;
import br.com.elotech.tributos.service.webiss.WebIssAuxiliarService;
import br.com.elotech.tributos.service.webiss.WebIssLogRegistroService;
import br.com.elotech.tributos.service.webiss.WebIssProcessorService;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ImportacaoArquivoWebIssRegistro312Service {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportacaoArquivoWebIssRegistro312Service.class);
    private final WebIssRegistro312Repository webIssRegistro312Repository;
    private final WebIssAuxiliarService webIssAuxiliarService;
    private final WebIssProcessorService webIssProcessorService;
    private final ProcessarArquivo312WebIssService processarArquivo312WebIssService;
    private final WebIssLogRegistroService webIssLogRegistroService;

    public List<Registro312DTO> getRegistrosByIdArquivo(Long idArquivo) {
        List registros = this.webIssRegistro312Repository.findByIdArquivo(idArquivo);
        return registros.stream().map(Registro312DTO::from).collect(Collectors.toList());
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void processarDados(Registro312DTO registro312DTO, WebIssParametro webIssParametro) {
        try {
            log.debug("Processando linha: {}", (Object)registro312DTO);
            registro312DTO.setInconsistencia(null);
            this.validarDados(registro312DTO);
            CadastroGeralResumidoDTO cadastro = this.buscarCadastro(registro312DTO);
            DebitoIdDTO debito = this.processarArquivo312WebIssService.gerarDebito(cadastro, CamposDebitoWebIssDTO.from((Registro312DTO)registro312DTO, (Integer)webIssParametro.getDiaVencimento().intValue()));
            log.debug("D\u00e9bito gerado com o id: {}", (Object)debito.getIdDebito());
            registro312DTO.setIdDebito(debito.getIdDebito());
        }
        catch (WebIssException e) {
            registro312DTO.setInconsistencia(e.getErrorType().name());
            this.webIssLogRegistroService.gravarLog(LogRegistroWebIssDTO.from((Registro312DTO)registro312DTO, (String)e.getMessage()));
        }
        catch (Exception e) {
            String mensagemErro = String.format(" Erro: %s %s", e.getMessage(), registro312DTO.toString());
            log.error(mensagemErro, (Throwable)e);
            registro312DTO.setInconsistencia(ExceptionWebIssEnum.ERRO_GENERICO.name());
            this.webIssLogRegistroService.gravarLog(LogRegistroWebIssDTO.from((Registro312DTO)registro312DTO, (String)e.getMessage()));
        }
        this.webIssProcessorService.gravarDadosWebIssRegistro312(registro312DTO);
    }

    private void validarDados(Registro312DTO registro312DTO) {
        this.validaCompetencia(registro312DTO);
    }

    public void validaCompetencia(Registro312DTO registro312DTO) {
        if (Objects.isNull(registro312DTO.getAnoCompetencia()) || Objects.isNull(registro312DTO.getMesCompetencia())) {
            throw new WebIssException(ExceptionWebIssEnum.ANO_OU_MES_COMPETENCIA_NULO);
        }
    }

    private CadastroGeralResumidoDTO buscarCadastro(Registro312DTO dto) {
        CadastroGeralResumidoDTO cadastro = this.webIssAuxiliarService.findCadastroByCnpj(dto.getNumDocumento());
        log.debug("Cadastro encontrado: {}", (Object)cadastro);
        return cadastro;
    }

    @Generated
    public ImportacaoArquivoWebIssRegistro312Service(WebIssRegistro312Repository webIssRegistro312Repository, WebIssAuxiliarService webIssAuxiliarService, WebIssProcessorService webIssProcessorService, ProcessarArquivo312WebIssService processarArquivo312WebIssService, WebIssLogRegistroService webIssLogRegistroService) {
        this.webIssRegistro312Repository = webIssRegistro312Repository;
        this.webIssAuxiliarService = webIssAuxiliarService;
        this.webIssProcessorService = webIssProcessorService;
        this.processarArquivo312WebIssService = processarArquivo312WebIssService;
        this.webIssLogRegistroService = webIssLogRegistroService;
    }
}

