/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.webiss;

import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.webiss.WebIssParametro;
import br.com.elotech.tributos.dto.webiss.CadastroPessoaFisicaWebIssDTO;
import br.com.elotech.tributos.dto.webiss.CadastroPessoaJuridicaWebIssDTO;
import br.com.elotech.tributos.dto.webiss.ConsultaDadosDocumentoWebIssDTO;
import br.com.elotech.tributos.dto.webiss.EmailWebIssDTO;
import br.com.elotech.tributos.dto.webiss.EnderecoWebIssDTO;
import br.com.elotech.tributos.dto.webiss.TelefoneWebIssDTO;
import br.com.elotech.tributos.enums.webiss.ExceptionWebIssEnum;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.service.exception.WebIssException;
import br.com.elotech.tributos.service.webiss.DownloadArquivoWebIssService;
import br.com.elotech.tributos.service.webiss.WebIssParametroService;
import br.com.elotech.tributos.ws.rest.dto.pessoa.ContatoPessoaRequestDTO;
import br.com.elotech.tributos.ws.rest.dto.pessoa.ContatoPessoaTransportDTO;
import br.com.elotech.tributos.ws.rest.dto.pessoa.EnderecoPessoaRequestDTO;
import br.com.elotech.tributos.ws.rest.dto.pessoa.EnderecoPessoaTransportDTO;
import br.com.elotech.tributos.ws.rest.dto.pessoa.IncluirPessoaRequestDTO;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GerarPessoaWebIssService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GerarPessoaWebIssService.class);
    private final PessoaService pessoaService;
    private final WebIssParametroService webIssParametroService;
    private final DownloadArquivoWebIssService downloadArquivoWebIssService;
    private static final int TAMANHO_CPF = 11;
    private static final int TAMANHO_CNPJ = 14;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Pessoa incluirPessoa(String documento) {
        try {
            ConsultaDadosDocumentoWebIssDTO consultaDadosDocumentoWebIssDTO = this.consultarDocumentoWebIss(documento);
            Pessoa pessoa = null;
            if (documento.length() == 11) {
                pessoa = this.incluirPessoaFisica(consultaDadosDocumentoWebIssDTO);
            }
            if (documento.length() == 14) {
                pessoa = this.incluirPessoaJuridica(consultaDadosDocumentoWebIssDTO);
            }
            return pessoa;
        }
        catch (Exception e) {
            log.error("Erro ao gerar pessoa com o cnpj/Cpf [{}]. Erro: [{}]", (Object)documento, (Object)e.getMessage());
            throw new WebIssException(ExceptionWebIssEnum.ERRO_GENERICO_AO_GERAR_PESSOA, e.getMessage());
        }
    }

    private ConsultaDadosDocumentoWebIssDTO consultarDocumentoWebIss(String documento) {
        WebIssParametro webIssParametro = this.webIssParametroService.getParametrosWebIss();
        return this.downloadArquivoWebIssService.consultarDocumentoWebIss(webIssParametro.getUrlAcesso(), webIssParametro.getToken(), documento);
    }

    public Pessoa incluirPessoaFisica(ConsultaDadosDocumentoWebIssDTO consultaDadosDocumentoWebIssDTO) {
        if (Objects.isNull(consultaDadosDocumentoWebIssDTO.getPessoaFisicaWebIssDTO())) {
            log.error("A consulta de um CNPJ na API do WebIss retornou um elemento nulo ");
            throw new WebIssException(ExceptionWebIssEnum.ERRO_AO_GERAR_PESSOA);
        }
        IncluirPessoaRequestDTO incluirPessoaRequestDTO = this.buildPessoaFisicaDTO(consultaDadosDocumentoWebIssDTO);
        return this.pessoaService.incluirPessoa(incluirPessoaRequestDTO);
    }

    public Pessoa incluirPessoaJuridica(ConsultaDadosDocumentoWebIssDTO consultaDadosDocumentoWebIssDTO) {
        if (Objects.isNull(consultaDadosDocumentoWebIssDTO.getPessoaJuridicaWebIssDTO())) {
            log.error("A consulta de um CPF na API do WebIss retornou um elemento nulo.");
            throw new WebIssException(ExceptionWebIssEnum.ERRO_AO_GERAR_PESSOA);
        }
        IncluirPessoaRequestDTO incluirPessoaRequestDTO = this.buildPessoaJuridicaDTO(consultaDadosDocumentoWebIssDTO);
        return this.pessoaService.incluirPessoa(incluirPessoaRequestDTO);
    }

    private IncluirPessoaRequestDTO buildPessoaFisicaDTO(ConsultaDadosDocumentoWebIssDTO consultaDadosDocumentoWebIssDTO) {
        IncluirPessoaRequestDTO pessoaRequest = new IncluirPessoaRequestDTO();
        pessoaRequest.setTipoPessoa(TipoPessoa.FISICA);
        pessoaRequest.setCnpjCpf((String)Optional.ofNullable(consultaDadosDocumentoWebIssDTO).map(ConsultaDadosDocumentoWebIssDTO::getPessoaFisicaWebIssDTO).map(CadastroPessoaFisicaWebIssDTO::getCpf).orElse(null));
        pessoaRequest.setNome((String)Optional.ofNullable(consultaDadosDocumentoWebIssDTO).map(ConsultaDadosDocumentoWebIssDTO::getPessoaFisicaWebIssDTO).map(CadastroPessoaFisicaWebIssDTO::getNome).orElse(null));
        pessoaRequest.setEnderecos(this.buildEnderecosPessoaFisica(consultaDadosDocumentoWebIssDTO));
        pessoaRequest.setContatos(this.buildContatosPessoaFisica(consultaDadosDocumentoWebIssDTO));
        return pessoaRequest;
    }

    private IncluirPessoaRequestDTO buildPessoaJuridicaDTO(ConsultaDadosDocumentoWebIssDTO consultaDadosDocumentoWebIssDTO) {
        IncluirPessoaRequestDTO pessoaRequest = new IncluirPessoaRequestDTO();
        pessoaRequest.setTipoPessoa(TipoPessoa.JURIDICA);
        pessoaRequest.setCnpjCpf((String)Optional.ofNullable(consultaDadosDocumentoWebIssDTO).map(ConsultaDadosDocumentoWebIssDTO::getPessoaJuridicaWebIssDTO).map(CadastroPessoaJuridicaWebIssDTO::getCnpj).orElse(null));
        pessoaRequest.setNome((String)Optional.ofNullable(consultaDadosDocumentoWebIssDTO).map(ConsultaDadosDocumentoWebIssDTO::getPessoaJuridicaWebIssDTO).map(CadastroPessoaJuridicaWebIssDTO::getRazaoSocial).orElse(null));
        pessoaRequest.setNomeFantasia((String)Optional.ofNullable(consultaDadosDocumentoWebIssDTO).map(ConsultaDadosDocumentoWebIssDTO::getPessoaJuridicaWebIssDTO).map(CadastroPessoaJuridicaWebIssDTO::getNomeFantasia).orElse(null));
        pessoaRequest.setInscricaoEstadual((String)Optional.ofNullable(consultaDadosDocumentoWebIssDTO).map(ConsultaDadosDocumentoWebIssDTO::getPessoaJuridicaWebIssDTO).map(CadastroPessoaJuridicaWebIssDTO::getInscricaoEstadual).orElse(null));
        pessoaRequest.setEnderecos(this.buildEnderecosPessoaJuridica(consultaDadosDocumentoWebIssDTO));
        pessoaRequest.setContatos(this.buildContatosPessoaJuridica(consultaDadosDocumentoWebIssDTO));
        return pessoaRequest;
    }

    private EnderecoPessoaTransportDTO buildEnderecosPessoaFisica(ConsultaDadosDocumentoWebIssDTO consultaDadosDocumentoWebIssDTO) {
        List<EnderecoPessoaRequestDTO> enderecoPessoaRequestDTOList = Optional.ofNullable(consultaDadosDocumentoWebIssDTO).map(ConsultaDadosDocumentoWebIssDTO::getPessoaFisicaWebIssDTO).map(CadastroPessoaFisicaWebIssDTO::getEnderecos).orElse(Collections.emptyList()).stream().map(EnderecoWebIssDTO::toEnderecoPessoaRequestDTO).toList();
        EnderecoPessoaTransportDTO enderecoPessoaTransportDTO = new EnderecoPessoaTransportDTO();
        enderecoPessoaTransportDTO.setItems(enderecoPessoaRequestDTOList);
        return enderecoPessoaTransportDTO;
    }

    private EnderecoPessoaTransportDTO buildEnderecosPessoaJuridica(ConsultaDadosDocumentoWebIssDTO consultaDadosDocumentoWebIssDTO) {
        List<EnderecoPessoaRequestDTO> enderecoPessoaRequestDTOList = Optional.ofNullable(consultaDadosDocumentoWebIssDTO).map(ConsultaDadosDocumentoWebIssDTO::getPessoaJuridicaWebIssDTO).map(CadastroPessoaJuridicaWebIssDTO::getEnderecos).orElse(Collections.emptyList()).stream().map(EnderecoWebIssDTO::toEnderecoPessoaRequestDTO).toList();
        EnderecoPessoaTransportDTO enderecoPessoaTransportDTO = new EnderecoPessoaTransportDTO();
        enderecoPessoaTransportDTO.setItems(enderecoPessoaRequestDTOList);
        return enderecoPessoaTransportDTO;
    }

    private ContatoPessoaTransportDTO buildContatosPessoaFisica(ConsultaDadosDocumentoWebIssDTO consultaDadosDocumentoWebIssDTO) {
        String nome = Optional.ofNullable(consultaDadosDocumentoWebIssDTO).map(ConsultaDadosDocumentoWebIssDTO::getPessoaFisicaWebIssDTO).map(CadastroPessoaFisicaWebIssDTO::getNome).orElse(null);
        String email = Optional.ofNullable(consultaDadosDocumentoWebIssDTO).map(ConsultaDadosDocumentoWebIssDTO::getPessoaFisicaWebIssDTO).map(CadastroPessoaFisicaWebIssDTO::getEmails).orElse(Collections.emptyList()).stream().map(EmailWebIssDTO::getEmail).findFirst().orElse(null);
        List<ContatoPessoaRequestDTO> contatoPessoaRequestDTOList = Optional.ofNullable(consultaDadosDocumentoWebIssDTO).map(ConsultaDadosDocumentoWebIssDTO::getPessoaFisicaWebIssDTO).map(CadastroPessoaFisicaWebIssDTO::getTelefones).orElse(Collections.emptyList()).stream().map(telefoneWebIssDTO -> TelefoneWebIssDTO.toContatoPessoaRequestDTO((TelefoneWebIssDTO)telefoneWebIssDTO, (String)nome, (String)email)).toList();
        ContatoPessoaTransportDTO contatoPessoaTransportDTO = new ContatoPessoaTransportDTO();
        contatoPessoaTransportDTO.setItems(contatoPessoaRequestDTOList);
        return contatoPessoaTransportDTO;
    }

    private ContatoPessoaTransportDTO buildContatosPessoaJuridica(ConsultaDadosDocumentoWebIssDTO consultaDadosDocumentoWebIssDTO) {
        String nome = Optional.ofNullable(consultaDadosDocumentoWebIssDTO).map(ConsultaDadosDocumentoWebIssDTO::getPessoaJuridicaWebIssDTO).map(CadastroPessoaJuridicaWebIssDTO::getRazaoSocial).orElse(null);
        String email = Optional.ofNullable(consultaDadosDocumentoWebIssDTO).map(ConsultaDadosDocumentoWebIssDTO::getPessoaJuridicaWebIssDTO).map(CadastroPessoaJuridicaWebIssDTO::getEmails).orElse(Collections.emptyList()).stream().map(EmailWebIssDTO::getEmail).findFirst().orElse(null);
        List<ContatoPessoaRequestDTO> contatoPessoaRequestDTOList = Optional.ofNullable(consultaDadosDocumentoWebIssDTO).map(ConsultaDadosDocumentoWebIssDTO::getPessoaJuridicaWebIssDTO).map(CadastroPessoaJuridicaWebIssDTO::getTelefones).orElse(Collections.emptyList()).stream().map(telefoneWebIssDTO -> TelefoneWebIssDTO.toContatoPessoaRequestDTO((TelefoneWebIssDTO)telefoneWebIssDTO, (String)nome, (String)email)).toList();
        ContatoPessoaTransportDTO contatoPessoaTransportDTO = new ContatoPessoaTransportDTO();
        contatoPessoaTransportDTO.setItems(contatoPessoaRequestDTOList);
        return contatoPessoaTransportDTO;
    }

    @Generated
    public GerarPessoaWebIssService(PessoaService pessoaService, WebIssParametroService webIssParametroService, DownloadArquivoWebIssService downloadArquivoWebIssService) {
        this.pessoaService = pessoaService;
        this.webIssParametroService = webIssParametroService;
        this.downloadArquivoWebIssService = downloadArquivoWebIssService;
    }
}

