/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.webiss;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Divida;
import br.com.elotech.tributos.domain.DividaTributo;
import br.com.elotech.tributos.dto.CadastroGeralResumidoDTO;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.DebitoManualDTO;
import br.com.elotech.tributos.dto.DebitoManualObservacaoDTO;
import br.com.elotech.tributos.dto.DebitoManualParcelaDTO;
import br.com.elotech.tributos.dto.DebitoManualTributoDTO;
import br.com.elotech.tributos.dto.webiss.CamposDebitoWebIssDTO;
import br.com.elotech.tributos.enums.webiss.ExceptionWebIssEnum;
import br.com.elotech.tributos.repository.webiss.WebIssTributoRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DividaService;
import br.com.elotech.tributos.service.GeraDebitoService;
import br.com.elotech.tributos.service.exception.WebIssException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class GerarDebitoWebIssService {
    private final WebIssTributoRepository webIssTributoRepository;
    private final DividaService dividaService;
    private final GeraDebitoService geraDebitoService;
    private final ContextService contextService;

    public DebitoIdDTO gerar(CadastroGeralResumidoDTO cadastro, CamposDebitoWebIssDTO campos, Long divida) {
        if (Objects.isNull(divida)) {
            throw new EloValidationException("Div\u00edda n\u00e3o cadastrada para gera\u00e7\u00e3o de d\u00e9bito do WEBISS");
        }
        Long exercicio = campos.getAnoCompetencia();
        DividaTributo dividaTributo = (DividaTributo)this.getDividaTributo(divida, exercicio).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o tributo padr\u00e3o da d\u00edvida %d/%d.", divida, exercicio)));
        DebitoManualDTO debitoManualDTO = this.montarDebitoManual(cadastro, campos, dividaTributo);
        return this.geraDebitoService.geraDebitoManual(debitoManualDTO);
    }

    public Optional<DividaTributo> getDividaTributo(Long dividaId, Long exercicio) {
        Long entidade = this.contextService.getEntidadePrincipal();
        Divida divida = (Divida)this.dividaService.findByEntidadeAndExercicioAndDivida(entidade, exercicio, dividaId).orElseThrow(() -> new WebIssException(ExceptionWebIssEnum.RECEITA_PADRAO_NAO_CONFIGURADA));
        return divida.getTributos().stream().filter(DividaTributo::getReceitaPadrao).findFirst();
    }

    private DebitoManualDTO montarDebitoManual(CadastroGeralResumidoDTO cadastro, CamposDebitoWebIssDTO campos, DividaTributo dividaTributo) {
        BigDecimal valorDebito = this.getValorDebitoWebIss(campos);
        DebitoManualTributoDTO tributo = this.getTributoDebitoManual(valorDebito, dividaTributo);
        DebitoManualParcelaDTO parcela = this.getParcelaDebitoManual(campos, valorDebito);
        DebitoManualObservacaoDTO observacao = this.getObservacaoDebitoManual(campos);
        DebitoManualDTO dto = new DebitoManualDTO();
        dto.setExercicio(campos.getAnoCompetencia());
        dto.setDataLancamento(LocalDate.now());
        dto.setDivida(dividaTributo.getDivida().getDivida());
        dto.setTipoCadastro(cadastro.getTipoCadastro());
        dto.setCadastroGeral(cadastro.getCadastroGeral());
        dto.setPrograma("IntegracaoWEBISS");
        dto.setValidaPermissaoDivida(Boolean.valueOf(false));
        dto.getTributos().add(tributo);
        dto.getParcelas().add(parcela);
        dto.getObservacoes().add(observacao);
        return dto;
    }

    public DebitoManualParcelaDTO getParcelaDebitoManual(CamposDebitoWebIssDTO campos, BigDecimal valor) {
        DebitoManualParcelaDTO parcela = new DebitoManualParcelaDTO();
        parcela.setParcela(Long.valueOf(1L));
        parcela.setDataVencimento(campos.getDataVencimento());
        parcela.setValor(valor);
        parcela.setAnoReferencia(campos.getAnoCompetencia());
        parcela.setMesReferencia(campos.getMesCompetencia());
        return parcela;
    }

    public DebitoManualTributoDTO getTributoDebitoManual(BigDecimal valor, DividaTributo dividaTributo) {
        DebitoManualTributoDTO tributo = new DebitoManualTributoDTO();
        tributo.setTributo(dividaTributo.getTributo().getTributo());
        tributo.setOrdem(dividaTributo.getOrdem());
        tributo.setValorTributo(valor);
        return tributo;
    }

    public BigDecimal getValorDebitoWebIss(CamposDebitoWebIssDTO campos) {
        if (Objects.nonNull(campos.getTipoMotivoRecusa())) {
            return campos.getValorTotalPago();
        }
        return campos.getValorPrincipal();
    }

    public DebitoManualObservacaoDTO getObservacaoDebitoManual(CamposDebitoWebIssDTO campos) {
        DebitoManualObservacaoDTO observacao = new DebitoManualObservacaoDTO();
        observacao.setObservacao(campos.getObservacao());
        return observacao;
    }

    @Generated
    public GerarDebitoWebIssService(WebIssTributoRepository webIssTributoRepository, DividaService dividaService, GeraDebitoService geraDebitoService, ContextService contextService) {
        this.webIssTributoRepository = webIssTributoRepository;
        this.dividaService = dividaService;
        this.geraDebitoService = geraDebitoService;
        this.contextService = contextService;
    }
}

