/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.webiss;

import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.enums.webiss.ExceptionWebIssEnum;
import br.com.elotech.tributos.service.CadastroAvulsoService;
import br.com.elotech.tributos.service.exception.WebIssException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GerarCadastroAvulsoWebIssService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GerarCadastroAvulsoWebIssService.class);
    private final CadastroAvulsoService cadastroAvulsoService;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public CadastroGeral gerarCadastroAvulso(Pessoa pessoa) {
        try {
            return this.cadastroAvulsoService.newCadastroAvulsoByPessoa(pessoa);
        }
        catch (Exception e) {
            log.error("Erro ao gerar cadastro avulso para a pessoa: [{}]. Erro: [{}]", (Object)pessoa, (Object)e.getMessage());
            throw new WebIssException(ExceptionWebIssEnum.ERRO_AO_GERAR_CADASTRO_AVULSO, e.getMessage());
        }
    }

    @Generated
    public GerarCadastroAvulsoWebIssService(CadastroAvulsoService cadastroAvulsoService) {
        this.cadastroAvulsoService = cadastroAvulsoService;
    }
}

