/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.webiss;

import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.ModeloBoleto;
import br.com.elotech.tributos.domain.OrigemEmissao;
import br.com.elotech.tributos.domain.TipoBloqueto;
import br.com.elotech.tributos.domain.webiss.WebIssParametro;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.DebitoParcelaDTO;
import br.com.elotech.tributos.dto.GeraBoletoWebIssDTO;
import br.com.elotech.tributos.dto.webiss.CamposDebitoWebIssDTO;
import br.com.elotech.tributos.enums.webiss.ExceptionWebIssEnum;
import br.com.elotech.tributos.repository.webiss.WebIssParametroRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.GeraBoletoService;
import br.com.elotech.tributos.service.ModeloBoletoService;
import br.com.elotech.tributos.service.exception.WebIssException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Objects;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class GerarBoletoWebIssService {
    private final WebIssParametroRepository parametroRepository;
    private final ModeloBoletoService modeloBoletoService;
    private final DebitoService debitoService;
    private final GeraBoletoService geraBoletoService;
    private final EntityManager entityManager;
    private final ContextService contextService;
    private static final Long ID_PARAMETRO = 1L;

    public Bloqueto gerarBoleto(CamposDebitoWebIssDTO campos, DebitoIdDTO debitoId) {
        WebIssParametro param = this.getParametroWebIss();
        ModeloBoleto modelo = this.getModeloBoleto(param.getModeloBloquetoPadrao());
        Debito debito = this.getDebitoGeradoWebIss(debitoId);
        GeraBoletoWebIssDTO dto = new GeraBoletoWebIssDTO();
        dto.setTipoBoleto(TipoBloqueto.PARCELADO);
        dto.setOrigemEmissao(OrigemEmissao.WEBISS);
        dto.setDebitos(Collections.singletonList(DebitoParcelaDTO.fromUltimaParcelaDebito((Debito)debito)));
        dto.setUsuario("IntegracaoWEBISS");
        dto.setExercicio(debito.getExercicio());
        dto.setModeloBoleto(modelo);
        dto.setDataVencimento(campos.getDataVencimento());
        dto.setUsaExercicioEspecificado(Boolean.valueOf(true));
        dto.setObservacao(String.format("Boleto referente ao d\u00e9bito %d da integra\u00e7\u00e3o de d\u00e9bitos do WEBISS", debito.getId()));
        dto.setValorJuros(campos.getValorJuros());
        dto.setValorMulta(campos.getValorMulta());
        dto.setValorCorrecao(campos.getValorAtualizacaoMonetaria());
        dto.setDataReferencia(this.contextService.getDataAtual());
        dto.setPossuiMotivoRecusa(Boolean.valueOf(Objects.nonNull(campos.getTipoMotivoRecusa())));
        Bloqueto boleto = (Bloqueto)this.geraBoletoService.geraBoletoWebIss(dto).getFirst();
        this.entityManager.flush();
        return boleto;
    }

    public Debito getDebitoGeradoWebIss(DebitoIdDTO debitoId) {
        return (Debito)this.debitoService.findByCompositeKey(debitoId.getEntidade(), debitoId.getExercicio(), debitoId.getTipoCadastro(), debitoId.getCadastroGeral(), debitoId.getDivida(), debitoId.getSubDivida()).orElseThrow(() -> new WebIssException(ExceptionWebIssEnum.ERRO_AO_ENCONTRAR_DEBITO_DE_ORIGEM));
    }

    public ModeloBoleto getModeloBoleto(Long modeloBloqueto) {
        return (ModeloBoleto)this.modeloBoletoService.findOne((Serializable)modeloBloqueto);
    }

    public WebIssParametro getParametroWebIss() {
        return (WebIssParametro)this.parametroRepository.findById((Object)ID_PARAMETRO).orElseThrow(() -> new WebIssException(ExceptionWebIssEnum.PARAMETRO_NAO_CONFIGURADO));
    }

    @Generated
    public GerarBoletoWebIssService(WebIssParametroRepository parametroRepository, ModeloBoletoService modeloBoletoService, DebitoService debitoService, GeraBoletoService geraBoletoService, EntityManager entityManager, ContextService contextService) {
        this.parametroRepository = parametroRepository;
        this.modeloBoletoService = modeloBoletoService;
        this.debitoService = debitoService;
        this.geraBoletoService = geraBoletoService;
        this.entityManager = entityManager;
        this.contextService = contextService;
    }
}

