/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.webiss;

import br.com.elotech.tributos.dto.webiss.ConsultaDadosDocumentoWebIssDTO;
import br.com.elotech.tributos.enums.webiss.ExceptionWebIssEnum;
import br.com.elotech.tributos.enums.webiss.TipoRegistroWebIss;
import br.com.elotech.tributos.service.exception.WebIssException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class DownloadArquivoWebIssService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DownloadArquivoWebIssService.class);
    private static final String NOME_ARQUIVO_FINANCEIRO = "Financeiro.txt";
    private static final String DELIMITADOR = "/";
    private static final String DATETIMEFORMATTER_ANO_MES_DIA = "yyyy-MM-dd";
    private static final String SERVICO_INTEGRACAO = "/ws/integracao/";
    private static final String SERVICO_CADASTRO = "/api/dados/consultar/";
    private final RestTemplate restTemplate;

    public String buildUrlConsultaDocumento(String urlBase, String documento) {
        return urlBase + SERVICO_CADASTRO + documento;
    }

    public String buildUrlConsulta(String urlBase, TipoRegistroWebIss tipoRegistroWebIss, LocalDate ... datas) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(DATETIMEFORMATTER_ANO_MES_DIA);
        String datasFormatadas = Arrays.stream(datas).map(d -> d.format(formatter)).collect(Collectors.joining(DELIMITADOR));
        return urlBase + SERVICO_INTEGRACAO + tipoRegistroWebIss.getDescricao() + DELIMITADOR + datasFormatadas;
    }

    public byte[] downloadArquivoWebIss(String urlBase, String token, TipoRegistroWebIss tipoRegistroWebIss, LocalDate ... datas) {
        String url = this.buildUrlConsulta(urlBase, tipoRegistroWebIss, datas);
        log.info("Url de consulta {}", (Object)url);
        byte[] zipBytes = this.fazerDownloadZip(url, token);
        if (zipBytes == null) {
            throw new RuntimeException("N\u00e3o foi poss\u00edvel baixar o arquivo ZIP.");
        }
        return zipBytes;
    }

    public ConsultaDadosDocumentoWebIssDTO consultarDocumentoWebIss(String urlBase, String token, String documento) {
        String url = this.buildUrlConsultaDocumento(urlBase, documento);
        log.info("Url de consulta de dados {}", (Object)url);
        return this.getDadosDocumentoFromWebIss(url, token);
    }

    public List<String> extrairArquivoFinanceiro(byte[] arquivo) {
        return this.extrairFinanceiroTxt(arquivo);
    }

    private byte[] fazerDownloadZip(String url, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Autenticacao", token);
        headers.setAccept(List.of(MediaType.APPLICATION_OCTET_STREAM));
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, byte[].class, new Object[0]);
        if (response.getStatusCode() == HttpStatus.OK && response.getBody() != null) {
            return (byte[])response.getBody();
        }
        return null;
    }

    private ConsultaDadosDocumentoWebIssDTO getDadosDocumentoFromWebIss(String url, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Autenticacao", token);
        headers.setAccept(List.of(MediaType.APPLICATION_JSON));
        HttpEntity requestEntity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, ConsultaDadosDocumentoWebIssDTO.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK && response.getBody() != null) {
                return (ConsultaDadosDocumentoWebIssDTO)response.getBody();
            }
            log.debug("Status retornado diferente de OK ou resposta nula. Status retornado: [{}]", (Object)response.getStatusCode());
            throw new WebIssException(ExceptionWebIssEnum.ERRO_AO_EXECUTAR_REQUISICAO_DADOS);
        }
        catch (RestClientException ex) {
            log.debug("Erro ao realizar comunica\u00e7\u00e3o com WebIss. Erro [{}]", (Object)ex.getMessage());
            throw new WebIssException(ExceptionWebIssEnum.ERRO_AO_REALIZAR_COMUNICACAO, ex.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> extrairFinanceiroTxt(byte[] zipBytes) {
        if (Objects.isNull(zipBytes)) {
            throw new RuntimeException("Arquivo ZIP vazio.");
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(zipBytes);
             ZipArchiveInputStream zis = new ZipArchiveInputStream((InputStream)bais, "UTF-8", false);){
            String fileName;
            ZipArchiveEntry entry;
            do {
                if ((entry = zis.getNextZipEntry()) == null) throw new RuntimeException("Arquivo Financeiro.txt n\u00e3o encontrado no ZIP.");
            } while (entry.isDirectory() || !NOME_ARQUIVO_FINANCEIRO.equalsIgnoreCase(fileName = Paths.get(entry.getName(), new String[0]).getFileName().toString()));
            List list = this.lerLinhasDoArquivo((InputStream)zis);
            return list;
        }
        catch (IOException e) {
            throw new RuntimeException("Erro ao processar o arquivo ZIP", e);
        }
    }

    private List<String> lerLinhasDoArquivo(InputStream is) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            List<String> list = reader.lines().collect(Collectors.toList());
            return list;
        }
    }

    @Generated
    public DownloadArquivoWebIssService(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}

