/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.webiss;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.dto.EnderecoCorrespondenciaDTO;
import br.com.elotech.tributos.dto.webiss.CadastroPessoaJuridicaWebIssDTO;
import br.com.elotech.tributos.service.CadastroMobiliarioService;
import br.com.elotech.tributos.service.EnderecoCorrespondenciaService;
import br.com.elotech.tributos.service.ParametroGeralService;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CadastroMobiliarioWebIssService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CadastroMobiliarioWebIssService.class);
    private final CadastroMobiliarioService cadastroMobiliarioService;
    private final EnderecoCorrespondenciaService enderecoCorrespondenciaService;
    private final ParametroGeralService parametroGeralService;

    public List<CadastroPessoaJuridicaWebIssDTO> findCadastroMobiliarioByCnpj(String cnpjCpf) {
        List cadastroMobiliarioList = this.cadastroMobiliarioService.findByCnpj(cnpjCpf);
        if ((cadastroMobiliarioList = this.filterCadastrosMobiliarios(cadastroMobiliarioList)).isEmpty()) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel localizar o Cadastro Mobili\u00e1rio com o Cnpj %s.", cnpjCpf));
        }
        return cadastroMobiliarioList.stream().map(cadastroMobiliario -> {
            EnderecoCorrespondenciaDTO enderecoCorrespondenciaDTO = this.enderecoCorrespondenciaService.findEnderecoCorrespondenciaByIdAndTipo(cadastroMobiliario.getId(), cadastroMobiliario.getTipoEnderecoCorrespondencia());
            return CadastroPessoaJuridicaWebIssDTO.from((CadastroMobiliario)cadastroMobiliario, (EnderecoCorrespondenciaDTO)enderecoCorrespondenciaDTO);
        }).toList();
    }

    public List<String> findCadastroGeralAlteradosWebIss(LocalDateTime dataHoraInicial, LocalDateTime dataHoraFinal) {
        List cadastroMobiliarioList = this.cadastroMobiliarioService.findCnpjsPorPeriodo(dataHoraInicial, dataHoraFinal);
        cadastroMobiliarioList = this.filterCadastrosMobiliarios(cadastroMobiliarioList);
        return cadastroMobiliarioList.stream().map(CadastroGeral::getPessoa).map(Pessoa::getCnpjCpf).filter(Objects::nonNull).distinct().toList();
    }

    public List<CadastroMobiliario> filterCadastrosMobiliarios(List<CadastroMobiliario> cadastroMobiliarios) {
        if (Boolean.FALSE.equals(this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.MULTIPLOS_CADASTROS_MOBILIARIOS_POR_CNPJ, ModuloEnum.MODULO_TRIBUTARIO.getValue()))) {
            return cadastroMobiliarios;
        }
        Long campo = this.parametroGeralService.getParamValueAsLong(ParametroGeralEnum.CAMPO_RESPOSTA_BOLETIM_IGNORAR_WEBISS, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        return cadastroMobiliarios.stream().filter(cadastro -> this.deveRetornarCadastro(cadastro, campo, this.getListAlternativasIgnorar())).toList();
    }

    private boolean deveRetornarCadastro(CadastroMobiliario cadastro, Long campo, List<Long> alternativasIgnorar) {
        return cadastro.getRespostasMobiliarios().stream().anyMatch(r -> Objects.equals(r.getCampo().getCodigo(), campo) && !alternativasIgnorar.contains(r.getAlternativa().getCodigo()));
    }

    public List<Long> getListAlternativasIgnorar() {
        String alternativas = this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.ALTERNATIVAS_BOLETIM_IGNORAR_WEBISS, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        return Arrays.stream(alternativas.trim().split("\\s*;\\s*")).map(Long::valueOf).toList();
    }

    @Generated
    public CadastroMobiliarioWebIssService(CadastroMobiliarioService cadastroMobiliarioService, EnderecoCorrespondenciaService enderecoCorrespondenciaService, ParametroGeralService parametroGeralService) {
        this.cadastroMobiliarioService = cadastroMobiliarioService;
        this.enderecoCorrespondenciaService = enderecoCorrespondenciaService;
        this.parametroGeralService = parametroGeralService;
    }
}

