/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.unico;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.json.update.JsonUpdateOperation;
import br.com.elotech.core.json.update.JsonUpdatePartial;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.dto.CidadeDTO;
import br.com.elotech.tributos.repository.PessoaRepository;
import br.com.elotech.tributos.service.BairroService;
import br.com.elotech.tributos.service.CidadeService;
import br.com.elotech.tributos.service.LogradouroService;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.service.unico.PessoaClientUnico;
import br.com.elotech.tributos.util.ConvertToUpperCase;
import br.com.elotech.tributos.ws.rest.dto.pessoa.IncluirPessoaRequestDTO;
import br.com.elotech.unico.client.dto.BairroDTO;
import br.com.elotech.unico.client.dto.ContatoDTO;
import br.com.elotech.unico.client.dto.LogradouroDTO;
import br.com.elotech.unico.client.dto.PessoaContatoDTO;
import br.com.elotech.unico.client.dto.PessoaDTO;
import br.com.elotech.unico.client.dto.PessoaEnderecoDTO;
import br.com.elotech.unico.client.dto.PessoaRg;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class PessoaServiceUnico
extends CrudService<Pessoa, Long>
implements PessoaService {
    private final PessoaRepository pessoaRepository;
    private final CidadeService cidadeService;
    private final LogradouroService logradouroService;
    private final BairroService bairroService;
    private final PessoaClientUnico pessoaClient;

    public PessoaServiceUnico(PessoaRepository pessoaRepository, CidadeService cidadeService, LogradouroService logradouroService, BairroService bairroService, PessoaClientUnico pessoaClient) {
        this.pessoaRepository = pessoaRepository;
        this.cidadeService = cidadeService;
        this.logradouroService = logradouroService;
        this.bairroService = bairroService;
        this.pessoaClient = pessoaClient;
    }

    public Pessoa findByCnpjCpf(String cnpjCpf) {
        return this.pessoaRepository.findByCnpjCpfAndInativo(cnpjCpf, Boolean.valueOf(false)).stream().min(Comparator.comparing(Pessoa::getId)).orElse(null);
    }

    public Pessoa findAllByCnpjCpf(String cnpjCpf) {
        return this.pessoaRepository.findByCnpjCpf(cnpjCpf).stream().findFirst().orElse(null);
    }

    public Pessoa incluirPessoa(IncluirPessoaRequestDTO incluirPessoaRequestDTO) {
        return this.buscarOuCriaPessoa(incluirPessoaRequestDTO);
    }

    private Pessoa buscarOuCriaPessoa(IncluirPessoaRequestDTO incluirPessoaRequestDTO) {
        ConvertToUpperCase.convert((Object)incluirPessoaRequestDTO);
        Pessoa pessoaTributo = this.findByCnpjCpf(incluirPessoaRequestDTO.getCnpjCpf());
        if (Objects.nonNull(pessoaTributo)) {
            return pessoaTributo;
        }
        Optional pessoaUnico = this.pessoaClient.getPessoaByCnpjCpfAndAtivo(incluirPessoaRequestDTO.getCnpjCpf());
        if (pessoaUnico.isPresent()) {
            PessoaDTO pessoaUnicoDTO = this.pessoaClient.ativaContribuinte(((PessoaDTO)pessoaUnico.get()).getId());
            return (Pessoa)this.pessoaRepository.findByIdUnico(pessoaUnicoDTO.getId()).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel ativar o contribuinte atrav\u00e9s do \u00danico %d", pessoaUnicoDTO.getId())));
        }
        PessoaDTO novaPessoa = this.incluirPessoaUnico(incluirPessoaRequestDTO);
        return (Pessoa)this.pessoaRepository.findByIdUnico(novaPessoa.getId()).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel incluir o contribuinte atrav\u00e9s do \u00danico %d", novaPessoa.getId())));
    }

    private PessoaDTO incluirPessoaUnico(IncluirPessoaRequestDTO incluirPessoaRequestDTO) {
        PessoaDTO novaPessoa = new PessoaDTO();
        if (Objects.nonNull(incluirPessoaRequestDTO.getTipoPessoa())) {
            novaPessoa.setTipoPessoa(incluirPessoaRequestDTO.getTipoPessoa().getValue());
        }
        novaPessoa.setCnpjCpf(incluirPessoaRequestDTO.getCnpjCpf());
        novaPessoa.setNomeFantasia(incluirPessoaRequestDTO.getNomeFantasia());
        novaPessoa.setNome(incluirPessoaRequestDTO.getNome());
        novaPessoa.setContribuinte(Boolean.TRUE);
        if (!incluirPessoaRequestDTO.getContatos().getItems().isEmpty()) {
            List contatos = this.getPessoaContatosDTO(incluirPessoaRequestDTO);
            novaPessoa.setContatos(contatos);
        }
        if (!incluirPessoaRequestDTO.getEnderecos().getItems().isEmpty()) {
            List enderecos = this.getPessoaEnderecosDTO(incluirPessoaRequestDTO);
            novaPessoa.setEnderecos(enderecos);
        }
        if (StringUtils.isNotBlank((CharSequence)incluirPessoaRequestDTO.getRg())) {
            PessoaRg rg = new PessoaRg();
            rg.setOrgaoEmissor(String.format("%s %s", incluirPessoaRequestDTO.getOrgaoEmissor(), incluirPessoaRequestDTO.getEstadoEmissor()));
            rg.setDataEmissao(incluirPessoaRequestDTO.getDataEmissao());
            rg.setNumero(incluirPessoaRequestDTO.getRg());
            novaPessoa.setRg(rg);
        }
        return this.pessoaClient.savePessoa(novaPessoa);
    }

    private List<PessoaContatoDTO> getPessoaContatosDTO(IncluirPessoaRequestDTO incluirPessoaRequestDTO) {
        return incluirPessoaRequestDTO.getContatos().getItems().stream().map(contato -> {
            PessoaContatoDTO pessoaContatoDTO = new PessoaContatoDTO();
            pessoaContatoDTO.setPrincipal(Boolean.FALSE);
            ContatoDTO contatoDTO = new ContatoDTO();
            contatoDTO.setEmail(contato.getEmail());
            contatoDTO.setNome(contato.getNome());
            contatoDTO.setTelefoneComercial(contato.getTelefoneComercial());
            contatoDTO.setTelefoneFax(contato.getTelefoneFax());
            contatoDTO.setTelefoneResidencial(contato.getTelefoneResidencial());
            contatoDTO.setTelefoneCelular(contato.getTelefoneCelular());
            contatoDTO.setHomePage(contato.getHomePage());
            pessoaContatoDTO.setContato(contatoDTO);
            return pessoaContatoDTO;
        }).collect(Collectors.toList());
    }

    private List<PessoaEnderecoDTO> getPessoaEnderecosDTO(IncluirPessoaRequestDTO incluirPessoaRequestDTO) {
        return incluirPessoaRequestDTO.getEnderecos().getItems().stream().map(enderecoPessoaRequestDTO -> {
            PessoaEnderecoDTO enderecoDTO = new PessoaEnderecoDTO();
            if (StringUtils.isNotBlank((CharSequence)enderecoPessoaRequestDTO.getCep())) {
                enderecoDTO.getEndereco().setCep(Long.valueOf(enderecoPessoaRequestDTO.getCep().replaceAll("\\D+", "")));
            }
            enderecoDTO.getEndereco().setNumero(enderecoPessoaRequestDTO.getNumero());
            enderecoDTO.getEndereco().setComplemento(enderecoPessoaRequestDTO.getComplemento());
            Optional cidade = this.cidadeService.buscaOuCriaCidade(CidadeDTO.builder().id(enderecoPessoaRequestDTO.getCodigoCidade()).descricao(enderecoPessoaRequestDTO.getCidade()).uf(enderecoPessoaRequestDTO.getUnidadeFederacao()).build());
            if (cidade.isPresent()) {
                br.com.elotech.unico.client.dto.CidadeDTO cidadeUnicoDTO = new br.com.elotech.unico.client.dto.CidadeDTO();
                cidadeUnicoDTO.setId(((Cidade)cidade.get()).getIdUnico());
                enderecoDTO.getEndereco().setCidade(cidadeUnicoDTO);
                Optional bairro = this.bairroService.buscaOuCriaBairro(br.com.elotech.tributos.dto.BairroDTO.builder().id(enderecoPessoaRequestDTO.getCodigoBairro()).idCidade(((Cidade)cidade.get()).getId()).descricao(enderecoPessoaRequestDTO.getBairro()).idCidadeUnico(((Cidade)cidade.get()).getIdUnico()).build());
                bairro.ifPresent(bairroAise -> {
                    BairroDTO bairroUnicoDTO = new BairroDTO();
                    bairroUnicoDTO.setId(bairroAise.getIdunico());
                    enderecoDTO.getEndereco().setBairro(bairroUnicoDTO);
                });
                Optional logradouro = this.logradouroService.buscaOuCriaLogradouro(br.com.elotech.tributos.dto.LogradouroDTO.builder().id(enderecoPessoaRequestDTO.getCodigoLogradouro()).idCidade(((Cidade)cidade.get()).getId()).descricao(enderecoPessoaRequestDTO.getLogradouro()).idCidadeUnico(((Cidade)cidade.get()).getIdUnico()).build());
                logradouro.ifPresent(logradouroAise -> {
                    LogradouroDTO logradouroDTO = new LogradouroDTO();
                    logradouroDTO.setId(logradouroAise.getIdunico());
                    enderecoDTO.getEndereco().setLogradouro(logradouroDTO);
                });
            }
            return enderecoDTO;
        }).filter(endereco -> Objects.nonNull(endereco.getEndereco().getBairro()) && Objects.nonNull(endereco.getEndereco().getCidade()) && Objects.nonNull(endereco.getEndereco().getLogradouro())).collect(Collectors.toList());
    }

    public void alterarRgPessoa(Pessoa pessoa, br.com.elotech.tributos.dto.PessoaDTO pessoaDTO) {
    }

    public Pessoa alterarEnderecoPessoa(br.com.elotech.tributos.dto.PessoaDTO pessoaDTO) {
        ConvertToUpperCase.convert((Object)pessoaDTO);
        PessoaDTO pessoaUnicoDTO = this.buscarPessoaNoUnico(pessoaDTO.getCnpjCpf());
        Long id = pessoaUnicoDTO.getId();
        List novosEnderecos = this.obterEnderecosValidos(pessoaDTO);
        this.ativarContribuinte(id);
        try {
            ObjectMapper mapper = new ObjectMapper();
            if (novosEnderecos.isEmpty()) {
                throw new EloValidationException("Lista de endere\u00e7os est\u00e1 vazia");
            }
            PessoaEnderecoDTO primeiroEndereco = (PessoaEnderecoDTO)novosEnderecos.get(0);
            String jsonEndereco = mapper.writeValueAsString((Object)primeiroEndereco);
            JsonUpdatePartial patchEndereco = this.criarPatchReplace("/enderecos", jsonEndereco);
            PessoaDTO response = this.pessoaClient.patchPessoa(id, List.of(patchEndereco));
            return this.obterPessoaLocalOuErro(response.getId());
        }
        catch (JsonProcessingException e) {
            throw new EloValidationException(String.format("Erro ao serializar endere\u00e7os para JSON: %s ", new Object[]{e}));
        }
    }

    private PessoaDTO buscarPessoaNoUnico(String cnpjCpf) {
        return (PessoaDTO)this.pessoaClient.getPessoaByCnpjCpfAndAtivo(cnpjCpf).orElseThrow(() -> new EloValidationException("Pessoa n\u00e3o encontrada no servi\u00e7o \u00danico para o CNPJ/CPF informado."));
    }

    private JsonUpdatePartial criarPatchReplace(String path, String value) {
        JsonUpdatePartial patch = new JsonUpdatePartial();
        patch.setOp(JsonUpdateOperation.REPLACE);
        patch.setPath(path);
        patch.setValue(value);
        return patch;
    }

    private List<PessoaEnderecoDTO> obterEnderecosValidos(br.com.elotech.tributos.dto.PessoaDTO pessoaDTO) {
        IncluirPessoaRequestDTO incluirPessoaRequest = IncluirPessoaRequestDTO.from((br.com.elotech.tributos.dto.PessoaDTO)pessoaDTO);
        List enderecos = this.getPessoaEnderecosDTO(incluirPessoaRequest);
        if (enderecos.isEmpty()) {
            throw new EloValidationException("N\u00e3o foi poss\u00edvel atualizar o endere\u00e7o, pois n\u00e3o h\u00e1 endere\u00e7os informados.");
        }
        return enderecos;
    }

    private void ativarContribuinte(Long idUnico) {
        PessoaDTO pessoaAtivada = this.pessoaClient.ativaContribuinte(idUnico);
        this.pessoaRepository.findByIdUnico(pessoaAtivada.getId()).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel ativar o contribuinte atrav\u00e9s do \u00danico %d", pessoaAtivada.getId())));
    }

    private Pessoa obterPessoaLocalOuErro(Long idUnico) {
        return (Pessoa)this.pessoaRepository.findByIdUnico(idUnico).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel alterar o endere\u00e7o do contribuinte atrav\u00e9s do \u00danico %d", idUnico)));
    }

    public Boolean isCodigoAlvaraValido(String cnpj, String codigoValidador) {
        return this.pessoaRepository.existsByCnpjCpfAndCodigoLiberacaoSgo(cnpj, codigoValidador);
    }
}

