/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.unico;

import br.com.elotech.tributos.security.AuthenticationClientUnico;
import br.com.elotech.unico.client.BairroFeignClient;
import br.com.elotech.unico.client.dto.BairroDTO;
import br.com.elotech.unico.exception.UnicoClientException;
import feign.FeignException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BairroClientUnico {
    private static final Logger LOGGER = LoggerFactory.getLogger(BairroClientUnico.class);
    private static final String MSGAUTENTICADOSUCESSO = "Autenticado no \u00fanico com sucesso";
    private final BairroFeignClient bairroFeignClient;
    private final AuthenticationClientUnico authClient;

    public BairroClientUnico(BairroFeignClient bairroFeignClient, AuthenticationClientUnico authenticationClient) {
        this.bairroFeignClient = bairroFeignClient;
        this.authClient = authenticationClient;
    }

    public BairroDTO saveBairro(BairroDTO bairroDTO) {
        try {
            String token = this.authClient.authenticateAndReturnToken();
            LOGGER.debug(MSGAUTENTICADOSUCESSO);
            return this.bairroFeignClient.saveBairro(token, bairroDTO);
        }
        catch (FeignException ex) {
            LOGGER.error("Erro inesperado ao salvar o bairro no \u00fanico. [{}]\nResponse: {}", new Object[]{ex.getMessage(), ex.contentUTF8(), ex});
            LOGGER.error("BairroDTO. [{}]", (Object)bairroDTO);
            throw new UnicoClientException("N\u00e3o foi poss\u00edvel inserir o novo bairro no \u00fanico", (Throwable)ex);
        }
    }
}

