/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.supersimples.pgfn;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.JobType;
import java.util.Date;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ProcessamentoArquivoPgfnJobStarter {
    private final JobLauncher jobLauncher;
    private final JobExplorer jobExplorer;
    private final Job processamentorquivoPgfnJob;

    public ProcessamentoArquivoPgfnJobStarter(JobLauncher jobLauncher, JobExplorer jobExplorer, @Qualifier(value="processamentoArquivoPgfnBatchJob") Job processamentoArquivoPgfnJob) {
        this.jobLauncher = jobLauncher;
        this.jobExplorer = jobExplorer;
        this.processamentorquivoPgfnJob = processamentoArquivoPgfnJob;
    }

    public JobExecution startJob(Long idArquivoPgfn) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        this.validate(idArquivoPgfn);
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addLong("idArquivoPgfn", idArquivoPgfn, true);
        jobParametersBuilder.addDate("date", new Date());
        return this.jobLauncher.run(this.processamentorquivoPgfnJob, jobParametersBuilder.toJobParameters());
    }

    private void validate(Long idArquivoPgfn) {
        this.validaSeTemVerificacaoExecutando(idArquivoPgfn);
        this.validaSeTemProcessamentoExecutando(idArquivoPgfn);
    }

    private void validaSeTemVerificacaoExecutando(Long idArquivoPgfn) {
        boolean exists = this.jobExplorer.findRunningJobExecutions(JobType.VERIFICACAO_ARQUIVO_PGFN.getTipo()).stream().anyMatch(jobExecution -> {
            Long idArquivoPgfnRunning = jobExecution.getJobParameters().getLong("idArquivoPgfn");
            return idArquivoPgfn.equals(idArquivoPgfnRunning);
        });
        if (exists) {
            throw new EloValidationException("Esse arquivo j\u00e1 est\u00e1 sendo verificado");
        }
    }

    private void validaSeTemProcessamentoExecutando(Long idArquivoPgfn) {
        boolean exists = this.jobExplorer.findRunningJobExecutions(JobType.PROCESSAMENTO_ARQUIVO_PGFN.getTipo()).stream().anyMatch(jobExecution -> {
            Long idArquivoPgfnRunning = jobExecution.getJobParameters().getLong("idArquivoPgfn");
            return idArquivoPgfn.equals(idArquivoPgfnRunning);
        });
        if (exists) {
            throw new EloValidationException("Esse arquivo j\u00e1 est\u00e1 processando para gerar d\u00e9bitos");
        }
    }
}

