/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.supersimples.pgfn;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.supersimples.pgfn.PgfnConfiguracao;
import br.com.elotech.tributos.dto.supersimples.pgfn.PgfnConfiguracaoDTO;
import br.com.elotech.tributos.repository.supersimples.pgfn.PgfnConfiguracaoRepository;
import br.com.elotech.tributos.service.ContextService;
import java.time.LocalDate;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PgfnConfiguracaoService {
    private final PgfnConfiguracaoRepository pgfnConfiguracaoRepository;
    private final ContextService contextService;

    public PgfnConfiguracao findByEntidadeAndExercicio(Long entidade, Long exercicio) {
        return this.pgfnConfiguracaoRepository.findByEntidadeAndExercicio(entidade, exercicio);
    }

    public PgfnConfiguracao findByEntidadePrincipalAndExercicioAtual() {
        return this.pgfnConfiguracaoRepository.findByEntidadeAndExercicio(this.contextService.getEntidadePrincipal(), Long.valueOf(LocalDate.now().getYear()));
    }

    @Transactional
    public PgfnConfiguracao save(PgfnConfiguracaoDTO pgfnConfiguracaoDTO) {
        return (PgfnConfiguracao)this.pgfnConfiguracaoRepository.save((Object)pgfnConfiguracaoDTO.toEntity());
    }

    public void validateConfiguracao() {
        PgfnConfiguracao pgfnConfiguracao = this.findByEntidadePrincipalAndExercicioAtual();
        if (pgfnConfiguracao == null) {
            throw new EloValidationException("As configura\u00e7\u00f5es para gera\u00e7\u00e3o dos d\u00e9bitos est\u00e1 inv\u00e1lida.");
        }
        if (!this.isValidConfigIss(pgfnConfiguracao)) {
            throw new EloValidationException("Configura\u00e7\u00f5es incorretas para o tributo ISS.");
        }
        if (!this.isValidConfigIcms(pgfnConfiguracao)) {
            throw new EloValidationException("Configura\u00e7\u00f5es incorretas para o tributo ICMS.");
        }
    }

    private boolean isValidConfigIss(PgfnConfiguracao pgfnConfiguracao) {
        return pgfnConfiguracao.getDividaIss() != null || pgfnConfiguracao.getTributoIss() != null || pgfnConfiguracao.getFormaPagamentoIss() != null;
    }

    private boolean isValidConfigIcms(PgfnConfiguracao pgfnConfiguracao) {
        return pgfnConfiguracao.getDividaIcms() != null || pgfnConfiguracao.getTributoIcms() != null || pgfnConfiguracao.getFormaPagamentoIcms() != null;
    }

    @Generated
    public PgfnConfiguracaoService(PgfnConfiguracaoRepository pgfnConfiguracaoRepository, ContextService contextService) {
        this.pgfnConfiguracaoRepository = pgfnConfiguracaoRepository;
        this.contextService = contextService;
    }
}

