/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.supersimples;

import br.com.elotech.arquivos.client.ArquivoClient;
import br.com.elotech.arquivos.domain.request.ArquivoDownloadRequest;
import br.com.elotech.arquivos.domain.support.Tenant;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacao;
import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacaoVarredura;
import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacaoVarreduraId;
import br.com.elotech.tributos.enums.supersimples.TipoOperacaoSuperSimplesSolicitacao;
import br.com.elotech.tributos.repository.supersimples.SuperSimplesSolicitacaoVarreduraRepository;
import br.com.elotech.tributos.service.resolvers.ResolversHandler;
import java.time.LocalDate;
import java.util.List;
import java.util.UUID;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;

@Service
public class SuperSimplesSolicitacaoVarreduraService
extends CrudService<SuperSimplesSolicitacaoVarredura, SuperSimplesSolicitacaoVarreduraId> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SuperSimplesSolicitacaoVarreduraService.class);
    private final SuperSimplesSolicitacaoVarreduraRepository repository;
    private final EntityManager entityManager;
    private final ResolversHandler resolversHandler;

    public SuperSimplesSolicitacaoVarredura createVarredura(Long idSolicitacao, String usuario, TipoOperacaoSuperSimplesSolicitacao tipoOperacao) {
        SuperSimplesSolicitacao solicitacao = (SuperSimplesSolicitacao)this.entityManager.getReference(SuperSimplesSolicitacao.class, (Object)idSolicitacao);
        SuperSimplesSolicitacaoVarreduraId varreduraId = this.createVarreduraId(solicitacao);
        SuperSimplesSolicitacaoVarredura varredura = new SuperSimplesSolicitacaoVarredura();
        varredura.setId(varreduraId);
        varredura.setData(LocalDate.now());
        varredura.setUsuario(usuario);
        varredura.setTipoOperacao(tipoOperacao.getDescricao());
        return (SuperSimplesSolicitacaoVarredura)this.save((EloEntity)varredura, null);
    }

    private SuperSimplesSolicitacaoVarreduraId createVarreduraId(SuperSimplesSolicitacao solicitacao) {
        SuperSimplesSolicitacaoVarreduraId varreduraId = new SuperSimplesSolicitacaoVarreduraId();
        varreduraId.setSolicitacao(solicitacao);
        varreduraId.setSequenciaVarredura(Long.valueOf(this.getNextSequenceNumber(solicitacao.getId())));
        return varreduraId;
    }

    private long getNextSequenceNumber(Long idSolicitacao) {
        return this.repository.findMaxSequenciaVarreduraBySolicitacaoId(idSolicitacao) + 1L;
    }

    public List<SuperSimplesSolicitacaoVarredura> findByIdSolicitacao(Long idSolicitacao, Sort sort) {
        return this.repository.findByIdSolicitacaoId(idSolicitacao, sort);
    }

    public String getUrlArquivoVarredura(UUID idArquivo) {
        ArquivoDownloadRequest arquivoDownloadRequest = ArquivoDownloadRequest.create((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (String)("oxy_tributos/" + idArquivo.toString()));
        return this.resolveArquivoClient().gerarUrlParaGet(arquivoDownloadRequest).getUrlAssinada();
    }

    private ArquivoClient resolveArquivoClient() {
        return this.resolversHandler.getArquivoClientMinio();
    }

    @Generated
    public SuperSimplesSolicitacaoVarreduraService(SuperSimplesSolicitacaoVarreduraRepository repository, EntityManager entityManager, ResolversHandler resolversHandler) {
        this.repository = repository;
        this.entityManager = entityManager;
        this.resolversHandler = resolversHandler;
    }
}

