/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.supersimples;

import br.com.elotech.arquivos.client.ArquivoClient;
import br.com.elotech.arquivos.domain.Arquivo;
import br.com.elotech.arquivos.domain.request.ArquivoNovoRequest;
import br.com.elotech.arquivos.domain.support.ContentType;
import br.com.elotech.arquivos.domain.support.Tenant;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.common.dto.EntidadeInfo;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacao;
import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacaoCnpj;
import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacaoSituacao;
import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacaoSituacaoId;
import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacaoVedados;
import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacaoVedadosId;
import br.com.elotech.tributos.dto.supersimples.SuperSimplesSolicitacaoCadastroDTO;
import br.com.elotech.tributos.dto.supersimples.SuperSimplesSolicitacaoCnpjDTO;
import br.com.elotech.tributos.enums.supersimples.TipoOperacaoSuperSimplesSolicitacao;
import br.com.elotech.tributos.repository.supersimples.ConsultaSuperSimplesCNPJVarreduraAnualRepository;
import br.com.elotech.tributos.repository.supersimples.SuperSimplesSolicitacaoVedadosRepository;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.resolvers.ResolversHandler;
import br.com.elotech.tributos.service.supersimples.ArquivoCnpjVedadosSuperSimples;
import br.com.elotech.tributos.util.ListUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.time.LocalDate;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ProcessamentoSuperSimplesService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessamentoSuperSimplesService.class);
    private static final String MENSAGEM_CADASTRO_NAO_ENCONTRADO = "CNPJ n\u00e3o possui cadastro(s)";
    private final ConsultaSuperSimplesCNPJVarreduraAnualRepository superSimplesCNPJVarreduraAnualRepository;
    private final SuperSimplesSolicitacaoVedadosRepository superSimplesSolicitacaoVedadosRepository;
    private final ParametroGeralService parametroGeralService;
    private final ResolversHandler resolversHandler;
    private final EntityManager entityManager;
    private final ContextService contextService;

    public SuperSimplesSolicitacaoSituacao processarVarreduraBatch(SuperSimplesSolicitacaoCnpj item, Long idSolicitacao, long sequenciaVarredura, TipoOperacaoSuperSimplesSolicitacao tipoOperacao) {
        SuperSimplesSolicitacao solicitacao = (SuperSimplesSolicitacao)this.entityManager.getReference(SuperSimplesSolicitacao.class, (Object)idSolicitacao);
        SuperSimplesSolicitacaoSituacao superSimplesSolicitacaoSituacao = this.createSolicitacaoSituacao(solicitacao, Long.valueOf(sequenciaVarredura), item.getId().getSequencia(), tipoOperacao.getDescricao());
        String ocorrencia = this.getOcorrencia(item);
        if (ocorrencia.isEmpty()) {
            superSimplesSolicitacaoSituacao.setOcorrencia(null);
            this.processarSolicitacaoSemOcorrencia(item, solicitacao, item.getId().getSequencia().longValue(), tipoOperacao);
        } else {
            superSimplesSolicitacaoSituacao.setOcorrencia(ocorrencia);
            this.processarSolicitacaoComOcorrencia(superSimplesSolicitacaoSituacao, item, solicitacao, sequenciaVarredura, item.getId().getSequencia().longValue(), tipoOperacao);
        }
        return superSimplesSolicitacaoSituacao;
    }

    public void processarSolicitacaoSemOcorrencia(SuperSimplesSolicitacaoCnpj item, SuperSimplesSolicitacao solicitacao, long sequencia, TipoOperacaoSuperSimplesSolicitacao tipoOperacao) {
        if (TipoOperacaoSuperSimplesSolicitacao.EXCLUSAO.equals((Object)tipoOperacao)) {
            this.deletarSolicitacaoVedado(solicitacao.getId(), sequencia, item.getCnpj());
        }
    }

    public void processarSolicitacaoComOcorrencia(SuperSimplesSolicitacaoSituacao superSimplesSolicitacaoSituacao, SuperSimplesSolicitacaoCnpj item, SuperSimplesSolicitacao solicitacao, long sequenciaVarredura, long sequencia, TipoOperacaoSuperSimplesSolicitacao tipoOperacao) {
        if (TipoOperacaoSuperSimplesSolicitacao.INICIAL.equals((Object)tipoOperacao) || TipoOperacaoSuperSimplesSolicitacao.COMPLEMENTAR.equals((Object)tipoOperacao)) {
            SuperSimplesSolicitacaoVedados superSimplesSolicitacaoVedados = this.createSolicitacaoVedados(solicitacao, Long.valueOf(sequenciaVarredura), Long.valueOf(sequencia), item.getCnpj());
            superSimplesSolicitacaoVedados.setSolicitacaoSituacao(superSimplesSolicitacaoSituacao);
            superSimplesSolicitacaoSituacao.getVedados().add(superSimplesSolicitacaoVedados);
        }
    }

    public void deletarSolicitacaoVedado(Long idSolicitacao, long sequencia, String cnpj) {
        List vedadosList = this.superSimplesSolicitacaoVedadosRepository.findByIdSolicitacaoIdAndIdSequenciaAndCnpj(idSolicitacao, Long.valueOf(sequencia), cnpj);
        this.superSimplesSolicitacaoVedadosRepository.deleteAll((Iterable)vedadosList);
    }

    public SuperSimplesSolicitacaoSituacao createSolicitacaoSituacao(SuperSimplesSolicitacao solicitacao, Long sequenciaVarredura, Long sequencia, String tipoOperacao) {
        SuperSimplesSolicitacaoSituacaoId superSimplesSolicitacaoSituacaoId = new SuperSimplesSolicitacaoSituacaoId();
        superSimplesSolicitacaoSituacaoId.setSolicitacao(solicitacao);
        superSimplesSolicitacaoSituacaoId.setSequenciaVarredura(sequenciaVarredura);
        superSimplesSolicitacaoSituacaoId.setSequencia(sequencia);
        SuperSimplesSolicitacaoSituacao superSimplesSolicitacaoSituacao = new SuperSimplesSolicitacaoSituacao();
        superSimplesSolicitacaoSituacao.setId(superSimplesSolicitacaoSituacaoId);
        superSimplesSolicitacaoSituacao.setTipoOperacao(tipoOperacao);
        return superSimplesSolicitacaoSituacao;
    }

    public SuperSimplesSolicitacaoVedados createSolicitacaoVedados(SuperSimplesSolicitacao solicitacao, Long sequenciaVarredura, Long sequencia, String cnpj) {
        SuperSimplesSolicitacaoVedadosId superSimplesSolicitacaoVedadosId = new SuperSimplesSolicitacaoVedadosId();
        superSimplesSolicitacaoVedadosId.setSolicitacao(solicitacao);
        superSimplesSolicitacaoVedadosId.setSequenciaVarredura(sequenciaVarredura);
        superSimplesSolicitacaoVedadosId.setSequencia(sequencia);
        SuperSimplesSolicitacaoVedados superSimplesSolicitacaoVedados = new SuperSimplesSolicitacaoVedados();
        superSimplesSolicitacaoVedados.setId(superSimplesSolicitacaoVedadosId);
        superSimplesSolicitacaoVedados.setCnpj(cnpj);
        return superSimplesSolicitacaoVedados;
    }

    private String retiraDuplicacao(String ocorrencias) {
        String[] partes = ocorrencias.split(" - ");
        LinkedHashSet ocorrenciasSemDuplicacao = new LinkedHashSet();
        Collections.addAll(ocorrenciasSemDuplicacao, partes);
        return String.join((CharSequence)" - ", ocorrenciasSemDuplicacao);
    }

    public String getOcorrencia(SuperSimplesSolicitacaoCnpj item) {
        EntidadeInfo entidade = this.contextService.getEntidadePrincipalInfo();
        Boolean isValidaTodosCadastros = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.VALIDA_TODOS_CADASTROS_CNPJ_VEDADO);
        List cadastros = this.superSimplesCNPJVarreduraAnualRepository.loadCadastros(item, isValidaTodosCadastros);
        StringBuilder ocorrenciaCadastros = new StringBuilder();
        if (this.isCnpjSemCadastros(cadastros)) {
            return MENSAGEM_CADASTRO_NAO_ENCONTRADO;
        }
        for (SuperSimplesSolicitacaoCadastroDTO cadastro : cadastros) {
            String ocorrencia = this.superSimplesCNPJVarreduraAnualRepository.loadOcorrencia(entidade.getId(), cadastro.getTipoCadastro(), cadastro.getCadastroGeral(), LocalDate.now(), isValidaTodosCadastros);
            if (ocorrencia == null || ocorrencia.isEmpty()) continue;
            ocorrenciaCadastros.append(" - ").append(ocorrencia);
        }
        return this.retiraDuplicacao(ocorrenciaCadastros.toString());
    }

    public boolean isCnpjSemCadastros(List<SuperSimplesSolicitacaoCadastroDTO> cadastros) {
        return cadastros.isEmpty();
    }

    public Arquivo uploadArquivoCnpjVedados(String tipoOperacao, List<SuperSimplesSolicitacaoCnpjDTO> solicitacaoCnpjs) {
        log.debug("Iniciando gera\u00e7\u00e3o do arquivo cnpj vedados {} do super simples", (Object)tipoOperacao);
        ArquivoCnpjVedadosSuperSimples arquivoCnpjVedados = new ArquivoCnpjVedadosSuperSimples(tipoOperacao);
        arquivoCnpjVedados.gerarCabecalho(tipoOperacao);
        int quantidadeTotalCnpjs = solicitacaoCnpjs.size();
        ListUtils.forEachWithCounter(solicitacaoCnpjs, (index, item) -> {
            log.trace("Inserindo dados do item {}/{}", index, (Object)quantidadeTotalCnpjs);
            arquivoCnpjVedados.gerarDetalhe(item.getCnpj());
        });
        arquivoCnpjVedados.gerarRodape();
        arquivoCnpjVedados.finalizarGeracaoArquivo();
        log.debug("Finalizou montagem do arquivo cnpj vedados {} do super simples", (Object)tipoOperacao);
        ArquivoNovoRequest arquivoNovoRequest = ArquivoNovoRequest.builder((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (Modulo)Modulo.OXY_TRIBUTOS).fileName(arquivoCnpjVedados.getNomeArquivo()).content((InputStream)new ByteArrayInputStream(arquivoCnpjVedados.getOutStream().toByteArray())).contentType(ContentType.APPLICATION_ZIP).build();
        Arquivo arquivo = this.resolveArquivoClient().criarArquivo(arquivoNovoRequest);
        log.debug("Finalizado upload para o s3 do arquivo cnpj vedados {} do super simples", (Object)tipoOperacao);
        return arquivo;
    }

    private ArquivoClient resolveArquivoClient() {
        return this.resolversHandler.getArquivoClientMinio();
    }

    @Generated
    public ProcessamentoSuperSimplesService(ConsultaSuperSimplesCNPJVarreduraAnualRepository superSimplesCNPJVarreduraAnualRepository, SuperSimplesSolicitacaoVedadosRepository superSimplesSolicitacaoVedadosRepository, ParametroGeralService parametroGeralService, ResolversHandler resolversHandler, EntityManager entityManager, ContextService contextService) {
        this.superSimplesCNPJVarreduraAnualRepository = superSimplesCNPJVarreduraAnualRepository;
        this.superSimplesSolicitacaoVedadosRepository = superSimplesSolicitacaoVedadosRepository;
        this.parametroGeralService = parametroGeralService;
        this.resolversHandler = resolversHandler;
        this.entityManager = entityManager;
        this.contextService = contextService;
    }
}

